/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public final class PosTagHelper {
    private static final Pattern NUM_REGEX = Pattern.compile("(noun:(?:in)?anim|numr|adj|adjp.*):(.):v_.*");
    private static final Pattern CONJ_REGEX = Pattern.compile("(noun:(?:in)?anim|numr|adj|adjp.*):[mfnp]:(v_...).*");
    private static final Pattern GENDER_REGEX = NUM_REGEX;
    private static final Pattern GENDER_CONJ_REGEX = Pattern.compile("(noun:(?:in)?anim|adj|numr|adjp.*):(.:v_...).*");
    public static final Map<String, String> VIDMINKY_MAP;

    private PosTagHelper() {
    }

    @Nullable
    public static String getGender(String posTag) {
        Matcher pos4matcher = GENDER_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            return pos4matcher.group(2);
        }
        return null;
    }

    @Nullable
    public static String getNum(String posTag) {
        Matcher pos4matcher = NUM_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            String group = pos4matcher.group(2);
            if (!group.equals("p")) {
                group = "s";
            }
            return group;
        }
        return null;
    }

    @Nullable
    public static String getConj(String posTag) {
        Matcher pos4matcher = CONJ_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            return pos4matcher.group(2);
        }
        return null;
    }

    @Nullable
    public static String getGenderConj(String posTag) {
        Matcher pos4matcher = GENDER_CONJ_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            return pos4matcher.group(2);
        }
        return null;
    }

    public static boolean hasPosTag(AnalyzedTokenReadings analyzedTokenReadings, String posTagRegex) {
        return PosTagHelper.hasPosTag(analyzedTokenReadings.getReadings(), posTagRegex);
    }

    public static boolean hasPosTag(Collection<AnalyzedToken> analyzedTokenReadings, String posTagRegex) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            if (!PosTagHelper.hasPosTag(analyzedToken, posTagRegex)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPosTag(AnalyzedToken analyzedToken, String posTagRegex) {
        String posTag = analyzedToken.getPOSTag();
        return posTag != null && posTag.matches(posTagRegex);
    }

    public static String getGenders(AnalyzedTokenReadings tokenReadings, String posTagRegex) {
        Pattern posTagPattern = Pattern.compile(posTagRegex);
        StringBuilder sb = new StringBuilder(4);
        for (AnalyzedToken tokenReading : tokenReadings) {
            String gender;
            String posTag = tokenReading.getPOSTag();
            if (!posTagPattern.matcher(posTag).matches() || sb.indexOf(gender = PosTagHelper.getGender(posTag)) != -1) continue;
            sb.append(gender);
        }
        return sb.toString();
    }

    static {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("v_naz", "\u043d\u0430\u0437\u0438\u0432\u043d\u0438\u0439");
        map.put("v_rod", "\u0440\u043e\u0434\u043e\u0432\u0438\u0439");
        map.put("v_dav", "\u0434\u0430\u0432\u0430\u043b\u044c\u043d\u0438\u0439");
        map.put("v_zna", "\u0437\u043d\u0430\u0445\u0456\u0434\u043d\u0438\u0439");
        map.put("v_oru", "\u043e\u0440\u0443\u0434\u043d\u0438\u0439");
        map.put("v_mis", "\u043c\u0456\u0441\u0446\u0435\u0432\u0438\u0439");
        map.put("v_kly", "\u043a\u043b\u0438\u0447\u043d\u0438\u0439");
        VIDMINKY_MAP = Collections.unmodifiableMap(map);
    }
}

