/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import org.htmlparser.Node;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasParentFilter;
import org.htmlparser.filters.IsEqualFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.filters.NotFilter;
import org.htmlparser.filters.OrFilter;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableHeader;
import org.htmlparser.util.NodeList;

public class TableRow
extends CompositeTag {
    private static final String[] mIds = new String[]{"TR"};
    private static final String[] mEnders = new String[]{"TBODY", "TFOOT", "THEAD"};
    private static final String[] mEndTagEnders = new String[]{"TBODY", "TFOOT", "THEAD", "TABLE"};

    @Override
    public String[] getIds() {
        return mIds;
    }

    @Override
    public String[] getEnders() {
        return mEnders;
    }

    @Override
    public String[] getEndTagEnders() {
        return mEndTagEnders;
    }

    public TableColumn[] getColumns() {
        Node[] ret;
        NodeList kids = this.getChildren();
        if (null != kids) {
            NodeClassFilter cls = new NodeClassFilter(TableRow.class);
            HasParentFilter recursion = new HasParentFilter(null);
            OrFilter filter = new OrFilter(new AndFilter(cls, new IsEqualFilter(this)), new AndFilter(new NotFilter(cls), recursion));
            recursion.setParentFilter(filter);
            kids = kids.extractAllNodesThatMatch(new AndFilter(new NodeClassFilter(TableColumn.class), filter), true);
            ret = new TableColumn[kids.size()];
            kids.copyToNodeArray(ret);
        } else {
            ret = new TableColumn[]{};
        }
        return ret;
    }

    public int getColumnCount() {
        return this.getColumns().length;
    }

    public TableHeader[] getHeaders() {
        Node[] ret;
        NodeList kids = this.getChildren();
        if (null != kids) {
            NodeClassFilter cls = new NodeClassFilter(TableRow.class);
            HasParentFilter recursion = new HasParentFilter(null);
            OrFilter filter = new OrFilter(new AndFilter(cls, new IsEqualFilter(this)), new AndFilter(new NotFilter(cls), recursion));
            recursion.setParentFilter(filter);
            kids = kids.extractAllNodesThatMatch(new AndFilter(new NodeClassFilter(TableHeader.class), filter), true);
            ret = new TableHeader[kids.size()];
            kids.copyToNodeArray(ret);
        } else {
            ret = new TableHeader[]{};
        }
        return ret;
    }

    public int getHeaderCount() {
        return this.getHeaders().length;
    }

    public boolean hasHeader() {
        return 0 != this.getHeaderCount();
    }
}

