/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.align;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.omegat.gui.align.EditingPanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class SplittingPanelController {
    private final String text;
    private final String reference;
    private int splitOffset = -1;

    public SplittingPanelController(String text, String reference) {
        this.text = text;
        this.reference = reference;
    }

    public String[] show(Window parent) {
        final JDialog dialog = new JDialog(parent, OStrings.getString("ALIGNER_DIALOG_SPLITTER"), Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SplittingPanelController.this.doCancel(dialog);
            }
        });
        StaticUIUtils.setEscapeClosable(dialog);
        final EditingPanel panel = new EditingPanel();
        panel.editorPane.setEditable(false);
        panel.editorPane.setText(this.text);
        StaticUIUtils.makeCaretAlwaysVisible(panel.editorPane);
        panel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplittingPanelController.this.splitOffset = panel.editorPane.getCaretPosition();
                dialog.dispose();
            }
        });
        panel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplittingPanelController.this.doCancel(dialog);
            }
        });
        panel.okButton.setEnabled(false);
        panel.editorPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                panel.okButton.setEnabled(e.getDot() == e.getMark() && e.getDot() > 0 && e.getDot() < SplittingPanelController.this.text.length());
            }
        });
        panel.editorPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    panel.okButton.doClick();
                }
            }
        });
        if (this.reference != null) {
            JPanel referencePanel = new JPanel(new BorderLayout());
            JTextArea textArea = new JTextArea(this.reference);
            textArea.setOpaque(false);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setEditable(false);
            textArea.setFocusable(false);
            referencePanel.add(textArea);
            referencePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            panel.add((Component)referencePanel, "North");
        }
        panel.helpText.setText(OStrings.getString("ALIGNER_DIALOG_SPLITTER_HELP"));
        dialog.add(panel);
        dialog.getRootPane().setDefaultButton(panel.okButton);
        dialog.setMinimumSize(new Dimension(450, 250));
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (this.splitOffset == -1) {
            return new String[]{this.text};
        }
        return new String[]{this.text.substring(0, this.splitOffset).trim(), this.text.substring(this.splitOffset, this.text.length()).trim()};
    }

    private void doCancel(JDialog dialog) {
        this.splitOffset = -1;
        dialog.dispose();
    }
}

