/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.filter.ReplaceFilter;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.editor.mark.TransparentHighlightPainter;
import org.omegat.util.gui.Styles;

public class ReplaceMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter PAINTER = new TransparentHighlightPainter(Styles.EditorColor.COLOR_REPLACE.getColor(), 0.4f);

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        IEditorFilter filter = Core.getEditor().getFilter();
        if (filter == null || !(filter instanceof ReplaceFilter)) {
            return Collections.emptyList();
        }
        ReplaceFilter replaceFilter = (ReplaceFilter)filter;
        List<SearchMatch> matches = replaceFilter.getReplacementsForEntry(translationText);
        if (matches == null) {
            return Collections.emptyList();
        }
        ArrayList<Mark> r = new ArrayList<Mark>(matches.size());
        for (SearchMatch s : matches) {
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, s.getStart(), s.getEnd());
            m.painter = PAINTER;
            r.add(m);
        }
        return r;
    }
}

