/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.dict.zip.DictZipHeader;
import org.dict.zip.RandomAccessOutputStream;

public class DictZipOutputStream
extends FilterOutputStream {
    protected Deflater def;
    protected byte[] buf;
    protected CRC32 crc;
    private int cindex;
    private boolean closed = false;
    private final long dataSize;
    private long wroteInChunk;
    private final DictZipHeader header;
    private boolean usesDefaultDeflater = false;
    private static final int BUF_LEN = 58315;
    private static final int TRAILER_SIZE = 8;

    public DictZipOutputStream(RandomAccessOutputStream out, long size) throws IOException, IllegalArgumentException {
        this(out, 58315, size);
    }

    public DictZipOutputStream(RandomAccessOutputStream out, int buflen, long size) throws IOException, IllegalArgumentException {
        this(out, buflen, size, -1);
    }

    public DictZipOutputStream(RandomAccessOutputStream out, int buflen, long size, int level) throws IOException, IllegalArgumentException {
        this(out, new Deflater(level, true), buflen, size, level);
        this.usesDefaultDeflater = true;
    }

    public DictZipOutputStream(RandomAccessOutputStream out, Deflater defl, int inBufferSize, long size, int level) throws IOException, IllegalArgumentException {
        super(out);
        if (out == null || defl == null) {
            throw new NullPointerException();
        }
        if (inBufferSize <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        if (inBufferSize > 58969) {
            throw new IllegalArgumentException("buffer size > 64kB/1.1 - 12");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("total data size <= 0");
        }
        this.wroteInChunk = 0L;
        this.def = defl;
        int outBufferSize = (int)((double)(inBufferSize + 12) * 1.1);
        this.buf = new byte[outBufferSize];
        this.dataSize = size;
        this.crc = new CRC32();
        this.header = new DictZipHeader(this.dataSize, inBufferSize);
        this.header.setMtime(System.currentTimeMillis() / 1000L);
        switch (level) {
            case -1: {
                this.header.setExtraFlag(DictZipHeader.CompressionLevel.DEFAULT_COMPRESSION);
                defl.setLevel(level);
                break;
            }
            case 9: {
                this.header.setExtraFlag(DictZipHeader.CompressionLevel.BEST_COMPRESSION);
                defl.setLevel(level);
                break;
            }
            case 1: {
                this.header.setExtraFlag(DictZipHeader.CompressionLevel.BEST_SPEED);
                defl.setLevel(level);
                break;
            }
            default: {
                this.header.setExtraFlag(DictZipHeader.CompressionLevel.DEFAULT_COMPRESSION);
                defl.setLevel(-1);
            }
        }
        this.header.setHeaderOS(DictZipHeader.OperatingSystem.UNIX);
        this.writeHeader(out);
        this.crc.reset();
        this.cindex = 0;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            if (this.out instanceof RandomAccessOutputStream) {
                RandomAccessOutputStream raout = (RandomAccessOutputStream)this.out;
                raout.seek(0L);
                this.writeHeader(raout);
            }
            if (this.usesDefaultDeflater) {
                this.def.end();
            }
            this.out.close();
            this.closed = true;
        }
    }

    protected void deflate() throws IOException {
        this.crc.update(this.buf, 0, this.buf.length);
        int len = this.def.deflate(this.buf, 0, this.buf.length, 3);
        if (len > 58969) {
            throw new IOException("Invalid size of chunk: Compressed chunked data size is larger than 64kB.");
        }
        if (len > 0) {
            this.out.write(this.buf, 0, len);
            this.header.chunks[this.cindex] = len;
            ++this.cindex;
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.def.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if ((long)(this.def.getTotalIn() + len) > this.dataSize) {
            throw new IOException("write beyond decelerated data size");
        }
        if (len == 0) {
            return;
        }
        if (!this.def.finished()) {
            int chunkLength = this.header.getChunkLength();
            int idx = 0;
            int writeSize = Math.min(chunkLength, len);
            while (writeSize > 0) {
                this.def.setInput(b, off + idx, writeSize);
                this.wroteInChunk += (long)writeSize;
                idx += writeSize;
                if (this.wroteInChunk == (long)chunkLength) {
                    while (!this.def.needsInput()) {
                        this.deflate();
                    }
                    this.wroteInChunk = 0L;
                }
                writeSize = Math.min(chunkLength, len - idx);
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        byte[] buf1 = new byte[]{(byte)(b & 0xFF)};
        this.write(buf1, 0, 1);
    }

    public final void finish() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed!");
        }
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && len <= this.buf.length - 8) {
                    this.writeTrailer(this.buf, len);
                    this.out.write(this.buf, 0, len += 8);
                    return;
                }
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
        }
        byte[] trailer = new byte[8];
        this.writeTrailer(trailer, 0);
        this.out.write(trailer);
    }

    private void writeHeader(RandomAccessOutputStream raout) throws IOException {
        DictZipHeader.writeHeader(this.header, raout);
    }

    private void writeTrailer(byte[] b, int offset) throws IOException {
        this.writeInt((int)this.crc.getValue(), b, offset);
        this.writeInt(this.def.getTotalIn(), b, offset + 4);
    }

    private void writeInt(int i, byte[] b, int offset) throws IOException {
        this.writeShort(i & 0xFFFF, b, offset);
        this.writeShort(i >> 16 & 0xFFFF, b, offset + 2);
    }

    private void writeShort(int s, byte[] b, int offset) throws IOException {
        b[offset] = (byte)(s & 0xFF);
        b[offset + 1] = (byte)(s >> 8 & 0xFF);
    }
}

