/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.JavaException;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;

public final class JavaBeans {
    private static final Primitive JGET_PROPERTY_VALUE = new pf__jget_property_value();
    private static final Primitive JSET_PROPERTY_VALUE = new pf__jset_property_value();

    static PropertyDescriptor getPropertyDescriptor(Object obj, LispObject propertyName) throws IntrospectionException {
        String prop = ((AbstractString)propertyName).getStringValue();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(prop)) continue;
            return pd;
        }
        Lisp.error(new LispError("Property " + prop + " not found in " + String.valueOf(obj)));
        return null;
    }

    @DocString(name="%jget-propety-value", args="java-object property-name", doc="Gets a JavaBeans property on JAVA-OBJECT.\nSYSTEM-INTERNAL: Use jproperty-value instead.")
    private static final class pf__jget_property_value
    extends Primitive {
        pf__jget_property_value() {
            super("%jget-property-value", Lisp.PACKAGE_JAVA, false, "java-object property-name");
        }

        @Override
        public LispObject execute(LispObject javaObject, LispObject propertyName) {
            try {
                Object obj = javaObject.javaInstance();
                PropertyDescriptor pd = JavaBeans.getPropertyDescriptor(obj, propertyName);
                Object value = pd.getReadMethod().invoke(obj, new Object[0]);
                if (value instanceof LispObject) {
                    return (LispObject)value;
                }
                if (value != null) {
                    return JavaObject.getInstance(value, true);
                }
                return Lisp.NIL;
            }
            catch (Exception e) {
                return Lisp.error(new JavaException(e));
            }
        }
    }

    @DocString(name="%jset-propety-value", args="java-object property-name value", doc="Sets a JavaBean property on JAVA-OBJECT.\nSYSTEM-INTERNAL: Use (setf jproperty-value) instead.")
    private static final class pf__jset_property_value
    extends Primitive {
        pf__jset_property_value() {
            super("%jset-property-value", Lisp.PACKAGE_JAVA, false, "java-object property-name value");
        }

        @Override
        public LispObject execute(LispObject javaObject, LispObject propertyName, LispObject value) {
            Object obj = null;
            try {
                obj = javaObject.javaInstance();
                PropertyDescriptor pd = JavaBeans.getPropertyDescriptor(obj, propertyName);
                Object jValue = value instanceof JavaObject ? value.javaInstance() : (Boolean.TYPE.equals(pd.getPropertyType()) || Boolean.class.equals(pd.getPropertyType()) ? Boolean.valueOf(value != Lisp.NIL) : (value != Lisp.NIL ? value.javaInstance() : null));
                pd.getWriteMethod().invoke(obj, jValue);
                return value;
            }
            catch (Exception e) {
                return Lisp.error(new JavaException(e));
            }
        }
    }
}

