/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.nio.file.attribute.FileTime;
import java.util.List;

final class CloudStoragePseudoDirectoryAttributes
implements CloudStorageFileAttributes {
    private final String id;

    CloudStoragePseudoDirectoryAttributes(CloudStoragePath path) {
        this.id = path.toUri().toString();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        return false;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public Object fileKey() {
        return this.id;
    }

    @Override
    public long size() {
        return 1L;
    }

    @Override
    public FileTime lastModifiedTime() {
        return CloudStorageFileSystem.FILE_TIME_UNKNOWN;
    }

    @Override
    public FileTime creationTime() {
        return CloudStorageFileSystem.FILE_TIME_UNKNOWN;
    }

    @Override
    public FileTime lastAccessTime() {
        return CloudStorageFileSystem.FILE_TIME_UNKNOWN;
    }

    @Override
    public Optional<String> etag() {
        return Optional.absent();
    }

    @Override
    public Optional<String> mimeType() {
        return Optional.absent();
    }

    @Override
    public Optional<List<Acl>> acl() {
        return Optional.absent();
    }

    @Override
    public Optional<String> cacheControl() {
        return Optional.absent();
    }

    @Override
    public Optional<String> contentEncoding() {
        return Optional.absent();
    }

    @Override
    public Optional<String> contentDisposition() {
        return Optional.absent();
    }

    public ImmutableMap<String, String> userMetadata() {
        return ImmutableMap.of();
    }
}

