#!/usr/bin/python

# Find out when the t_etfs test case started hanging

from bracket import *

use_current_repository()

def test_etfs_hang(ts):
    logfile_name = os.path.join(results_dir(ts), 'etfs_hang.log')
    return anita_run_1(ts, 'boot', logfile_name,
                       extra_anita_args = ['--run', 'cd /usr/tests/rump/rumpvfs && for i in 0 1 2 3 4 5 6 7 8 9; do atf-run t_etfs; done'])

find_failure(rcs2ts('2012.04.29.21.54.51'),
             rcs2ts('2012.04.29.22.54.01'),
             TestOp(test_etfs_hang,
                    [install_op],
                    name = 'etfs_hang'),
             confirm = True)
