/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import org.elasticsearch.xpack.sql.session.RowSet;
import org.elasticsearch.xpack.sql.util.Check;

public abstract class AbstractRowSet
implements RowSet {
    private boolean terminated = false;

    @Override
    public Object column(int index) {
        Check.isTrue(index >= 0, "Invalid index {}; needs to be positive", index);
        Check.isTrue(index < this.columnCount(), "Invalid index {} for row of size {}", index, this.columnCount());
        Check.isTrue(this.hasCurrentRow(), "RowSet contains no (more) entries; use hasCurrent() to check its status");
        return this.getColumn(index);
    }

    protected abstract Object getColumn(int var1);

    @Override
    public boolean hasCurrentRow() {
        return this.terminated ? false : this.doHasCurrent();
    }

    @Override
    public boolean advanceRow() {
        if (this.terminated) {
            return false;
        }
        if (!this.doNext()) {
            this.terminated = true;
            return false;
        }
        return true;
    }

    protected abstract boolean doHasCurrent();

    protected abstract boolean doNext();

    @Override
    public void reset() {
        this.terminated = false;
        this.doReset();
    }

    protected abstract void doReset();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasCurrentRow()) {
            for (int column = 0; column < this.columnCount(); ++column) {
                if (column > 0) {
                    sb.append("|");
                }
                String val = String.valueOf(this.getColumn(column));
                String[] split = val.split("\\n");
                for (int splitIndex = 0; splitIndex < split.length; ++splitIndex) {
                    if (splitIndex > 0) {
                        sb.append("\n");
                    }
                    String string = split[splitIndex];
                    sb.append(string);
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

