/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class RegularSequenceChecker
extends ProxyReceiver {
    private final Stack<Short> stack = new Stack();
    private State state = State.INITIAL;
    private boolean fullChecking = false;
    private static final Map<State, Map<Transition, State>> machine = new HashMap<State, Map<Transition, State>>();

    private static void edge(State from, Transition event, State to) {
        Map edges = machine.computeIfAbsent(from, s -> new HashMap());
        edges.put(event, to);
    }

    private void transition(Transition event) {
        Map<Transition, State> map = machine.get((Object)this.state);
        assert (map != null);
        if (!map.containsKey((Object)event)) {
            throw new IllegalStateException("Event " + (Object)((Object)event) + " is not permitted in state " + (Object)((Object)this.state));
        }
        this.state = map.get((Object)event);
    }

    public RegularSequenceChecker(Receiver nextReceiver, boolean fullChecking) {
        super(nextReceiver);
        this.fullChecking = fullChecking;
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        try {
            this.transition(Transition.APPEND);
            this.nextReceiver.append(item, locationId, copyNamespaces);
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.transition(Transition.TEXT);
        if (chars.isEmpty() && !this.stack.isEmpty()) {
            throw new IllegalStateException("Zero-length text nodes not allowed within document/element content");
        }
        try {
            this.nextReceiver.characters(chars, locationId, properties);
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.state != State.FINAL && this.state != State.FAILED) {
            if (!this.stack.isEmpty()) {
                throw new IllegalStateException("Unclosed element or document nodes at end of stream");
            }
            this.nextReceiver.close();
            this.state = State.FINAL;
        }
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.transition(Transition.COMMENT);
        try {
            this.nextReceiver.comment(chars, locationId, properties);
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void endDocument() throws XPathException {
        this.transition(Transition.END_DOCUMENT);
        if (this.stack.isEmpty() || this.stack.pop() != 9) {
            throw new IllegalStateException("Unmatched endDocument() call");
        }
        try {
            this.nextReceiver.endDocument();
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.transition(Transition.END_ELEMENT);
        if (this.stack.isEmpty() || this.stack.pop() != 1) {
            throw new IllegalStateException("Unmatched endElement() call");
        }
        if (this.stack.isEmpty()) {
            this.state = State.OPEN;
        }
        try {
            this.nextReceiver.endElement();
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void open() throws XPathException {
        this.transition(Transition.OPEN);
        try {
            this.nextReceiver.open();
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.transition(Transition.PI);
        try {
            this.nextReceiver.processingInstruction(target, data, locationId, properties);
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.transition(Transition.START_DOCUMENT);
        this.stack.push((short)9);
        try {
            this.nextReceiver.startDocument(properties);
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.transition(Transition.START_ELEMENT);
        this.stack.push((short)1);
        if (this.fullChecking) {
            attributes.verify();
            String prefix = elemName.getPrefix();
            if (prefix.isEmpty()) {
                String declaredDefaultUri = namespaces.getDefaultNamespace();
                if (!declaredDefaultUri.equals(elemName.getURI())) {
                    throw new IllegalStateException("URI of element Q{" + elemName.getURI() + "}" + elemName.getLocalPart() + " does not match declared default namespace {" + declaredDefaultUri + "}");
                }
            } else {
                String declaredUri = namespaces.getURI(prefix);
                if (declaredUri == null) {
                    throw new IllegalStateException("Prefix " + prefix + " has not been declared");
                }
                if (!declaredUri.equals(elemName.getURI())) {
                    throw new IllegalStateException("Prefix " + prefix + " is bound to the wrong namespace");
                }
            }
            for (AttributeInfo att : attributes) {
                NodeName name = att.getNodeName();
                if (name.getURI().isEmpty()) continue;
                String attPrefix = name.getPrefix();
                String declaredUri = namespaces.getURI(attPrefix);
                if (declaredUri == null) {
                    throw new IllegalStateException("Prefix " + attPrefix + " has not been declared for attribute " + att.getNodeName().getDisplayName());
                }
                if (declaredUri.equals(name.getURI())) continue;
                throw new IllegalStateException("Prefix " + prefix + " is bound to the wrong namespace {" + declaredUri + "}");
            }
        }
        try {
            this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
        }
        catch (XPathException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    static {
        RegularSequenceChecker.edge(State.INITIAL, Transition.OPEN, State.OPEN);
        RegularSequenceChecker.edge(State.OPEN, Transition.APPEND, State.OPEN);
        RegularSequenceChecker.edge(State.OPEN, Transition.TEXT, State.OPEN);
        RegularSequenceChecker.edge(State.OPEN, Transition.COMMENT, State.OPEN);
        RegularSequenceChecker.edge(State.OPEN, Transition.PI, State.OPEN);
        RegularSequenceChecker.edge(State.OPEN, Transition.START_DOCUMENT, State.CONTENT);
        RegularSequenceChecker.edge(State.OPEN, Transition.START_ELEMENT, State.CONTENT);
        RegularSequenceChecker.edge(State.CONTENT, Transition.TEXT, State.CONTENT);
        RegularSequenceChecker.edge(State.CONTENT, Transition.COMMENT, State.CONTENT);
        RegularSequenceChecker.edge(State.CONTENT, Transition.PI, State.CONTENT);
        RegularSequenceChecker.edge(State.CONTENT, Transition.START_ELEMENT, State.CONTENT);
        RegularSequenceChecker.edge(State.CONTENT, Transition.END_ELEMENT, State.CONTENT);
        RegularSequenceChecker.edge(State.CONTENT, Transition.END_DOCUMENT, State.OPEN);
        RegularSequenceChecker.edge(State.OPEN, Transition.CLOSE, State.FINAL);
        RegularSequenceChecker.edge(State.FAILED, Transition.CLOSE, State.FAILED);
    }

    private static enum Transition {
        OPEN,
        APPEND,
        TEXT,
        COMMENT,
        PI,
        START_DOCUMENT,
        START_ELEMENT,
        END_ELEMENT,
        END_DOCUMENT,
        CLOSE;

    }

    public static enum State {
        INITIAL,
        OPEN,
        START_TAG,
        CONTENT,
        FINAL,
        FAILED;

    }
}

