/* -*- Mode: C; c-file-style: "gnu" -*-
   signals.h -- API for native handling of UNIX signals
   Created: Petter Reinholdtsen <pere@td.org.uit.no>, 1998-05-21
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _signals_h
#define _signals_h

typedef void (*SIGNAL_handler)(int);

/*
 * Install handler to run when SIGBUS or SIGSEGV happends.  Signals is
 * restored to default before handler is called.
 */
void SIGNAL_install(SIGNAL_handler handler);
/* Dump core */
void SIGNAL_crash(void);

#endif /* _signals_h */
