/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.proxy;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.spdy.SPDYClient;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.Handler;
import org.eclipse.jetty.spdy.api.Headers;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.proxy.ProxyEngine;
import org.eclipse.jetty.spdy.proxy.ProxyEngineSelector;

public class SPDYProxyEngine
extends ProxyEngine
implements StreamFrameListener {
    private static final String STREAM_HANDLER_ATTRIBUTE = "org.eclipse.jetty.spdy.http.proxy.streamHandler";
    private static final String CLIENT_STREAM_ATTRIBUTE = "org.eclipse.jetty.spdy.http.proxy.clientStream";
    private final ConcurrentMap<String, Session> serverSessions = new ConcurrentHashMap<String, Session>();
    private final SessionFrameListener sessionListener = new ProxySessionFrameListener();
    private final SPDYClient.Factory factory;
    private volatile long connectTimeout = 15000L;
    private volatile long timeout = 60000L;

    public SPDYProxyEngine(SPDYClient.Factory factory) {
        this.factory = factory;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public StreamFrameListener proxy(Stream clientStream, SynInfo clientSynInfo, ProxyEngineSelector.ProxyServerInfo proxyServerInfo) {
        Headers headers = new Headers(clientSynInfo.getHeaders(), false);
        short serverVersion = SPDYProxyEngine.getVersion(proxyServerInfo.getProtocol());
        InetSocketAddress address = proxyServerInfo.getAddress();
        Session serverSession = this.produceSession(proxyServerInfo.getHost(), serverVersion, address);
        if (serverSession == null) {
            this.rst(clientStream);
            return null;
        }
        Session clientSession = clientStream.getSession();
        this.addRequestProxyHeaders(clientStream, headers);
        this.customizeRequestHeaders(clientStream, headers);
        this.convert(clientSession.getVersion(), serverVersion, headers);
        SynInfo serverSynInfo = new SynInfo(headers, clientSynInfo.isClose());
        ProxyStreamFrameListener listener = new ProxyStreamFrameListener(clientStream);
        StreamHandler handler = new StreamHandler(clientStream, serverSynInfo);
        clientStream.setAttribute(STREAM_HANDLER_ATTRIBUTE, (Object)handler);
        serverSession.syn(serverSynInfo, (StreamFrameListener)listener, this.timeout, TimeUnit.MILLISECONDS, (Handler)handler);
        return this;
    }

    private static short getVersion(String protocol) {
        switch (protocol) {
            case "spdy/2": {
                return 2;
            }
            case "spdy/3": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Procotol: " + protocol + " is not a known SPDY protocol");
    }

    public void onReply(Stream stream, ReplyInfo replyInfo) {
    }

    public void onHeaders(Stream stream, HeadersInfo headersInfo) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    public void onData(Stream clientStream, final DataInfo clientDataInfo) {
        this.logger.debug("C -> P {} on {}", new Object[]{clientDataInfo, clientStream});
        ByteBufferDataInfo serverDataInfo = new ByteBufferDataInfo(clientDataInfo.asByteBuffer(false), clientDataInfo.isClose()){

            public void consume(int delta) {
                super.consume(delta);
                clientDataInfo.consume(delta);
            }
        };
        StreamHandler streamHandler = (StreamHandler)clientStream.getAttribute(STREAM_HANDLER_ATTRIBUTE);
        streamHandler.data((DataInfo)serverDataInfo);
    }

    private Session produceSession(String host, short version, InetSocketAddress address) {
        try {
            Session session = (Session)this.serverSessions.get(host);
            if (session == null) {
                SPDYClient client = this.factory.newSPDYClient(version);
                session = (Session)client.connect(address, this.sessionListener).get(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
                this.logger.debug("Proxy session connected to {}", new Object[]{address});
                Session existing = this.serverSessions.putIfAbsent(host, session);
                if (existing != null) {
                    session.goAway(this.getTimeout(), TimeUnit.MILLISECONDS, (Handler)new Handler.Adapter());
                    session = existing;
                }
            }
            return session;
        }
        catch (Exception x) {
            this.logger.debug((Throwable)x);
            return null;
        }
    }

    private void convert(short fromVersion, short toVersion, Headers headers) {
        if (fromVersion != toVersion) {
            for (HTTPSPDYHeader httpHeader : HTTPSPDYHeader.values()) {
                Headers.Header header = headers.remove(httpHeader.name(fromVersion));
                if (header == null) continue;
                String toName = httpHeader.name(toVersion);
                for (String value : header.values()) {
                    headers.add(toName, value);
                }
            }
        }
    }

    private void rst(Stream stream) {
        RstInfo rstInfo = new RstInfo(stream.getId(), StreamStatus.REFUSED_STREAM);
        stream.getSession().rst(rstInfo, this.getTimeout(), TimeUnit.MILLISECONDS, (Handler)new Handler.Adapter());
    }

    private class ProxySessionFrameListener
    extends SessionFrameListener.Adapter
    implements StreamFrameListener {
        private ProxySessionFrameListener() {
        }

        public StreamFrameListener onSyn(Stream serverStream, SynInfo serverSynInfo) {
            SPDYProxyEngine.this.logger.debug("S -> P pushed {} on {}", new Object[]{serverSynInfo, serverStream});
            Headers headers = new Headers(serverSynInfo.getHeaders(), false);
            SPDYProxyEngine.this.addResponseProxyHeaders(serverStream, headers);
            SPDYProxyEngine.this.customizeResponseHeaders(serverStream, headers);
            Stream clientStream = (Stream)serverStream.getAssociatedStream().getAttribute(SPDYProxyEngine.CLIENT_STREAM_ATTRIBUTE);
            SPDYProxyEngine.this.convert(serverStream.getSession().getVersion(), clientStream.getSession().getVersion(), headers);
            StreamHandler handler = new StreamHandler(clientStream, serverSynInfo);
            serverStream.setAttribute(SPDYProxyEngine.STREAM_HANDLER_ATTRIBUTE, (Object)handler);
            clientStream.syn(new SynInfo(headers, serverSynInfo.isClose()), SPDYProxyEngine.this.getTimeout(), TimeUnit.MILLISECONDS, (Handler)handler);
            return this;
        }

        public void onRst(Session serverSession, RstInfo serverRstInfo) {
            Stream clientStream;
            Stream serverStream = serverSession.getStream(serverRstInfo.getStreamId());
            if (serverStream != null && (clientStream = (Stream)serverStream.getAttribute(SPDYProxyEngine.CLIENT_STREAM_ATTRIBUTE)) != null) {
                Session clientSession = clientStream.getSession();
                RstInfo clientRstInfo = new RstInfo(clientStream.getId(), serverRstInfo.getStreamStatus());
                clientSession.rst(clientRstInfo, SPDYProxyEngine.this.getTimeout(), TimeUnit.MILLISECONDS, (Handler)new Handler.Adapter());
            }
        }

        public void onGoAway(Session serverSession, GoAwayInfo goAwayInfo) {
            SPDYProxyEngine.this.serverSessions.values().remove(serverSession);
        }

        public void onReply(Stream stream, ReplyInfo replyInfo) {
        }

        public void onHeaders(Stream stream, HeadersInfo headersInfo) {
            throw new UnsupportedOperationException();
        }

        public void onData(Stream serverStream, final DataInfo serverDataInfo) {
            SPDYProxyEngine.this.logger.debug("S -> P pushed {} on {}", new Object[]{serverDataInfo, serverStream});
            ByteBufferDataInfo clientDataInfo = new ByteBufferDataInfo(serverDataInfo.asByteBuffer(false), serverDataInfo.isClose()){

                public void consume(int delta) {
                    super.consume(delta);
                    serverDataInfo.consume(delta);
                }
            };
            StreamHandler handler = (StreamHandler)serverStream.getAttribute(SPDYProxyEngine.STREAM_HANDLER_ATTRIBUTE);
            handler.data((DataInfo)clientDataInfo);
        }
    }

    private class StreamHandler
    implements Handler<Stream> {
        private final Queue<DataInfoHandler> queue = new LinkedList<DataInfoHandler>();
        private final Stream clientStream;
        private final SynInfo serverSynInfo;
        private Stream serverStream;

        private StreamHandler(Stream clientStream, SynInfo serverSynInfo) {
            this.clientStream = clientStream;
            this.serverSynInfo = serverSynInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(Stream serverStream) {
            DataInfoHandler dataInfoHandler;
            SPDYProxyEngine.this.logger.debug("P -> S {} from {} to {}", new Object[]{this.serverSynInfo, this.clientStream, serverStream});
            serverStream.setAttribute(SPDYProxyEngine.CLIENT_STREAM_ATTRIBUTE, (Object)this.clientStream);
            Queue<DataInfoHandler> queue = this.queue;
            synchronized (queue) {
                this.serverStream = serverStream;
                dataInfoHandler = this.queue.peek();
                if (dataInfoHandler != null) {
                    if (dataInfoHandler.flushing) {
                        SPDYProxyEngine.this.logger.debug("SYN completed, flushing {}, queue size {}", new Object[]{dataInfoHandler.dataInfo, this.queue.size()});
                        dataInfoHandler = null;
                    } else {
                        dataInfoHandler.flushing = true;
                        SPDYProxyEngine.this.logger.debug("SYN completed, queue size {}", new Object[]{this.queue.size()});
                    }
                } else {
                    SPDYProxyEngine.this.logger.debug("SYN completed, queue empty", new Object[0]);
                }
            }
            if (dataInfoHandler != null) {
                this.flush(serverStream, dataInfoHandler);
            }
        }

        public void failed(Stream serverStream, Throwable x) {
            SPDYProxyEngine.this.logger.debug(x);
            SPDYProxyEngine.this.rst(this.clientStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void data(DataInfo dataInfo) {
            Stream serverStream;
            DataInfoHandler dataInfoHandler = null;
            DataInfoHandler item = new DataInfoHandler(dataInfo);
            Queue<DataInfoHandler> queue = this.queue;
            synchronized (queue) {
                this.queue.offer(item);
                serverStream = this.serverStream;
                if (serverStream != null) {
                    dataInfoHandler = this.queue.peek();
                    if (dataInfoHandler.flushing) {
                        SPDYProxyEngine.this.logger.debug("Queued {}, flushing {}, queue size {}", new Object[]{dataInfo, dataInfoHandler.dataInfo, this.queue.size()});
                        serverStream = null;
                    } else {
                        dataInfoHandler.flushing = true;
                        SPDYProxyEngine.this.logger.debug("Queued {}, queue size {}", new Object[]{dataInfo, this.queue.size()});
                    }
                } else {
                    SPDYProxyEngine.this.logger.debug("Queued {}, SYN incomplete, queue size {}", new Object[]{dataInfo, this.queue.size()});
                }
            }
            if (serverStream != null) {
                this.flush(serverStream, dataInfoHandler);
            }
        }

        private void flush(Stream serverStream, DataInfoHandler dataInfoHandler) {
            SPDYProxyEngine.this.logger.debug("P -> S {} on {}", new Object[]{dataInfoHandler.dataInfo, serverStream});
            serverStream.data(dataInfoHandler.dataInfo, SPDYProxyEngine.this.getTimeout(), TimeUnit.MILLISECONDS, (Handler)dataInfoHandler);
        }

        private class DataInfoHandler
        implements Handler<Void> {
            private final DataInfo dataInfo;
            private boolean flushing;

            private DataInfoHandler(DataInfo dataInfo) {
                this.dataInfo = dataInfo;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(Void context) {
                DataInfoHandler dataInfoHandler;
                Stream serverStream;
                Queue queue = StreamHandler.this.queue;
                synchronized (queue) {
                    serverStream = StreamHandler.this.serverStream;
                    assert (serverStream != null);
                    dataInfoHandler = (DataInfoHandler)StreamHandler.this.queue.poll();
                    assert (dataInfoHandler == this);
                    dataInfoHandler = (DataInfoHandler)StreamHandler.this.queue.peek();
                    if (dataInfoHandler != null) {
                        assert (!dataInfoHandler.flushing);
                        dataInfoHandler.flushing = true;
                        SPDYProxyEngine.this.logger.debug("Completed {}, queue size {}", new Object[]{this.dataInfo, StreamHandler.this.queue.size()});
                    } else {
                        SPDYProxyEngine.this.logger.debug("Completed {}, queue empty", new Object[]{this.dataInfo});
                    }
                }
                if (dataInfoHandler != null) {
                    StreamHandler.this.flush(serverStream, dataInfoHandler);
                }
            }

            public void failed(Void context, Throwable x) {
                SPDYProxyEngine.this.logger.debug(x);
                SPDYProxyEngine.this.rst(StreamHandler.this.clientStream);
            }
        }
    }

    private class ProxyStreamFrameListener
    extends StreamFrameListener.Adapter {
        private final Stream clientStream;
        private volatile ReplyInfo replyInfo;

        public ProxyStreamFrameListener(Stream clientStream) {
            this.clientStream = clientStream;
        }

        public void onReply(Stream stream, ReplyInfo replyInfo) {
            SPDYProxyEngine.this.logger.debug("S -> P {} on {}", new Object[]{replyInfo, stream});
            short serverVersion = stream.getSession().getVersion();
            Headers headers = new Headers(replyInfo.getHeaders(), false);
            SPDYProxyEngine.this.addResponseProxyHeaders(stream, headers);
            SPDYProxyEngine.this.customizeResponseHeaders(stream, headers);
            short clientVersion = this.clientStream.getSession().getVersion();
            SPDYProxyEngine.this.convert(serverVersion, clientVersion, headers);
            this.replyInfo = new ReplyInfo(headers, replyInfo.isClose());
            if (replyInfo.isClose()) {
                this.reply(stream);
            }
        }

        public void onHeaders(Stream stream, HeadersInfo headersInfo) {
            throw new UnsupportedOperationException("Not Yet Implemented");
        }

        public void onData(Stream stream, DataInfo dataInfo) {
            SPDYProxyEngine.this.logger.debug("S -> P {} on {}", new Object[]{dataInfo, stream});
            if (this.replyInfo != null) {
                if (dataInfo.isClose()) {
                    this.replyInfo.getHeaders().put("content-length", String.valueOf(dataInfo.available()));
                }
                this.reply(stream);
            }
            this.data(stream, dataInfo);
        }

        private void reply(final Stream stream) {
            final ReplyInfo replyInfo = this.replyInfo;
            this.replyInfo = null;
            this.clientStream.reply(replyInfo, SPDYProxyEngine.this.getTimeout(), TimeUnit.MILLISECONDS, (Handler)new Handler<Void>(){

                public void completed(Void context) {
                    SPDYProxyEngine.this.logger.debug("P -> C {} from {} to {}", new Object[]{replyInfo, stream, ProxyStreamFrameListener.this.clientStream});
                }

                public void failed(Void context, Throwable x) {
                    SPDYProxyEngine.this.logger.debug(x);
                    SPDYProxyEngine.this.rst(ProxyStreamFrameListener.this.clientStream);
                }
            });
        }

        private void data(final Stream stream, final DataInfo dataInfo) {
            this.clientStream.data(dataInfo, SPDYProxyEngine.this.getTimeout(), TimeUnit.MILLISECONDS, (Handler)new Handler<Void>(){

                public void completed(Void context) {
                    dataInfo.consume(dataInfo.length());
                    SPDYProxyEngine.this.logger.debug("P -> C {} from {} to {}", new Object[]{dataInfo, stream, ProxyStreamFrameListener.this.clientStream});
                }

                public void failed(Void context, Throwable x) {
                    SPDYProxyEngine.this.logger.debug(x);
                    SPDYProxyEngine.this.rst(ProxyStreamFrameListener.this.clientStream);
                }
            });
        }
    }
}

