/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.metrics;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.BooleanMetric;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.InfoMetric;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.metrics.Metric;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.json.simple.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fJ\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020\u0006H\u0007J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020 H\u0007J\u001e\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fJ\"\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020 H\u0007J\u0006\u0010&\u001a\u00020'R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jitsi/metrics/MetricsContainer;", "", "registry", "Lio/prometheus/client/CollectorRegistry;", "(Lio/prometheus/client/CollectorRegistry;)V", "checkForNameConflicts", "", "getCheckForNameConflicts", "()Z", "setCheckForNameConflicts", "(Z)V", "jsonString", "", "getJsonString", "()Ljava/lang/String;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "metrics", "", "Lorg/jitsi/metrics/Metric;", "namespace", "getRegistry", "()Lio/prometheus/client/CollectorRegistry;", "getPrometheusMetrics", "contentType", "registerBooleanMetric", "Lorg/jitsi/metrics/BooleanMetric;", "name", "help", "initialValue", "registerCounter", "Lorg/jitsi/metrics/CounterMetric;", "", "registerInfo", "Lorg/jitsi/metrics/InfoMetric;", "value", "registerLongGauge", "Lorg/jitsi/metrics/LongGaugeMetric;", "resetAll", "", "jicoco-metrics"})
public class MetricsContainer {
    @NotNull
    private final CollectorRegistry registry;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String namespace;
    private boolean checkForNameConflicts;
    @NotNull
    private final Map<String, Metric<?>> metrics;

    @JvmOverloads
    public MetricsContainer(@NotNull CollectorRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.registry = registry;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        this.namespace = "jitsi";
        this.checkForNameConflicts = true;
        this.metrics = new LinkedHashMap();
    }

    public /* synthetic */ MetricsContainer(CollectorRegistry collectorRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            CollectorRegistry collectorRegistry2 = CollectorRegistry.defaultRegistry;
            Intrinsics.checkNotNullExpressionValue((Object)collectorRegistry2, (String)"defaultRegistry");
            collectorRegistry = collectorRegistry2;
        }
        this(collectorRegistry);
    }

    @NotNull
    public final CollectorRegistry getRegistry() {
        return this.registry;
    }

    public final boolean getCheckForNameConflicts() {
        return this.checkForNameConflicts;
    }

    public final void setCheckForNameConflicts(boolean bl) {
        this.checkForNameConflicts = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getJsonString() {
        void $this$mapValuesTo$iv$iv;
        Map<String, Metric<?>> $this$mapValues$iv = this.metrics;
        boolean $i$f$mapValues = false;
        Map<String, Metric<?>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Object t = ((Metric)it.getValue()).get();
            map3.put(k, t);
        }
        Map map4 = destination$iv$iv;
        String string = new JSONObject(map4).toJSONString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject(metrics.mapVa\u2026e.get() }).toJSONString()");
        return string;
    }

    @NotNull
    public final String getPrometheusMetrics(@NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        StringWriter writer = new StringWriter();
        try {
            TextFormat.writeFormat((String)contentType, (Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final BooleanMetric registerBooleanMetric(@NotNull String name, @NotNull String help, boolean initialValue) {
        BooleanMetric booleanMetric;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            if (metric == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jitsi.metrics.BooleanMetric");
            }
            return (BooleanMetric)metric;
        }
        BooleanMetric $this$registerBooleanMetric_u24lambda_u2d1 = booleanMetric = new BooleanMetric(name, help, this.namespace, initialValue);
        boolean bl = false;
        this.metrics.put(name, $this$registerBooleanMetric_u24lambda_u2d1.register$jicoco_metrics(this.registry));
        return booleanMetric;
    }

    public static /* synthetic */ BooleanMetric registerBooleanMetric$default(MetricsContainer metricsContainer, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerBooleanMetric");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return metricsContainer.registerBooleanMetric(string, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public final CounterMetric registerCounter(@NotNull String name, @NotNull String help, long initialValue) {
        String newName;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        if (StringsKt.endsWith$default((String)name, (String)"_total", (boolean)false, (int)2, null)) {
            object2 = name;
        } else {
            object = name + "_total";
            String it = object;
            boolean bl = false;
            this.logger.debug((Object)("Counter '" + name + "' was renamed to '" + it + "' to ensure consistent metric naming."));
            object2 = newName = object;
        }
        if (this.metrics.containsKey(newName) | this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + newName + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(newName);
            if (metric == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jitsi.metrics.CounterMetric");
            }
            return (CounterMetric)metric;
        }
        Object $this$registerCounter_u24lambda_u2d3 = object = new CounterMetric(newName, help, this.namespace, initialValue);
        boolean bl = false;
        this.metrics.put(newName, ((CounterMetric)$this$registerCounter_u24lambda_u2d3).register$jicoco_metrics(this.registry));
        return object;
    }

    public static /* synthetic */ CounterMetric registerCounter$default(MetricsContainer metricsContainer, String string, String string2, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerCounter");
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        return metricsContainer.registerCounter(string, string2, l);
    }

    @JvmOverloads
    @NotNull
    public final LongGaugeMetric registerLongGauge(@NotNull String name, @NotNull String help, long initialValue) {
        LongGaugeMetric longGaugeMetric;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            if (metric == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jitsi.metrics.LongGaugeMetric");
            }
            return (LongGaugeMetric)metric;
        }
        LongGaugeMetric $this$registerLongGauge_u24lambda_u2d4 = longGaugeMetric = new LongGaugeMetric(name, help, this.namespace, initialValue);
        boolean bl = false;
        this.metrics.put(name, $this$registerLongGauge_u24lambda_u2d4.register$jicoco_metrics(this.registry));
        return longGaugeMetric;
    }

    public static /* synthetic */ LongGaugeMetric registerLongGauge$default(MetricsContainer metricsContainer, String string, String string2, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerLongGauge");
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        return metricsContainer.registerLongGauge(string, string2, l);
    }

    @NotNull
    public final InfoMetric registerInfo(@NotNull String name, @NotNull String help, @NotNull String value) {
        InfoMetric infoMetric;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.metrics.containsKey(name)) {
            if (this.checkForNameConflicts) {
                throw new RuntimeException("Could not register metric '" + name + "'. A metric with that name already exists.");
            }
            Metric<?> metric = this.metrics.get(name);
            if (metric == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jitsi.metrics.InfoMetric");
            }
            return (InfoMetric)metric;
        }
        InfoMetric $this$registerInfo_u24lambda_u2d5 = infoMetric = new InfoMetric(name, help, this.namespace, value);
        boolean bl = false;
        this.metrics.put(name, $this$registerInfo_u24lambda_u2d5.register$jicoco_metrics(this.registry));
        return infoMetric;
    }

    public final void resetAll() {
        Iterable $this$forEach$iv = this.metrics.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Metric it = (Metric)element$iv;
            boolean bl = false;
            it.reset$jicoco_metrics();
        }
    }

    @JvmOverloads
    public MetricsContainer() {
        this(null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final BooleanMetric registerBooleanMetric(@NotNull String name, @NotNull String help) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        return MetricsContainer.registerBooleanMetric$default(this, name, help, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final CounterMetric registerCounter(@NotNull String name, @NotNull String help) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        return MetricsContainer.registerCounter$default(this, name, help, 0L, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final LongGaugeMetric registerLongGauge(@NotNull String name, @NotNull String help) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        return MetricsContainer.registerLongGauge$default(this, name, help, 0L, 4, null);
    }
}

