/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jibri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.BaseJibri;
import org.jitsi.jicofo.jibri.JibriConfig;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriSession;
import org.jitsi.jicofo.util.ErrorResponse;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.extensions.jibri.SipCallState;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0014H\u0014J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\"\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0006\u0010\"\u001a\u00020\u001aR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jitsi/jicofo/jibri/JibriSipGateway;", "Lorg/jitsi/jicofo/jibri/BaseJibri;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "jibriDetector", "Lorg/jitsi/jicofo/jibri/JibriDetector;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/jicofo/jibri/JibriDetector;Lorg/jitsi/utils/logging2/Logger;)V", "jibriSessions", "", "Lorg/jitsi/jicofo/jibri/JibriSession;", "getJibriSessions", "()Ljava/util/List;", "sipSessions", "", "", "acceptType", "", "packet", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq;", "getJibriSessionForMeetIq", "iq", "handleStartRequest", "Lorg/jivesoftware/smack/packet/IQ;", "onSessionStateChanged", "", "jibriSession", "newStatus", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq$Status;", "failureReason", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq$FailureReason;", "publishJibriSipCallState", "session", "shutdown", "jicofo"})
public final class JibriSipGateway
extends BaseJibri {
    @NotNull
    private final Map<String, JibriSession> sipSessions;

    public JibriSipGateway(@NotNull JitsiMeetConferenceImpl conference, @NotNull JibriDetector jibriDetector, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)((Object)jibriDetector), (String)"jibriDetector");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super(conference, parentLogger, jibriDetector);
        this.sipSessions = new HashMap();
    }

    @Override
    protected boolean acceptType(@NotNull JibriIq packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        return StringUtils.isNotBlank((CharSequence)packet.getSipAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        try {
            Iterable $this$forEach$iv = this.sipSessions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JibriSession it = (JibriSession)element$iv;
                boolean bl = false;
                it.stop(null);
            }
        }
        finally {
            this.sipSessions.clear();
        }
    }

    @Override
    @Nullable
    protected JibriSession getJibriSessionForMeetIq(@NotNull JibriIq iq) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        return this.sipSessions.get(iq.getSipAddress());
    }

    @Override
    @NotNull
    public List<JibriSession> getJibriSessions() {
        return new ArrayList<JibriSession>(this.sipSessions.values());
    }

    @Override
    @NotNull
    protected IQ handleStartRequest(@NotNull JibriIq iq) {
        IQ iQ;
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        if (StringUtils.isNotBlank((CharSequence)iq.getSipAddress())) {
            String sessionId = this.generateSessionId();
            JibriSession jibriSession = new JibriSession(this, this.getConference().getRoomName(), iq.getFrom(), JibriConfig.config.getPendingTimeout().getSeconds(), JibriConfig.config.getNumRetries(), this.getJibriDetector(), false, iq.getSipAddress(), iq.getDisplayName(), null, null, sessionId, null, this.getLogger());
            IQ iQ2 = this.sipSessions;
            String string = iq.getSipAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"iq.sipAddress");
            iQ2.put((String)string, (JibriSession)jibriSession);
            try {
                jibriSession.start();
                this.getLogger().info((Object)"Started Jibri session");
                iQ2 = (IQ)JibriIq.createResult((JibriIq)iq, (String)sessionId);
            }
            catch (JibriSession.StartException exc) {
                String reason = exc.getMessage();
                this.getLogger().warn((Object)("Failed to start a Jibri session: " + reason), (Throwable)exc);
                this.sipSessions.remove(iq.getSipAddress());
                JibriSession.StartException startException = exc;
                iQ2 = (IQ)(startException instanceof JibriSession.StartException.AllBusy ? ErrorResponse.create((IQ)iq, StanzaError.Condition.resource_constraint, "all Jibris are busy") : (startException instanceof JibriSession.StartException.NotAvailable ? ErrorResponse.create((IQ)iq, StanzaError.Condition.service_unavailable, "no Jibris available") : ErrorResponse.create((IQ)iq, StanzaError.Condition.internal_server_error, reason)));
            }
            IQ iQ3 = iQ2;
            Intrinsics.checkNotNullExpressionValue((Object)iQ3, (String)"{\n            val sessio\u2026}\n            }\n        }");
            iQ = iQ3;
        } else {
            ErrorIQ errorIQ = ErrorResponse.create((IQ)iq, StanzaError.Condition.bad_request, "Stream ID is empty or undefined");
            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"{\n            // Bad req\u2026 or undefined\")\n        }");
            iQ = (IQ)errorIQ;
        }
        return iQ;
    }

    @Override
    public void onSessionStateChanged(@NotNull JibriSession jibriSession, @NotNull JibriIq.Status newStatus, @Nullable JibriIq.FailureReason failureReason) {
        Intrinsics.checkNotNullParameter((Object)jibriSession, (String)"jibriSession");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        if (!this.sipSessions.containsValue(jibriSession)) {
            this.getLogger().error((Object)("onSessionStateChanged for unknown session: " + jibriSession));
            return;
        }
        this.publishJibriSipCallState(jibriSession, newStatus, failureReason);
        if (JibriIq.Status.OFF == newStatus) {
            String sipAddress = jibriSession.getSipAddress();
            this.sipSessions.remove(sipAddress);
            this.getLogger().info((Object)("Removing SIP call: " + sipAddress));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void publishJibriSipCallState(JibriSession session, JibriIq.Status newStatus, JibriIq.FailureReason failureReason) {
        SipCallState sipCallState;
        SipCallState $this$publishJibriSipCallState_u24lambda_u2d1 = sipCallState = new SipCallState();
        boolean bl = false;
        $this$publishJibriSipCallState_u24lambda_u2d1.setState(newStatus);
        $this$publishJibriSipCallState_u24lambda_u2d1.setFailureReason(failureReason);
        $this$publishJibriSipCallState_u24lambda_u2d1.setSipAddress(session.getSipAddress());
        $this$publishJibriSipCallState_u24lambda_u2d1.setSessionId(session.getSessionId());
        SipCallState sipCallState2 = sipCallState;
        this.getLogger().info((Object)("Publishing new state: " + session.getSipAddress() + " " + sipCallState2.toXML()));
        ChatRoom chatRoom = this.getConference().getChatRoom();
        if (chatRoom != null) {
            void $this$filterTo$iv$iv;
            Collection collection = chatRoom.getPresenceExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"chatRoom.presenceExtensions");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExtensionElement it = (ExtensionElement)element$iv$iv;
                boolean bl2 = false;
                if (!(it instanceof SipCallState && Intrinsics.areEqual((Object)((SipCallState)it).getSipAddress(), (Object)session.getSipAddress()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            chatRoom.modifyPresence((Collection)toRemove, (Collection)CollectionsKt.listOf((Object)sipCallState2));
        }
    }
}

