/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.mucclient;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import org.jitsi.retry.RetryStrategy;
import org.jitsi.retry.SimpleRetryTask;
import org.jitsi.utils.concurrent.ExecutorUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.TrustAllHostnameVerifier;
import org.jitsi.xmpp.TrustAllX509TrustManager;
import org.jitsi.xmpp.mucclient.IQListener;
import org.jitsi.xmpp.mucclient.MucClientConfiguration;
import org.jitsi.xmpp.mucclient.MucClientManager;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.PingManager;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class MucClient {
    private static final int DEFAULT_PING_INTERVAL_SECONDS = 30;
    private static final Logger classLogger;
    private static final IQ.Type[] IQ_TYPES;
    private AbstractXMPPConnection xmppConnection;
    private RetryStrategy connectRetry;
    private ScheduledExecutorService executor;
    private final MucClientManager mucClientManager;
    private IQListener iqListener;
    private Resourcepart mucNickname;
    private IQRequestHandler.Mode iqHandlerMode = IQRequestHandler.Mode.async;
    private final MucClientConfiguration config;
    private final Map<Jid, MucWrapper> mucs = new ConcurrentHashMap<Jid, MucWrapper>();
    private final Logger logger;
    private final PingFailedListener pingFailedListener = new PingFailedListenerImpl();
    private final ReconnectionListener reconnectionListener = new ReconnectionListener(){

        public void reconnectingIn(int i) {
            if (i == 0) {
                MucClient.this.mucClientManager.reconnecting(MucClient.this);
            }
            MucClient.this.logger.info((Object)("Reconnecting in " + i));
        }

        public void reconnectionFailed(Exception e) {
            MucClient.this.mucClientManager.reconnectionFailed(MucClient.this);
            MucClient.this.logger.warn((Object)"Reconnection failed: ", (Throwable)e);
        }
    };

    private static XMPPTCPConnectionConfiguration createXMPPTCPConnectionConfiguration(MucClientConfiguration config) {
        ConnectionConfiguration.SecurityMode securityMode;
        DomainBareJid domainJid;
        String domain = config.getDomain();
        if (domain == null) {
            domain = config.getHostname();
        }
        try {
            domainJid = JidCreate.domainBareFrom((String)domain);
        }
        catch (XmppStringprepException xse) {
            classLogger.error((Object)("Failed to parse domain: " + domain), (Throwable)xse);
            return null;
        }
        XMPPTCPConnectionConfiguration.Builder builder = (XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost((CharSequence)config.getHostname())).setXmppDomain(domainJid)).setUsernameAndPassword((CharSequence)config.getUsername(), config.getPassword());
        String portStr = config.getPort();
        if (portStr != null && !portStr.isEmpty()) {
            builder.setPort(Integer.parseInt(portStr));
        }
        if (config.getDisableCertificateVerification()) {
            classLogger.warn((Object)"Disabling certificate verification!");
            builder.setCustomX509TrustManager((X509TrustManager)new TrustAllX509TrustManager());
            builder.setHostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        }
        if ((securityMode = config.getSecurityMode()) == null) {
            String hostname = config.getHostname();
            securityMode = hostname.equals("localhost") || hostname.equals("127.0.0.1") || hostname.equals("::1") ? ConnectionConfiguration.SecurityMode.ifpossible : ConnectionConfiguration.SecurityMode.required;
        }
        if (securityMode == ConnectionConfiguration.SecurityMode.disabled) {
            classLogger.warn((Object)"XMPP security is disabled!");
        }
        builder.setSecurityMode(securityMode);
        SASLAuthentication.unregisterSASLMechanism((String)"org.jivesoftware.smack.sasl.javax.SASLGSSAPIMechanism");
        return builder.build();
    }

    MucClient(MucClientConfiguration config, MucClientManager mucClientManager) {
        this.mucClientManager = mucClientManager;
        this.logger = classLogger.createChildLogger(MucClient.class.getName(), Stream.of({"id", config.getId()}, {"hostname", config.getHostname()}).collect(Collectors.toMap(data -> data[0], data -> data[1])));
        this.config = config;
    }

    void start() {
        this.executor = ExecutorUtils.newScheduledThreadPool((int)1, (boolean)true, (String)MucClientManager.class.getSimpleName());
        this.connectRetry = new RetryStrategy(this.executor);
        this.executor.execute(() -> {
            try {
                this.initializeConnectAndJoin();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to initialize and start a MucClient: ", (Throwable)e);
            }
        });
    }

    private void initializeConnectAndJoin() throws Exception {
        this.logger.info((Object)("Initializing a new MucClient for " + this.config));
        if (!this.config.isComplete()) {
            throw new IllegalArgumentException("incomplete configuration");
        }
        this.mucNickname = Resourcepart.from((String)this.config.getMucNickname());
        if ("sync".equalsIgnoreCase(this.config.getIqHandlerMode())) {
            this.iqHandlerMode = IQRequestHandler.Mode.sync;
        }
        this.xmppConnection = new XMPPTCPConnection(MucClient.createXMPPTCPConnectionConfiguration(this.config));
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.xmppConnection);
        PingManager pingManager = PingManager.getInstanceFor((XMPPConnection)this.xmppConnection);
        if (pingManager != null) {
            pingManager.registerPingFailedListener(this.pingFailedListener);
        }
        this.mucClientManager.getFeatures().forEach(arg_0 -> ((ServiceDiscoveryManager)sdm).addFeature(arg_0));
        ReconnectionManager reconnectionManager = ReconnectionManager.getInstanceFor((AbstractXMPPConnection)this.xmppConnection);
        reconnectionManager.disableAutomaticReconnection();
        this.xmppConnection.addConnectionListener(new ConnectionListener(){

            public void connected(XMPPConnection xmppConnection) {
                MucClient.this.mucClientManager.connected(MucClient.this);
                MucClient.this.logger.info((Object)"Connected.");
            }

            public void authenticated(XMPPConnection xmppConnection, boolean b) {
                MucClient.this.logger.info((Object)("Authenticated, b=" + b));
            }

            public void connectionClosed() {
                MucClient.this.mucClientManager.closed(MucClient.this);
                MucClient.this.logger.info((Object)"Closed.");
            }

            public void connectionClosedOnError(Exception e) {
                MucClient.this.mucClientManager.closedOnError(MucClient.this);
                MucClient.this.logger.warn((Object)"Closed on error:", (Throwable)e);
            }
        });
        ReconnectionManager.getInstanceFor((AbstractXMPPConnection)this.xmppConnection).addReconnectionListener(this.reconnectionListener);
        this.mucClientManager.getRegisteredIqs().forEach(this::registerIQ);
        this.setIQListener(this.mucClientManager.getIqListener());
        this.logger.info((Object)"Dispatching a thread to connect and login.");
        this.connectRetry.runRetryingTask(new SimpleRetryTask(0L, 5000L, true, this.getConnectAndLoginCallable()));
    }

    private void joinMucs() throws SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException, XMPPException.XMPPErrorException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.NotAMucServiceException, XmppStringprepException {
        for (String mucJidStr : this.config.getMucJids()) {
            EntityBareJid mucJid = JidCreate.entityBareFrom((String)mucJidStr);
            MucWrapper mucWrapper = this.getOrCreateMucState((Jid)mucJid);
            mucWrapper.join(mucJid);
        }
    }

    boolean isConnected() {
        return this.xmppConnection != null && this.xmppConnection.isConnected() && this.xmppConnection.isAuthenticated();
    }

    int getMucsCount() {
        return this.config.getMucJids().size();
    }

    int getMucsJoinedCount() {
        if (!this.isConnected()) {
            return 0;
        }
        return (int)this.mucs.values().stream().filter(mucWrapper -> mucWrapper.muc.isJoined()).count();
    }

    private MucWrapper getOrCreateMucState(Jid mucJid) {
        return this.mucs.computeIfAbsent(mucJid, k -> new MucWrapper());
    }

    public boolean sendStanza(Stanza stanza) {
        try {
            this.xmppConnection.sendStanza(stanza);
            return true;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to send stanza: ", (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return "[MucClient id=" + this.config.getId() + " hostname=" + this.config.getHostname() + "]";
    }

    public void setPresenceExtension(ExtensionElement extension) {
        this.setPresenceExtensions(Collections.singletonList(extension));
    }

    public void setPresenceExtensions(Collection<ExtensionElement> extensions) {
        if (!this.isConnected()) {
            this.logger.warn((Object)"Cannot set presence extension: not connected.");
            return;
        }
        this.mucs.values().forEach(ms -> ms.setPresenceExtensions(extensions));
    }

    public void removePresenceExtension(String elementName, String namespace) {
        this.mucs.values().forEach(ms -> ms.removePresenceExtension(elementName, namespace));
    }

    void setIQListener(IQListener iqListener) {
        this.iqListener = iqListener;
    }

    void registerIQ(IQ iq, final boolean requireResponse) {
        for (final IQ.Type type : IQ_TYPES) {
            this.xmppConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler(iq.getChildElementName(), iq.getChildElementNamespace(), type, this.iqHandlerMode){

                public IQ handleIQRequest(IQ iqRequest) {
                    MucClient.this.logger.debug(() -> "Received an IQ with type " + type + ": " + iqRequest.toString());
                    return MucClient.this.handleIq(iqRequest, requireResponse);
                }
            });
        }
    }

    private IQ handleIq(IQ iq, boolean requireResponse) {
        IQ responseIq = null;
        EntityBareJid fromJid = iq.getFrom().asEntityBareJidIfPossible();
        String fromJidStr = fromJid.toString().toLowerCase();
        if (this.config.getMucJids().stream().noneMatch(mucJid -> mucJid.toLowerCase().equals(fromJidStr))) {
            this.logger.warn((Object)("Received an IQ from a non-MUC member: " + fromJid));
            return ErrorUtilKt.createError(iq, StanzaError.Condition.forbidden);
        }
        IQListener iqListener = this.iqListener;
        if (iqListener == null) {
            this.logger.error((Object)"Received an IQ, but the listener is null.");
        } else {
            try {
                responseIq = iqListener.handleIq(iq, this);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Exception processing IQ, returning internal server error. Request: " + iq), (Throwable)e);
                responseIq = ErrorUtilKt.createError(iq, StanzaError.Condition.internal_server_error, e.getMessage());
            }
        }
        if (requireResponse && responseIq == null) {
            this.logger.info((Object)("Failed to produce a response for IQ, returning internal server error. Request: " + iq));
            responseIq = ErrorUtilKt.createError(iq, StanzaError.Condition.internal_server_error, "Unknown error");
        }
        return responseIq;
    }

    public String getId() {
        return this.config.getId();
    }

    void stop() {
        this.connectRetry.cancel();
        ReconnectionManager.getInstanceFor((AbstractXMPPConnection)this.xmppConnection).removeReconnectionListener(this.reconnectionListener);
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        try {
            this.mucs.values().forEach(rec$ -> ((MucWrapper)rec$).leave());
        }
        catch (Exception e) {
            this.logger.error((Object)"Error leaving mucs", (Throwable)e);
        }
        PingManager pingManager = PingManager.getInstanceFor((XMPPConnection)this.xmppConnection);
        if (pingManager != null) {
            pingManager.unregisterPingFailedListener(this.pingFailedListener);
        }
        try {
            this.xmppConnection.disconnect();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error disconnecting xmpp connection", (Throwable)e);
        }
    }

    private Callable<Boolean> getConnectAndLoginCallable() {
        return () -> {
            try {
                if (!this.xmppConnection.isConnected()) {
                    this.xmppConnection.connect();
                }
            }
            catch (Exception t) {
                this.logger.warn((Object)"Error connecting:", (Throwable)t);
                return true;
            }
            if (!this.xmppConnection.isAuthenticated()) {
                this.logger.info((Object)"Logging in.");
                try {
                    this.xmppConnection.login();
                }
                catch (SmackException.AlreadyLoggedInException e) {
                    this.logger.info((Object)"Already logged in.");
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Failed to login. Disconnecting to trigger a re-connect.", (Throwable)e);
                    this.xmppConnection.disconnect();
                    return true;
                }
                try {
                    this.joinMucs();
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Failed to join the MUCs.", (Throwable)e);
                    return true;
                }
            }
            return true;
        };
    }

    static {
        XMPPTCPConnection.setUseStreamManagementDefault((boolean)false);
        XMPPTCPConnection.setUseStreamManagementResumptionDefault((boolean)false);
        PingManager.setDefaultPingInterval((int)30);
        classLogger = new LoggerImpl(MucClient.class.getName());
        IQ_TYPES = new IQ.Type[]{IQ.Type.get, IQ.Type.set};
    }

    private class PingFailedListenerImpl
    implements PingFailedListener {
        private PingFailedListenerImpl() {
        }

        public void pingFailed() {
            MucClient.this.logger.warn((Object)"Ping failed, the XMPP connection needs to reconnect.");
            MucClient.this.mucClientManager.pingFailed(MucClient.this);
            if (MucClient.this.xmppConnection.isConnected() && MucClient.this.xmppConnection.isAuthenticated()) {
                MucClient.this.logger.warn((Object)"XMPP connection still connected, will trigger a disconnect.");
                MucClient.this.xmppConnection.disconnect();
            }
        }
    }

    private class MucWrapper {
        private MultiUserChat muc;
        private PresenceBuilder lastPresenceSent;
        private final Consumer<PresenceBuilder> presenceInterceptor = presence -> {
            PresenceBuilder nextLastPresence = (PresenceBuilder)presence.build().asBuilder((String)null).removeExtension("x", "http://jabber.org/protocol/muc");
            MucWrapper mucWrapper = this;
            synchronized (mucWrapper) {
                this.lastPresenceSent = nextLastPresence;
            }
        };

        private MucWrapper() {
        }

        private void leave() {
            try {
                this.muc.leave();
            }
            catch (Exception e) {
                MucClient.this.logger.warn((Object)"Error while trying to leave a MUC: ", (Throwable)e);
            }
            this.muc = null;
        }

        private void join(EntityBareJid mucJid) throws SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException, XMPPException.XMPPErrorException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.NotAMucServiceException {
            this.resetLastPresenceSent();
            if (this.muc != null) {
                this.muc.removePresenceInterceptor(this.presenceInterceptor);
                MucClient.this.logger.info((Object)"Leaving a MUC we already occupy.");
                this.leave();
            }
            MultiUserChatManager mucManager = MultiUserChatManager.getInstanceFor((XMPPConnection)MucClient.this.xmppConnection);
            this.muc = mucManager.getMultiUserChat(mucJid);
            this.muc.addPresenceInterceptor(this.presenceInterceptor);
            MultiUserChat.MucCreateConfigFormHandle mucCreateHandle = this.muc.createOrJoin(MucClient.this.mucNickname);
            if (mucCreateHandle != null) {
                Form config = this.muc.getConfigurationForm();
                FillableForm answer = config.getFillableForm();
                String whoisFieldName = "muc#roomconfig_whois";
                answer.setAnswer(whoisFieldName, (CharSequence)"anyone");
                this.muc.sendConfigurationForm(answer);
            }
            MucClient.this.logger.info((Object)("Joined MUC: " + mucJid));
            this.setPresenceExtensions(MucClient.this.mucClientManager.getPresenceExtensions());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setPresenceExtensions(Collection<ExtensionElement> extensions) {
            Presence updatedPresence;
            MucWrapper mucWrapper = this;
            synchronized (mucWrapper) {
                if (this.lastPresenceSent == null) {
                    MucClient.this.logger.warn((Object)"Cannot set presence extensions: no previous presence available.");
                    return;
                }
                extensions.forEach(arg_0 -> ((PresenceBuilder)this.lastPresenceSent).overrideExtension(arg_0));
                updatedPresence = this.lastPresenceSent.build();
            }
            try {
                MucClient.this.xmppConnection.sendStanza((Stanza)updatedPresence);
            }
            catch (Exception e) {
                MucClient.this.logger.error((Object)"Failed to send stanza:", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removePresenceExtension(String elementName, String namespace) {
            Presence updatedPresence = null;
            MucWrapper mucWrapper = this;
            synchronized (mucWrapper) {
                if (this.lastPresenceSent == null) {
                    return;
                }
                if (this.lastPresenceSent.removeExtension(elementName, namespace) != null) {
                    updatedPresence = this.lastPresenceSent.build();
                }
            }
            if (updatedPresence != null) {
                try {
                    MucClient.this.xmppConnection.sendStanza((Stanza)updatedPresence);
                }
                catch (Exception e) {
                    MucClient.this.logger.error((Object)"Failed to send stanza:", (Throwable)e);
                }
            }
        }

        private synchronized void resetLastPresenceSent() {
            MucClient.this.logger.debug((Object)"Resetting lastPresenceSent");
            this.lastPresenceSent = null;
        }
    }
}

