/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.ColorBehaviourListener;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.StyleBase;

public class HSBAColor
extends StyleBase {
    private float _h;
    private float _s;
    private float _b;
    private float _a;

    public HSBAColor() {
        this._b = 0.5f;
        this._s = 0.5f;
        this._h = 0.5f;
        this._a = 1.0f;
    }

    public HSBAColor(double d, double d2, double d3, double d4, SceneGraph sceneGraph) {
        super(sceneGraph);
        this._h = (float)d;
        this._s = (float)d2;
        this._b = (float)d3;
        this._a = (float)d4;
    }

    public HSBAColor(Color color, SceneGraph sceneGraph) {
        super(sceneGraph);
        this.setColor(color);
    }

    public Color getColor() {
        int n = Color.HSBtoRGB(this._h, this._s, this._b);
        int n2 = (int)((double)this._a * 255.0) << 24;
        return new Color(n | n2, true);
    }

    public void setColor(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getBlue(), color.getGreen(), null);
        this._h = fArray[0];
        this._s = fArray[1];
        this._b = fArray[2];
        this._a = (float)color.getAlpha() / 255.0f;
        this.setDirty(true);
    }

    public double getHue() {
        return this._h;
    }

    public void setHue(double d) {
        this._h = (float)d;
        this.setDirty(true);
    }

    public double getSaturation() {
        return this._s;
    }

    public void setSaturation(double d) {
        this._s = (float)d;
        this.setDirty(true);
    }

    public double getBrightness() {
        return this._b;
    }

    public void setBrightness(double d) {
        this._b = (float)d;
        this.setDirty(true);
    }

    public double getAlpha() {
        return this._a;
    }

    public void setAlpha(double d) {
        this._a = (float)d;
        this.setDirty(true);
    }

    public Style.Change changeStyle(Graphics2D graphics2D) {
        final Paint paint = graphics2D.getPaint();
        final Color color = this.getColor();
        graphics2D.setPaint(this.getColor());
        return new Style.Change(){

            public void restoreStyle(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
            }

            public void reapplyStyle(Graphics2D graphics2D) {
                graphics2D.setPaint(color);
            }
        };
    }

    public final ColorAdapter newColorAdapter() {
        return new ColorAdapter();
    }

    public final HueAdapter newHueAdapter() {
        return new HueAdapter();
    }

    public final SaturationAdapter newSaturationAdapter() {
        return new SaturationAdapter();
    }

    public final BrightnessAdapter newBrightnessAdapter() {
        return new BrightnessAdapter();
    }

    public final AlphaAdapter newAlphaAdapter() {
        return new AlphaAdapter();
    }

    class AlphaAdapter
    implements DoubleBehaviourListener,
    Serializable {
        AlphaAdapter() {
        }

        public void behaviourUpdated(double d) {
            HSBAColor.this.setAlpha(d);
        }
    }

    class BrightnessAdapter
    implements DoubleBehaviourListener,
    Serializable {
        BrightnessAdapter() {
        }

        public void behaviourUpdated(double d) {
            HSBAColor.this.setBrightness(d);
        }
    }

    class SaturationAdapter
    implements DoubleBehaviourListener,
    Serializable {
        SaturationAdapter() {
        }

        public void behaviourUpdated(double d) {
            HSBAColor.this.setSaturation(d);
        }
    }

    class HueAdapter
    implements DoubleBehaviourListener,
    Serializable {
        HueAdapter() {
        }

        public void behaviourUpdated(double d) {
            HSBAColor.this.setHue(d);
        }
    }

    class ColorAdapter
    implements ColorBehaviourListener,
    Serializable {
        ColorAdapter() {
        }

        public void behaviourUpdated(Color color) {
            HSBAColor.this.setColor(color);
        }
    }
}

