/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.AccuRevRepository;
import org.opensolaris.opengrok.history.BazaarRepository;
import org.opensolaris.opengrok.history.CVSRepository;
import org.opensolaris.opengrok.history.ClearCaseRepository;
import org.opensolaris.opengrok.history.GitRepository;
import org.opensolaris.opengrok.history.MercurialRepository;
import org.opensolaris.opengrok.history.MonotoneRepository;
import org.opensolaris.opengrok.history.PerforceRepository;
import org.opensolaris.opengrok.history.RCSRepository;
import org.opensolaris.opengrok.history.RazorRepository;
import org.opensolaris.opengrok.history.RepoRepository;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.RepositoryInfo;
import org.opensolaris.opengrok.history.SCCSRepository;
import org.opensolaris.opengrok.history.SSCMRepository;
import org.opensolaris.opengrok.history.SubversionRepository;

public final class RepositoryFactory {
    private static Repository[] repositories = new Repository[]{new MercurialRepository(), new AccuRevRepository(), new BazaarRepository(), new GitRepository(), new MonotoneRepository(), new SubversionRepository(), new SCCSRepository(), new RazorRepository(), new ClearCaseRepository(), new PerforceRepository(), new RCSRepository(), new CVSRepository(), new RepoRepository(), new SSCMRepository()};

    private RepositoryFactory() {
    }

    public static List<Class<? extends Repository>> getRepositoryClasses() {
        ArrayList<Class<? extends Repository>> list = new ArrayList<Class<? extends Repository>>(repositories.length);
        for (int i = repositories.length - 1; i >= 0; --i) {
            list.add(repositories[i].getClass());
        }
        return list;
    }

    public static Repository getRepository(File file) throws InstantiationException, IllegalAccessException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        Repository res = null;
        for (Repository rep : repositories) {
            if (!rep.isRepositoryFor(file)) continue;
            res = (Repository)rep.getClass().newInstance();
            try {
                res.setDirectoryName(file.getCanonicalPath());
            }
            catch (IOException e) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get canonical path name for " + file.getAbsolutePath(), e);
            }
            if (!res.isWorking()) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "{0} not working (missing binaries?): {1}", new Object[]{res.getClass().getSimpleName(), file.getPath()});
            }
            if (res.getType() == null || res.getType().length() == 0) {
                res.setType(res.getClass().getSimpleName());
            }
            if (!env.isTagsEnabled() || !res.hasFileBasedTags()) break;
            res.buildTagList(file);
            break;
        }
        return res;
    }

    public static Repository getRepository(RepositoryInfo info) throws InstantiationException, IllegalAccessException {
        return RepositoryFactory.getRepository(new File(info.getDirectoryName()));
    }
}

