/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as u,css as h,nothing as g,html as d}from"lit";import{property as b,state as p,customElement as f}from"lit/decorators.js";import"@typo3/backend/element/icon-element.js";import m from"@typo3/backend/ajax-data-handler.js";var r=function(l,t,n,s){var o=arguments.length,e=o<3?t:s===null?s=Object.getOwnPropertyDescriptor(t,n):s,a;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")e=Reflect.decorate(l,t,n,s);else for(var c=l.length-1;c>=0;c--)(a=l[c])&&(e=(o<3?a(e):o>3?a(t,n,e):a(t,n))||e);return o>3&&e&&Object.defineProperty(t,n,e),e};let i=class extends u{constructor(){super(...arguments),this.pageTitle="",this.pageId=0,this.localizedPageId=0,this.editable=!1,this._isEditing=!1,this._isSubmitting=!1,this.labels={input:TYPO3?.lang?.["editablePageTitle.input.field.label"]||"Field",edit:TYPO3?.lang?.["editablePageTitle.button.edit.label"]||"Edit",save:TYPO3?.lang?.["editablePageTitle.button.save.label"]||"Save",cancel:TYPO3?.lang?.["editablePageTitle.button.cancel.label"]||"Cancel"}}static{this.styles=h`:host{display:block;--input-border-color:#bebebe;--input-hover-border-color:#bebebe;--input-focus-border-color:#bebebe;--button-border-radius:2px;--button-color:inherit;--button-bg:transparent;--button-border-color:transparent;--button-hover-color:inherit;--button-hover-bg:#cacaca;--button-hover-border-color:#bebebe;--button-focus-color:inherit;--button-focus-bg:#cacaca;--button-focus-border-color:#bebebe}h1{display:block;white-space:nowrap;text-overflow:ellipsis;overflow:hidden;padding:1px 0}h1,input{font-weight:inherit;font-size:inherit;font-family:inherit;line-height:inherit;margin:0}input{outline:none;background:transparent;padding:0;border:0;border-top:1px solid transparent;border-bottom:1px dashed var(--input-border-color);width:100%;outline-offset:0}input:hover{--input-border-color:var(--input-hover-border-color)}input:focus{--input-border-color:var(--input-focus-border-color)}input:focus-visible{outline:.25rem solid color-mix(in srgb,var(--input-border-color),transparent 25%)}.wrapper{position:relative;margin:-1px 0}div.wrapper{padding-inline-end:1.5em}form.wrapper{padding-inline-end:2.5em}button{cursor:pointer;display:inline-flex;align-items:center;justify-content:center;font-size:inherit;line-height:inherit;border:0;padding:0;height:100%;width:1em;position:absolute;top:0;border-radius:var(--button-border-radius);overflow:hidden;outline:none;color:var(--button-color);background:var(--button-bg);border:1px solid var(--button-border-color);opacity:.3;outline-offset:0;transition:all .2s ease-in-out}button:hover{opacity:1;--button-color:var(--button-hover-color);--button-bg:var(--button-hover-bg);--button-border-color:var(--button-hover-border-color)}button:focus{opacity:1;--button-color:var(--button-focus-color);--button-bg:var(--button-focus-bg);--button-border-color:var(--button-focus-border-color)}button:focus-visible{outline:.25rem solid color-mix(in srgb,var(--button-border-color),transparent 25%)}button[data-action=edit]{inset-inline-end:0}button[data-action=save]{inset-inline-end:calc(1em + 2px)}button[data-action=close]{inset-inline-end:0}.screen-reader{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);white-space:nowrap;border:0}`}async startEditing(){this.isEditable()&&(this._isEditing=!0,await this.updateComplete,this.shadowRoot.querySelector("input")?.focus())}render(){if(this.pageTitle==="")return g;if(!this.isEditable())return d`<div class=wrapper><h1>${this.pageTitle}</h1></div>`;let t;return this._isEditing?t=this.composeEditForm():t=d`<div class=wrapper><h1 @dblclick=${()=>{this.startEditing()}}>${this.pageTitle}</h1>${this.composeEditButton()}</div>`,t}isEditable(){return this.editable&&this.pageId>0}endEditing(){this.isEditable()&&(this._isEditing=!1)}updatePageTitle(t){t.preventDefault();const n=new FormData(t.target),o=Object.fromEntries(n).newPageTitle.toString();if(this.pageTitle===o){this.endEditing();return}this._isSubmitting=!0;let e=this.pageId;this.localizedPageId>0&&(e=this.localizedPageId);const a={data:{pages:{[e]:{title:o}}}};m.process(a).then(()=>{this.pageTitle=o,top.document.dispatchEvent(new CustomEvent("typo3:pagetree:refresh"))}).finally(()=>{this.endEditing(),this._isSubmitting=!1})}composeEditButton(){return d`<button data-action=edit type=button title=${this.labels.edit} @click=${()=>{this.startEditing()}}><typo3-backend-icon identifier=actions-open size=small></typo3-backend-icon><span class=screen-reader>${this.labels.edit}</span></button>`}composeEditForm(){return d`<form class=wrapper @submit=${this.updatePageTitle}><label class=screen-reader for=input>${this.labels.input}</label> <input autocomplete=off id=input name=newPageTitle required value=${this.pageTitle} ?disabled=${this._isSubmitting} @keydown=${t=>{t.key==="Escape"&&this.endEditing()}}> <button data-action=save type=submit title=${this.labels.save} ?disabled=${this._isSubmitting}><typo3-backend-icon identifier=actions-check size=small></typo3-backend-icon><span class=screen-reader>${this.labels.save}</span></button> <button data-action=close type=button title=${this.labels.cancel} ?disabled=${this._isSubmitting} @click=${()=>{this.endEditing()}}><typo3-backend-icon identifier=actions-close size=small></typo3-backend-icon><span class=screen-reader>${this.labels.cancel}</span></button></form>`}};r([b({type:String})],i.prototype,"pageTitle",void 0),r([b({type:Number})],i.prototype,"pageId",void 0),r([b({type:Number})],i.prototype,"localizedPageId",void 0),r([b({type:Boolean})],i.prototype,"editable",void 0),r([p()],i.prototype,"_isEditing",void 0),r([p()],i.prototype,"_isSubmitting",void 0),i=r([f("typo3-backend-editable-page-title")],i);export{i as EditablePageTitle};
