/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{property as d,customElement as x}from"lit/decorators.js";import{LitElement as C,css as $,html as i,nothing as p}from"lit";import m from"@typo3/backend/modal.js";import"@typo3/backend/element/icon-element.js";import k from"@typo3/core/ajax/ajax-request.js";import{lll as z}from"@typo3/core/lit-helper.js";import M from"@typo3/backend/notification.js";import y from"@typo3/backend/viewport.js";import T from"@typo3/core/event/regular-event.js";import{KeyTypesEnum as E}from"@typo3/backend/enum/key-types.js";var l=function(n,e,t,o){var c=arguments.length,r=c<3?e:o===null?o=Object.getOwnPropertyDescriptor(e,t):o,s;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(n,e,t,o);else for(var g=n.length-1;g>=0;g--)(s=n[g])&&(r=(c<3?s(r):c>3?s(e,t,r):s(e,t))||r);return c>3&&r&&Object.defineProperty(e,t,r),r};const b={fromAttribute:n=>n===null?!0:n.toLowerCase()==="true",toAttribute:n=>n?"true":"false"};class v{constructor(e,t,o,c,r,s,g,f,w){this.identifier=e,this.label=t,this.description=o,this.icon=c,this.url=r,this.requestType=s,this.defaultValues=g,this.saveAndClose=f,this.event=w,this.visible=!0}static fromData(e){return new v(e.identifier,e.label,e.description,e.icon,e.url??null,e.requestType??"location",e.defaultValues??[],e.saveAndClose??!1,e.event??null)}reset(){this.visible=!0}}class u{constructor(e,t,o){this.identifier=e,this.label=t,this.items=o,this.disabled=!1}static fromData(e){return new u(e.identifier,e.label,e.items.map(t=>v.fromData(t)))}reset(){this.disabled=!1,this.items.forEach(e=>{e.reset()})}activeItems(){return this.items.filter(e=>e.visible)??[]}}class h{constructor(e){this.items=e}static fromData(e){return new h(Object.values(e).map(t=>u.fromData(t)))}reset(){this.items.forEach(e=>{e.reset()})}categoriesWithItems(){return this.items.filter(e=>e.activeItems().length>0)??[]}}let a=class extends C{constructor(){super(...arguments),this.categories=new h([]),this.searchPlaceholder="newRecordWizard.filter.placeholder",this.searchNothingFoundLabel="newRecordWizard.filter.noResults",this.displayMenu=!0,this.displayFilter=!0,this.selectedCategory=null,this.searchTerm="",this.messages=[],this.toggleMenu=!1}static{this.styles=[$`:host{display:block;container-type:inline-size}.element{gap:var(--typo3-spacing);font-size:var(--typo3-component-font-size);line-height:var(--typo3-component-line-height)}.element,.main{display:flex;flex-direction:column}.main{width:100%;gap:calc(var(--typo3-spacing)*2)}@container (min-width: 500px){.main{flex-direction:row}}.main>*{flex-grow:1}.navigation{position:relative;flex-shrink:0}@container (min-width: 500px){.navigation{flex-grow:0;width:200px}.navigation-toggle{display:none!important}}.navigation-list{display:none;flex-direction:column;gap:2px;list-style:none;padding:0;margin:0}.navigation-list.show{display:flex}@container (max-width: 499px){.navigation-list{z-index:1;position:absolute;padding:var(--typo3-component-border-width);background:var(--typo3-component-bg);border:var(--typo3-component-border-width) solid var(--typo3-component-border-color);border-radius:var(--typo3-component-border-radius);box-shadow:var(--typo3-component-box-shadow)}}@container (min-width: 500px){.navigation-list{display:flex}}.navigation-item{cursor:pointer;align-items:center;display:flex;width:100%;gap:calc(var(--typo3-spacing)/2);text-align:start;color:inherit;background:transparent;border:var(--typo3-component-border-width) solid var(--typo3-component-border-color);border-radius:var(--typo3-component-border-radius);padding:var(--typo3-list-item-padding-y) var(--typo3-list-item-padding-x)}@container (max-width: 499px){.navigation-item{border-radius:calc(var(--typo3-component-border-radius) - var(--typo3-component-border-width))}}.navigation-item:hover{color:var(--typo3-component-hover-color);background:var(--typo3-component-hover-bg);border-color:var(--typo3-component-hover-border-color)}.navigation-item:focus{outline:none;color:var(--typo3-component-focus-color);background:var(--typo3-component-focus-bg);border-color:var(--typo3-component-focus-border-color)}.navigation-item.active{color:var(--typo3-component-active-color);background:var(--typo3-component-active-bg);border-color:var(--typo3-component-active-border-color)}.navigation-item:disabled{cursor:not-allowed;color:var(--typo3-component-disabled-color);background:var(--typo3-component-disabled-bg);border-color:var(--typo3-component-disabled-border-color)}.navigation-item-label{flex-grow:1}.navigation-item-count{opacity:.75;flex-shrink:0}.content{container-type:inline-size}.elementwizard-categories{display:grid;gap:var(--typo3-spacing)}.elementwizard-category-headline{font-weight:700;color:var(--typo3-text-color-variant);margin-bottom:calc(var(--typo3-spacing)/2)}.elementwizard-category-items{display:grid;grid-template-columns:repeat(1,1fr);gap:var(--typo3-spacing)}@container (min-width: 500px){.elementwizard-category-items{grid-template-columns:repeat(2,1fr)}}@container (min-width: 750px){.elementwizard-category-items{grid-template-columns:repeat(3,1fr)}}.item{cursor:pointer;display:flex;gap:calc(var(--typo3-spacing)/2);text-align:start;border:var(--typo3-component-border-width) solid transparent;border-radius:var(--typo3-component-border-radius);padding:var(--typo3-list-item-padding-y) var(--typo3-list-item-padding-x);background:transparent;color:inherit}.item:hover{color:var(--typo3-component-hover-color);background:var(--typo3-component-hover-bg);border-color:var(--typo3-component-hover-border-color)}.item:focus{outline:none;color:var(--typo3-component-focus-color);background:var(--typo3-component-focus-bg);border-color:var(--typo3-component-focus-border-color)}.item-body-label{text-wrap:balance;font-weight:700;margin-bottom:.25rem}.item-body-description{opacity:.75;text-wrap:pretty}`]}firstUpdated(){const e=document.createElement("link");e.setAttribute("rel","stylesheet"),e.setAttribute("href",TYPO3.settings.cssUrls.backend),this.shadowRoot.appendChild(e),this.displayFilter===!0&&this.renderRoot.querySelector('input[name="search"]').focus(),this.selectAvailableCategory()}getLanguageLabel(e){const t=z(e);return t!==""?t:e}selectAvailableCategory(){this.categories.categoriesWithItems().filter(t=>t===this.selectedCategory).length===0&&(this.selectedCategory=this.categories.categoriesWithItems()[0]??null),this.messages=[],this.selectedCategory===null&&(this.messages=[{message:this.getLanguageLabel(this.searchNothingFoundLabel),severity:"info"}])}filter(e){this.searchTerm=e,this.categories.reset(),this.categories.items.forEach(t=>{const o=t.label.trim().replace(/\s+/g," ");!(this.searchTerm!==""&&!RegExp(this.searchTerm,"i").test(o))||t.items.forEach(r=>{const s=r.label.trim().replace(/\s+/g," ")+r.description?.trim().replace(/\s+/g," ");r.visible=!(this.searchTerm!==""&&!RegExp(this.searchTerm,"i").test(s))}),t.disabled=t.items.filter(r=>r.visible).length===0}),this.selectAvailableCategory()}render(){return i`<div class=element>${this.displayFilter===!0?this.renderFilter():p} ${this.renderMessages()} ${this.selectedCategory===null?p:i`<div class=main>${this.categories.items.length>1&&this.displayMenu===!0?i`<div class=navigation>${this.renderNavigationToggle()} ${this.renderNavigationList()}</div>`:p}<div class=content>${this.renderCategories()}</div></div>`}</div>`}renderFilter(){return i`<form class=filter @submit=${e=>e.preventDefault()}><input name=search type=search autocomplete=off class=form-control .value=${this.searchTerm} @input=${e=>{this.filter(e.target.value)}} @keydown=${e=>{e.key===E.ESCAPE&&(e.stopImmediatePropagation(),this.filter(""))}} placeholder=${this.getLanguageLabel(this.searchPlaceholder)}></form>`}renderMessages(){return i`${this.messages.length>0?i`<div class=messages>${this.messages.map(e=>i`<div class="alert alert-${e.severity}" role=alert>${e.message}</div>`)}</div>`:p}`}renderNavigationToggle(){return i`<button class="navigation-toggle btn btn-light" @click=${()=>{this.toggleMenu=!this.toggleMenu}}>${this.selectedCategory.label}<typo3-backend-icon identifier=actions-chevron-${this.toggleMenu===!0?"up":"down"} size=small></typo3-backend-icon></button>`}renderNavigationList(){return i`<div class=navigation-list${this.toggleMenu===!0?" show":""} role=tablist>${this.categories.items.map(e=>i`<button data-identifier=${e.identifier} class=navigation-item${this.selectedCategory===e?" active":""} ?disabled=${e.disabled} @click=${()=>{this.selectedCategory=e,this.toggleMenu=!1}}><span class=navigation-item-label>${e.label}</span> <span class=navigation-item-count>${e.activeItems().length}</span></button>`)}</div>`}renderCategories(){return i`<div class=elementwizard-categories>${this.categories.items.map(e=>this.renderCategory(e))}</div>`}renderCategory(e){return i`${(this.selectedCategory===e||this.displayMenu===!1)&&!e.disabled?i`<div class=elementwizard-category>${this.displayMenu===!1?i`<div class=elementwizard-category-headline>${e.label}</div>`:p}<div class=elementwizard-category-items>${e.items.map(t=>this.renderCategoryItem(t))}</div></div>`:p}`}renderCategoryItem(e){return i`${e.visible?i`<button type=button class=item data-identifier=${e.identifier} @click=${t=>{t.preventDefault(),this.handleItemClick(e)}}><div class=item-icon><typo3-backend-icon identifier=${e.icon||"empty-empty"} size=medium></typo3-backend-icon></div><div class=item-body><div class=item-body-label>${e.label}</div><div class=item-body-description>${e.description}</div></div></button>`:p}`}handleItemClick(e){if(e.requestType==="event"){const t=new CustomEvent(e.event,{detail:{item:e}});this.dispatchEvent(t),m.dismiss();return}if(e.url.trim()!==""){if(e.requestType==="location"){y.ContentContainer.setUrl(e.url),m.dismiss();return}e.requestType==="ajax"&&new k(e.url).post({defVals:e.defaultValues,saveAndClose:e.saveAndClose?"1":"0"}).then(async t=>{const o=document.createRange().createContextualFragment(await t.resolve());m.currentModal.addEventListener("modal-updated",()=>{new T("click",(c,r)=>{c.preventDefault();const s=r.dataset.target;s&&(y.ContentContainer.setUrl(s),m.dismiss())}).delegateTo(m.currentModal,"button[data-target]")}),m.currentModal.setContent(o)}).catch(()=>{M.error("Could not load module data")})}}};l([d({type:Object,converter:{fromAttribute:n=>{const e=JSON.parse(n);return h.fromData(e)}}})],a.prototype,"categories",void 0),l([d({type:String})],a.prototype,"searchPlaceholder",void 0),l([d({type:String})],a.prototype,"searchNothingFoundLabel",void 0),l([d({type:Boolean,converter:b})],a.prototype,"displayMenu",void 0),l([d({type:Boolean,converter:b})],a.prototype,"displayFilter",void 0),l([d({type:String,attribute:!1})],a.prototype,"selectedCategory",void 0),l([d({type:String,attribute:!1})],a.prototype,"searchTerm",void 0),l([d({type:Array,attribute:!1})],a.prototype,"messages",void 0),l([d({type:Boolean,attribute:!1})],a.prototype,"toggleMenu",void 0),a=l([x("typo3-backend-new-record-wizard")],a);export{h as Categories,u as Category,a as NewRecordWizard};
