/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Message;

public final class ResourceHelper {
    private ResourceHelper() {
    }

    public static boolean equals(Resource resource, File file) {
        if (resource == null && file == null) {
            return true;
        }
        if (resource == null || file == null) {
            return false;
        }
        if (resource instanceof FileResource) {
            return new File(resource.getName()).equals(file);
        }
        if (resource instanceof URLResource) {
            try {
                return file.toURI().toURL().toExternalForm().equals(resource.getName());
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    public static long getLastModifiedOrDefault(Resource resource) {
        long l = resource.getLastModified();
        if (l > 0L) {
            return l;
        }
        Message.debug("impossible to get date for " + resource + ": using 'now'");
        return System.currentTimeMillis();
    }
}

