%% -----------------------------------------------------------------------
%% This is simply an adaptation of article.cls
%% Search forward for "begin xdvislides.cls" in this file for more info
%% -----------------------------------------------------------------------
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{xdvislides}
      [2003/02/28 v0.6p14 Slides for on-line presentations]
%%      [1998/11/06 v0.6 Slides for on-line presentations]
%% -----------------------------------------------------------------------
\newcommand{\slidebf}[1]{\textsf{\textbf{\huge #1}}}
\newcommand{\slideem}[1]{\textsf{\textit{\huge #1}}}
\newcommand{\slidesizes}{\newpage}
\newcommand{\setfontphv}{
  \fontfamily{phv}\selectfont
  %% This very strange call is here to fix a problem with [spanish]{babel}
  %% because it redefines the bullet items. 
  %% This re-redefines the bullet items just after the begin{document}
  \slidesizes
}
\newcommand{\slideinput}[1]{\verbatiminput{#1}}
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\newif\if@openbib
\@openbibfalse
%% -----------------------------------------------------------------------
%% Now, the options.
% This is the option for an sxga+ (1400x1050) screen
\DeclareOption{sxga+}
 {\renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -1in %% Was 1.1
    \oddsidemargin -0.8in %% Was 1.1
    \evensidemargin\oddsidemargin
    \viewingopts
    }}
% This is the option for an sxga (1280x1024) screen
\DeclareOption{sxga}
 {\renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -0.2in %% Was 1.1
    \oddsidemargin -0.2in %% Was 1.1
    \evensidemargin\oddsidemargin
    \viewingopts
    }}
% This is the option for a sun (1152x900) screen
\DeclareOption{sun} 
 {\renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -0.6in %% Was 1.1
    \oddsidemargin -0.75in %% Was 1.1
    \evensidemargin\oddsidemargin
    \viewingopts
    }}
% This is the option for an xga (1024x768) screen
\DeclareOption{xga} 
 {\renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -0.5in %% Was 1.1
    \oddsidemargin -0.4in %% Was 1.1
    \evensidemargin\oddsidemargin
    \viewingopts
    }}
% This is the option for an svga (800x600) screen
\DeclareOption{svga} 
 {\renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -0.9in %% Was 1.1
    \oddsidemargin -0.9in %% Was 1.1
    \evensidemargin\oddsidemargin
    }}
% This is the option for a vga (600x400) screen
\DeclareOption{vga} 
 {\renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -0.9in %% Was 1.1
    \oddsidemargin -0.9in %% Was 1.1
    \evensidemargin\oddsidemargin
    \viewingopts
    }}
% Weird option for svga in a vga (600x400) screen (not recommended)
\DeclareOption{svgainvga} 
 {\renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.0in
    \topmargin -0.9in %% Was 1.1
    \oddsidemargin -0.9in %% Was 1.1
    \evensidemargin\oddsidemargin
    \viewingopts
    }}
%% This is the option for printing on A4 paper (in landscape!)
\DeclareOption{a4paper} 
 {\setlength\paperheight {297mm} %% A4 sizes
  \setlength\paperwidth  {210mm}
  \renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -.6in
    \oddsidemargin -.18in
    \evensidemargin\oddsidemargin
    \printingitems
    }}
%% This option is intended for converting the slides to html using
%% LaTeX2html. The idea is to use as few gimmics as possible so that
%% LaTeX2html does not get confused.
\DeclareOption{htmlslides} 
 {\renewcommand{\slidesizes}{
     \sloppy
     \normalfonts
     \textwidth 9in
     \textheight 5.6in
     \topmargin -.6in
     \oddsidemargin -.18in
     \evensidemargin\oddsidemargin
     \noframe
     \renewcommand{\slidebf}{\normalfont\bfseries}
     \renewcommand{\slideem}{{\normalfont\bfseries}}
     \renewcommand{\setfontphv}{\normalfont}
     \renewcommand{\blueline}{\hrule\ }
     \renewcommand{\thinredline}{}
     \renewcommand{\lhead}[1]{}
     \renewcommand{\rhead}[1]{}
     \renewcommand{\chead}[1]{}
     \renewcommand{\lfoot}[1]{}
     \renewcommand{\rfoot}[1]{}
     \renewcommand{\cfoot}[1]{}
     \typeout{HTML slides}
     }
   }
%% This is the option for printing on letter paper (same as a4 for now)
\DeclareOption{letterpaper} 
 {\setlength\paperheight {11in}  %% Letter sizes in landscape MH
  \setlength\paperwidth  {8.5in}
  \renewcommand{\slidesizes}{
    \textwidth 9in
    \textheight 5.6in
    \topmargin -.6in
    \oddsidemargin -.18in
    \evensidemargin\oddsidemargin
    \printingitems
    }}
\DeclareOption{a4paper2up} %% Experimental... (for now, use psnup)
 {\setlength\paperheight {297mm} %% A4 sizes
  \setlength\paperwidth  {210mm}
  \renewcommand{\slidesizes}{
    %% \special{landscape} % This is a command to dvi2ps for proper printing
    \sloppy
    \normalfonts
    \textwidth 9in
    \textheight 5.6in
    \topmargin -.6in
    \oddsidemargin -.18in
    \evensidemargin\oddsidemargin
    \shadowframe
    \renewcommand{\labelitemi}{\Red{$\bullet$}}
    \renewcommand{\labelitemii}{\Green{$\diamond$}}
    \renewcommand{\labelitemiii}{\NavyBlue{*}}
    \renewcommand{\labelitemiv}{\Red{-}}
    \newcommand{\twoupxdvislides}{ 
      \target{\magstepminus1}{8.5in}{11in} 
      \source{\magstep0}{11in}{8.5in}}
    \usepackage{2up}
    }}
%% Only 11pt allowed! MH
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{\@openbibtrue}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
%% MH
\ExecuteOptions{letterpaper,11pt,oneside,onecolumn,final}
\ProcessOptions

%% Items
\newcommand{\viewingopts}{
    \special{landscape} % This is a command to dvi2ps for proper printing
    \sloppy
    \normalfonts
    \noframe
    \renewcommand{\labelitemi}{\redball}
    \renewcommand{\labelitemii}{\greenball}
    \renewcommand{\labelitemiii}{\blueball}
    \renewcommand{\labelitemiv}{\Red{$\bullet$}}
}
\newcommand{\printingitems}{
    \special{landscape} % This is a command to dvi2ps for proper printing
    \sloppy
    \normalfonts
    \shadowframe
    \renewcommand{\labelitemi}{\Red{$\bullet$}}
    \renewcommand{\labelitemii}{\Green{$\diamond$}}
    \renewcommand{\labelitemiii}{\NavyBlue{*}}
    \renewcommand{\labelitemiv}{\Red{-}}
}

%% Fixed size MH
\input{size11.clo}
\input{colordvi} %% Needed for coloring the items etc. MH
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\thepage\hfil\slshape\leftmark}%
      \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
      \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markboth {\MakeUppercase{%
        \ifnum \c@secnumdepth >\z@
          \thesection\quad
        \fi
        ##1}}{}}%
    \def\subsectionmark##1{%
      \markright {%
        \ifnum \c@secnumdepth >\@ne
          \thesubsection\quad
          \fi
          ##1}}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \thesection\quad
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\slshape\leftmark}%
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
\if@titlepage
  \newcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \null\vfil
  \vskip 60\p@
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 3em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \let\thanks\relax\let\maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \let\thanks\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\fi
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand\thepart         {\@Roman\c@part}
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
\def\@endpart{\vfil\newpage
              \if@twoside
                \hbox{}%
                \thispagestyle{empty}%
                \newpage
              \fi
              \if@tempswa
                \twocolumn
              \fi}
\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\Large\bfseries}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\large\bfseries}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\bfseries}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize\bfseries}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\normalfont\normalsize\bfseries}}
\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength\leftmargin    {\leftmargini}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
%% MH eliminated newcommand*
\newcommand{\descriptionlabel}[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\if@titlepage
  \newenvironment{abstract}{%
      \titlepage
      \null\vfil
      \begin{center}%
        \bfseries \abstractname
        \@endparpenalty\@M
      \end{center}}%
     {\par\vfil\null\endtitlepage}
\else
  \newenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \begin{center}%
          {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
        \end{center}%
        \quotation
      \fi}
      {\if@twocolumn\else\endquotation\fi}
\fi
\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item[]}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item[]}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item[]}
               {\endlist}
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \if@compatibility
        \setcounter{page}{0}
      \else
        \setcounter{page}{1}%
      \fi}%
    {\if@restonecol\twocolumn \else \newpage \fi
      \setcounter{page}{1}%
    }
\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\@Alph\c@section}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\@arabic\c@equation}
\newcounter{figure}
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
%% Eliminated \DeclareRobustCommand*
\DeclareRobustCommand{\cal}{\@fontswitch{\relax}{\mathcal}}
\DeclareRobustCommand{\mit}{\@fontswitch{\relax}{\mathnormal}}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\newcommand\tableofcontents{%
    \section*{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }
%% Eliminated newcommand* MH
\newcommand{\l@part}[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}
      \fi
    \endgroup
  \fi}
%% Eliminated newcommand* MH
\newcommand{\l@section}[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
%% Eliminated newcommand* MH
\newcommand{\l@subsection}{\@dottedtocline{2}{1.5em}{2.3em}}
%% Eliminated newcommand* MH
\newcommand{\l@subsubsection}{\@dottedtocline{3}{3.8em}{3.2em}}
%% Eliminated newcommand* MH
\newcommand{\l@paragraph}{\@dottedtocline{4}{7.0em}{4.1em}}
%% Eliminated newcommand* MH
\newcommand{\l@subparagraph}{\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}}%
    \@starttoc{lof}%
    }
%% Eliminated newcommand* MH
\newcommand{\l@figure}{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{%
          \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\bibindent=1.5em
\newcommand{\biblstart}{\subsection{\refname}}
\newenvironment{thebibliography}[1]
  { \biblstart
%% MH elimninated star
%%  \subsection*{\refname}
%% MH confuses rest
%%        \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \if@openbib
              \advance\leftmargin\bibindent
              \itemindent -\bibindent
              \listparindent \itemindent
              \parsep \z@
            \fi
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \if@openbib
        \renewcommand\newblock{\par}%
      \else
        \renewcommand\newblock{\hskip .11em \@plus.33em \@minus.07em}%
      \fi
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.=\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{}
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\par\hangindent 40\p@ \hspace*{20\p@}}
\newcommand\subsubitem{\par\hangindent 40\p@ \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\long\def\@makefntext#1{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{plain}
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi
%% Commented out to continue reading MH
%% \endinput
%% 
%% End of adaptation of file `article.cls'.

%% begin xdvislides.cls
\typeout{***********************************************************}
\typeout{CLIP Slide Style File for LaTeX}
\typeout{M. Hermenegildo, derived from clip_slide.sty}
\typeout{and lslide by Young. U. Ryu, Y. Arrouye}
\typeout{For making presentations on a portable, XGA/SVGA/VGA/SUN, using xdvi}
\typeout{Changes also by M. Carro}
\typeout{***********************************************************}

% Comments below refer to previous versions:
% 
% o  Added \noframe as one of the options
% o  There is a sample file in the end of the commented area.
%    LaTeX (or AmSLaTeX) it at least twice and print.
%                                    ^^^^^
% o  clipslide.sty is a LaTeX/AmSLaTeX style file for
%       presentation slide typesetting.
%
% o  It generates a title page, tables of contents,
%    separate section heading pages, and slides
%    with heads and foots inside a nice frame.
%
% o  No hyphenations:
%            Hyphenated words are not easily readable
%            in presentation slides, in my opinion.
%    No right-justifications
%            Right justifications may place too big spaces
%            between words, when hyphenations are turned off.
%
%    If you want hyphenations and/or right-justifications
%      go to the "defaults" section in the end of this style file
%      and comment commands to make them.
%
% o  Added \partcontentsname (detailed)
% o  Added \fullslidecontents (detailed)
% o  Added color defaults
% o  Changed overall sizes to make default writing area a little larger
% o  Fixed Fbox
% o  Made subsection jump page also (pseudosubsection still doesn't
%    jump page), defined \subsectiontitle
%    The overall idea is to be able to use a subsection for each slide 
%    (I like it more than begin/end slide)
%
% o All above by M.H.
%
%    B. New \verttopcenter (centers vertically except for the subsection box
%       which is at a fixed amount from the top of the page) and
%       \vertcentertopcenter (idem but horizontal centering too).
%    C. With these two layouts, multiple subsections on a same slide must be
%       separed by \btwnsubs
%    E. Similarly, the \pseudosubsection macro make the same effects as a
%       \subsection but doesn't enter it into the toc file (but it changes the
%       \remindtitle caption)
%
% o  How to use it:
%    A. \documentstyle[12pt,clipslide]{article}   % <- Minimal Req.
%       \documentstyle[12pt,amssymbols,clipslide]{article}
%                             % <- use amssymbols.sty for LaTeX if available
%       \documentstyle[12pt,amstex,amssymb,clipslide]{article}
%                             % <- may be used with AmSLaTeX
%                             % Personally, I prefer it because it can
%                             % easily handle various shapes/styles of fonts.
%
%       Or you may use art11.sty to make the whole slide fonts smaller.
%        \documentstyle[11pt,clipslide]{article}
%        \documentstyle[11pt,amssymbols,clipslide]{article}
%        \documentstyle[11pt,amstex,amssymb,clipslide]{article}
%       (To make fonts smaller, you may also use \smallerfonts
%         or \tinyfonts. See B.)
%       Note: There is no font size difference between art10.sty
%             and art11.sty, when fonts >= \large are used.
%             If you use art10.sty, head and foot fonts of slides
%             become too small.
%
%    B. \vga
%       \svga
%       \a4 \letter
%           (Should be placed before \begin{document})
%       If your print driver allows the 90 degree rotation of the
%       output pages 
%          e.g., emTeX drivers - /tr1 or /tr3
%                 e.x.,  hp myslide /tr1
%          e.g., dvi2ps ... -t landscape ...
%       or your printer has a sideway printing mode,
%       you may use \landscape.
%
%      Probably, you must modify the page dimensions.
%      Place those modifications after \portrait or
%      \landscape. If you use the default (i.e., do not
%      use \portrait or \landscape), place them just after
%      \documentstyle[...]{...}.
%      e.g., \addtolength{\textwidth}{...in}
%            \addtolength{\textheight}{...in}
%            \addtolength{\topmargin}{...in}
%            \addtolength{\oddsidemargin}{...in}
%            \addtolength{\evensidemargin}{...in}
%
%       \defaultskip=...in or ...pt or ...em or ......
%         horizontal spaces at the left and the right of slide
%         bodies (within the slide frame)
%         The default is:
%             \defaultskip=1em
%
%       \vertcenter (default)
%       \verttop
%           (Should be placed before \begin{document})
%       \vertcenter option places \vspace*{\fill} on the top and bottom
%       of each slide page and after \subsection. (Vertical centering)
%       \verttop option places \vspace*{.5em} before \subsection and
%       \vspace*{1em} after \subsection; not \vspace on the top
%       or bottom of each slide page.
%
%       \noframe 
%       \doubleboxframe
%       \shadowframe (default)
%           (Should be placed before \begin{document})
%       \doubleboxframe option places double boxes around each page.
%       \shadowframe option places a shadow box around each page.
%       \ovalframe option places an oval around each page.
%
%       \boxsecframe
%       \shadowsecframe (default)
%           (Should be placed before \begin{document})
%       \boxsecframe option places a single box around subsection title.
%       \shadowsecframe option places a shadow box around subsection title.
%
%       \contentsname{...}
%           (Placed before or after \begin{document})
%         Heading of tables of contents. Default is:
%            \contentsname{CONTENTS}
%            \partcontentsname{PART CONTENTS}
%
%       \smallerfonts
%           (Placed before \begin{document})
%       \normalfonts (default)
%       \tinyfonts
%         Make fonts smaller thoughout the whole file.
%         If you think the default fonts are too big,
%            use this command.
%         Or, you may use art11.sty to make fonts smaller. (See A.)
%
%       \smallcontentsfonts
%           (Placed before or after \begin{document})
%         Makes fonts for tables of contents smaller.
%         Use when the table of content occupies more than one page.
%         If it is used with \smallerfonts, it must placed after
%            \smallerfonts.
%
%    C. \title{T} or \title[T1]{T2}
%           (Placed before or after \begin{document})
%         T or T2 goes to the title page.
%         T or T1 goes to the left head of each page.
%       \author{A}
%           (Placed before or after \begin{document})
%         A goes to the title page and left foot of each page.
%       \organization{O}
%           (Placed before or after \begin{document})
%         O goes to the title page.
%       \date{D}
%           (Placed before or after \begin{document})
%         D goes to the title page.
%       \titlepage
%           (Placed after \begin{document})
%         Generates the title page.
%
%    From now on, everything should be placed after \begin{document}
%
%    D. \slidecontents or \slidecontents*
%           (Placed outside \begin{slide} ... \end{slide})
%         Generates a Table of Contents that Consists of Section Headings.
%         Usually placed after \titlepage
%         If * is placed, no page numbers will appear.
%
%       \sectioncontents or sectioncontents*
%           (Placed outside \begin{slide} ... \end{slide})
%         Generates a Table of Contents that Consists of Section Headings
%         and Subsection Heading of the Following Section.
%         Usually placed before \section{...}
%         If * is placed, no page numbers will appear.
%
%    E. \section{A} or \section[A1]{A2}
%           (Placed outside \begin{slide} ... \end{slide})
%         A or A2 goes to a separate page of section heading
%         A or A1 goes to a table of contents and the right head of each page.
%
%    F. \subsection{A}
%           (Placed inside \begin{slide} ... \end{slide})
%         A frame box surrounds A.
%         A goes to a table of contents for the section.
%
%    G. \begin{slide} ... \end{slide}
%         Generates a page of slide.
%         Your slide bodies are to be placed here.
%         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
%       \begin{slide}[dimension] ... \end{slide}
%         Adds horizontal spaces by "dimension (e.g. 1in, 3em, etc.)"
%           at the left and the right of the text body (within
%           the frame).
%         Only for that page of slide.
%         cf. \defaultskip = dimension
%             for all pages of slide
%
%    H. \Underbar{...} and \Underline{...}
%         Same as \underbar and \underline except that the rule
%         is thicker.
%
%    I. Font size (Notice that all start with a capital letter)
%       \Hugesize
%       \Largesize
%       \Normalsize    - default for slides
%       \Smallsize
%
%    J. Slide head and foot
%       \lhead{...}     default: \lhead{\slidetitle}
%       \chead{...}     default: \chead{\relax}   % empty
%       \rhead{...}     default: \rhead{\sectiontitle}
%       \lfoot{...}     default: \lfoot{\slideauthor}
%       \cfoot{...}     default: \cfoot{\relax}   % empty
%       \rfoot{...}     default: \rfoot{\thepage}
%
%    K. Miscellaneous
%       \slidetitle  - prints slide title (default: \hspace*{1pt})
%       \slideauthor - prints author name (default: \hspace*{1pt})
%       \authororga  - prints organization (default: \hspace*{1pt})
%       \slidedate   - prints date  (default: \today)
%       \sectiontitle - prints section heading
%
%       \pagestyle{slide} is default for slides
%           note: \ps@slide is defined in this style file
%       \pagestyle{empty} is default for the title page,
%                              tables of contents, and section heading pages.
%
%       \Fbox{box sep}{rule thickness}{...}
%          Places a box around ...
%          box sep = spaces between ... and box rules
%          rule thickness = as you can guess
%          e.x., \Fbox{3pt}{1pt}{Box Me}
%
%       \SFbox{box sep}{rule thickness}{shade thickness}{...}
%          Places a shadow box around ...
%          box sep = spaces between ... and box rules
%          e.x., \SFbox{3pt}{1pt}{2pt}{Box Me}
%
%    L. Final Notes, Bugs, Comments, etc.
%       This is a prototype. It will be extended in the future:
%          - Various types of slide frames are desirable.
%            Users may select.
%          - \begin{note} ... \end{note} is useful.
%          - Top-bottom centering (vertical centering) can be done by \vertcenter.
%            Left-right centering (horizontal centering) may be implemented.
%          - Postscript specific features ???
%            With postscript, lots of things can be done easily (?!).
%            But, I personally discourage postscript specific features,
%            because I myself use non-postscript printers more often.
%          - Probably, new font definitions are needed, instead of
%            using those (i.e. defaults) of LaTeX/AmSLaTeX, 'cause
%            many of them are not used at all and we may need
%            big fonts with various shapes.
%
%       How to get (bold) sans serif fonts instead of roman fonts:
%          - If you use AmSLaTeX (with the new font scheme), it's simple:
%                   \begin{document}\sf
%                   \begin{document}\sf\bf
%            Or something more ... (especially to get bold math)
%          - If you use LaTeX, it's not simple.
%            ``\begin{document}\sf\Normalsize'' or
%            ``\begin{document}\sf\Normalsize\bf''
%               handles many (but not all) cases.
%            The best way is to define a style file (or using
%               one if available) which sets \sf (or \sf\bf) as default.
%            Or you may create a .fmt file after modifying
%               lfonts.sty.
%          - Personally, I modified a font file (fontdef.max) for AmSLaTeX
%            and created a clipslide.fmt file so that bold sans serif
%            is default for text and bold symbol fonts are
%            default for math.
%            However, unfortunately, not all AmS bold fonts
%            are available!!!
%
%       Bugs
%           - Probably a few (or many???).
%           - I can't locate them. I need your help...
%
%       E-mail bugs and comments to
%               young@emx.utexas.edu
%               youngryu@bongo.cc.utexas.edu
%
%
% A sample file: cut and paste under a new file name; uncomment.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% OLD **** IGNORE *****:
%\documentstyle[12pt,clipslide]{article}
%   %\documentstyle[12pt,amssymbols,clipslide]{article}
%           % <- if amssymbols.sty is available
%   %\documentstyle[12pt,amstex,amssymb,clipslide]{article}
%           % <- if you use AmSLaTeX
%
%   %\landscape
%           % <- if your driver can rotate 90 degrees.
%           % e.x. in emTeX derivers:
%           %  hp filename /tr2
%           % \portrait is default.
%
%   % Addjust page dimenstions here if necessary. For example:
%   %\addtolength{\textwidth}{-.3in}
%   %\addtolength{\textheight}{.5in}
%   %\addtolength{\topmargin}{.02in}
%   %\addtolength{\oddsidemargin}{-.03in}
%   %\addtolength{\evensidemargin}{-.03in}
%
%   %\verttop
%           % compare it with \vertcenter that is the default
%
%   %\doubleboxframe % or \ovalframe
%           % compare them with \shadowframe that is the default
%
%   %\boxsecframe
%           % compare it with \shadowsecframe that is the default
%
%\begin{document}
%
%\title[Sample Slides with {\tt clipslide.sty}]%
%      {Sample Slides \\
%       with {\tt clipslide.sty}}
%
%\author{Thomas Magnum}
%
%\organization{Private Investigator's Association}
%
%\date{March 1992}
%
%\titlepage
%
%\slidecontents
%
%\sectioncontents
%
%\section{Introduction}
%
%\begin{slide}
%\subsection{Problems of Truth-Functional Logic}
%
%\Underbar{Case 1}
%
%\begin{enumerate}
%\item $\neg A$ \\
%      Therefore $A \rightarrow B$
%\item The Padre beach is not poluted. \\
%      Therefore, if the Padre beach is poluted, it is good for surfing.
%\end{enumerate}
%
%\vspace*{\fill}
%
%\Underbar{Case 2}
%
%\begin{enumerate}
%\item $B$ \\
%      Therefore $A \rightarrow B$
%\item The Padre beach is good for surfing. \\
%      Therefore, if the Padre beach is poluted, it is good for surfing.
%\end{enumerate}
%\end{slide}
%
%\begin{slide}[.5in]
%\Underbar{Case 3}
%
%\begin{enumerate}
%\item $A \rightarrow B$ \\
%      $C \rightarrow \neg B$ \\
%      $C \rightarrow A$ \\
%      $C$ \\
%      Therefore $B \wedge \neg B$
%\item If it is a bird, then it can fly. \\
%      If it is penguin, then it cannot fly. \\
%      If it is penguin, then it is a bird. \\
%      It is a bird \\
%      Therefore, it cannot fly.
%\end{enumerate}
%\end{slide}
%
%\sectioncontents
%
%\section{Next Section}
%
%\begin{slide}[1in]
%Whatever it is. What ever it is.
%Whatever it is. What ever it is.
%
%\vspace*{1.5em}
%
%\begin{enumerate}
%\item Item 1 with Normalsize.
%      \begin{enumerate}\Smallsize
%      \item Item 1.1 with Smallsize.
%      \item Item 1.2 with Smallsize.
%      \end{enumerate}
%\item Item 2 with Normalsize.
%\end{enumerate}
%\end{slide}
%
%\end{document}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% End of the sample file%%%
%
%
% Yves Arrouye: some modifications
%
%  - added \verttopcenter and \vertcentertopcenter
%  - added \subitem
%  - added \btwnsubs
%  - corrected \sectioncontents*
%

\def\verttopcenter{%
    \def\subsec@begin@vspace{\vspace*{0.5em}}
    \def\subsec@end@vspace{\vspace*{\fill}}
    \def\slide@begin@vspace{\relax}
    \def\slide@end@vspace{\vspace*{\fill}}%
    }

\def\vertcentertopcenter{%
    \def\subsec@begin@vspace{\vspace*{0.5em}}
    \def\subsec@end@vspace{\vspace*{\fill}}
    \def\slide@begin@vspace{\center\relax}
    \def\slide@end@vspace{\endcenter\vspace*{\fill}}%
    }

\def\subitem#1{\vspace*{0.3\parskip}\\\Smallsize{#1}\Normalsize}

\def\btwnsubs{{\vspace*{\fill}\\\ %

}}

%
%

\input{psfig.sty}
\newcommand{\blueball}{\psfig{figure=blueball.ps}}
\newcommand{\greenball}{\psfig{figure=greenball.ps}}
\newcommand{\redball}{\psfig{figure=redball.ps}}
%% 
\newcommand{\blueline}{\psfig{figure=blue.line.eps}}
\newcommand{\thinredline}
           {\psfig{figure=thin_line.red.eps}}
%% \newcommand{\upmlogo}
%% \newcommand{\cliplogo}
%% \newcommand{\fimlogo}

\usepackage{html}

%
% Frame for the whole page
% \@my@box@frame{thinkness}{hspace}{vspace}{...}
%
\newdimen \@tempdimc 
\newdimen \@tempdimd

\def\@my@box@frame#1#2#3#4{\vbox{\Gray{%
    \setbox\@tempboxa\hbox{\Black{#4}}%
    \@tempdima#3
    \advance\@tempdima #1 \advance\@tempdima \dp\@tempboxa
    \hbox{\lower \@tempdima%
          \hbox{\vbox{\hrule depth0pt height #1%
                      \hbox{\vrule depth0pt width #1%
                            \hskip#2%
                            \vbox{\vskip#3 \box\@tempboxa\vskip#3}%
                            \hskip#2%
                            \vrule depth0pt width #1}
                      \hrule depth0pt height #1}}}}}}

\def\@alt@box@frame#1#2#3#4{\vbox{\NavyBlue{%
    \setbox\@tempboxa\hbox{\Black{#4}}%
    \@tempdima#3
    \advance\@tempdima #1 \advance\@tempdima \dp\@tempboxa
    \hbox{\lower \@tempdima%
          \hbox{\vbox{\hrule depth0pt height #1%
                      \hbox{\vrule depth0pt width #1%
                            \hskip#2%
                            \vbox{\vskip#3 \box\@tempboxa\vskip#3}%
                            \hskip#2%
                            \vrule depth0pt width #1}
                      \hrule depth0pt height #1}}}}}}

%
% Shadow Frame for the whole page:
% \@my@shadow@box@frame{frame thinkness}{shade thickness}{hspace}{vspace}{...}
%

\def\@my@shadow@box@frame#1#2#3#4#5{\vbox{\Gray{%
    \setbox\@tempboxa\hbox{\Black{#5}}%
    \@tempdima#4
    \advance\@tempdima #1 \advance\@tempdima \dp\@tempboxa
    \setbox\@tempboxa%
     \hbox{\lower \@tempdima%
          \hbox{\vbox{\hrule depth0pt height #1%
                      \hbox{\vrule depth0pt width #1%
                            \hskip#3%
                            \vbox{\vskip#4 \box\@tempboxa\vskip#4}%
                            \hskip#3%
                            \vrule depth0pt width #1}
                      \hrule depth0pt height #1}}}%
     \@tempdimc\ht\@tempboxa \advance\@tempdimc-#2
     \advance\@tempdimc\@tempdima
     \@tempdimd\wd\@tempboxa
     \hbox{\box\@tempboxa\relax%
           \lower\@tempdima\hbox{\vrule width#2 height\@tempdimc depth0pt}}
    \nointerlineskip\moveright#2
    \vbox{\hrule height#2 width\@tempdimd depth0pt}}}}

\def\@alt@shadow@box@frame#1#2#3#4#5{\vbox{\NavyBlue{%
    \setbox\@tempboxa\hbox{\Black{#5}}%
    \@tempdima#4
    \advance\@tempdima #1 \advance\@tempdima \dp\@tempboxa
    \setbox\@tempboxa%
     \hbox{\lower \@tempdima%
          \hbox{\vbox{\hrule depth0pt height #1%
                      \hbox{\vrule depth0pt width #1%
                            \hskip#3%
                            \vbox{\vskip#4 \box\@tempboxa\vskip#4}%
                            \hskip#3%
                            \vrule depth0pt width #1}
                      \hrule depth0pt height #1}}}%
     \@tempdimc\ht\@tempboxa \advance\@tempdimc-#2
     \advance\@tempdimc\@tempdima
     \@tempdimd\wd\@tempboxa
     \hbox{\box\@tempboxa\relax%
           \lower\@tempdima\hbox{\vrule width#2 height\@tempdimc depth0pt}}
    \nointerlineskip\moveright#2
    \vbox{\hrule height#2 width\@tempdimd depth0pt}}}}

%
% Oval frame: by Tomoki Shiratori
% \@my@oval@frame{thickness}{hspace}{vspace}{...}
%     thickness = \thinlines or \thicklines

\def\@my@oval@frame#1#2#3#4{\vbox{\Gray{%
   \Black{#1}%
   \setbox0 = \vbox{%
        \vskip#3\relax
        #4\relax
        \vskip#3\relax}%
   \@tempdimc \ifdim \ht0 >\wd0 \wd0\else \ht0 \fi%
   \divide\@tempdimc 10\relax
   \@getcirc{\@tempdimc}%
   \@tempdimc\ht0%
   \advance\@tempdimc -\@tempdima%
   \advance\@tempdimc 2\@wholewidth%
   \@tempdimd .5\@tempdima \advance\@tempdimd -\@wholewidth%
   \setbox0 = \hbox{%
       \raise\@tempdimd\hbox{\vrule height\@tempdimc width\@wholewidth}%
       \hskip#2\relax
       \box0\relax
       \hskip#2\relax
       \raise\@tempdimd\hbox{\vrule height\@tempdimc width\@wholewidth}}%
   \@tempdimd\wd0 \@tempdimc\@tempdimd%
   \advance\@tempdimc -\@tempdima%
   \vskip -.5\@tempdima \vskip\@wholewidth%
   \hbox to\@tempdimd{%
       \@tempcntb\@tempcnta \advance\@tempcntb 3\relax
       {\@circlefnt \char\@tempcntb\kern -.5\@tempdima}%
       \vbox{\hrule height\@wholewidth width\@tempdimc}%
       {\@circlefnt \kern .5\@tempdima \kern -\@wholewidth \char\@tempcnta%
        \kern -\@tempdima \kern\@wholewidth}}%
   \vskip -.5\@tempdima%
   \box0\relax
   \vskip -.5\@tempdima%
   \hbox to\@tempdimd{%
       \@tempcntb\@tempcnta \advance\@tempcntb\tw@\relax
       {\@circlefnt \char\@tempcntb\kern -.5\@tempdima}%
       \vbox{\hrule height\@wholewidth width\@tempdimc}%
       {\advance\@tempcntb\m@ne%
        \@circlefnt \kern .5\@tempdima \kern -\@wholewidth \char\@tempcntb%
        \kern -\@tempdima \kern \@wholewidth}}%
   \vskip -.5\@tempdima \vskip\@wholewidth}}%

\def\@alt@oval@frame#1#2#3#4{\vbox{\NavyBlue{%
   \Black{#1}%
   \setbox0 = \vbox{%
        \vskip#3\relax
        #4\relax
        \vskip#3\relax}%
   \@tempdimc \ifdim \ht0 >\wd0 \wd0\else \ht0 \fi%
   \divide\@tempdimc 10\relax
   \@getcirc{\@tempdimc}%
   \@tempdimc\ht0%
   \advance\@tempdimc -\@tempdima%
   \advance\@tempdimc 2\@wholewidth%
   \@tempdimd .5\@tempdima \advance\@tempdimd -\@wholewidth%
   \setbox0 = \hbox{%
       \raise\@tempdimd\hbox{\vrule height\@tempdimc width\@wholewidth}%
       \hskip#2\relax
       \box0\relax
       \hskip#2\relax
       \raise\@tempdimd\hbox{\vrule height\@tempdimc width\@wholewidth}}%
   \@tempdimd\wd0 \@tempdimc\@tempdimd%
   \advance\@tempdimc -\@tempdima%
   \vskip -.5\@tempdima \vskip\@wholewidth%
   \hbox to\@tempdimd{%
       \@tempcntb\@tempcnta \advance\@tempcntb 3\relax
       {\@circlefnt \char\@tempcntb\kern -.5\@tempdima}%
       \vbox{\hrule height\@wholewidth width\@tempdimc}%
       {\@circlefnt \kern .5\@tempdima \kern -\@wholewidth \char\@tempcnta%
        \kern -\@tempdima \kern\@wholewidth}}%
   \vskip -.5\@tempdima%
   \box0\relax
   \vskip -.5\@tempdima%
   \hbox to\@tempdimd{%
       \@tempcntb\@tempcnta \advance\@tempcntb\tw@\relax
       {\@circlefnt \char\@tempcntb\kern -.5\@tempdima}%
       \vbox{\hrule height\@wholewidth width\@tempdimc}%
       {\advance\@tempcntb\m@ne%
        \@circlefnt \kern .5\@tempdima \kern -\@wholewidth \char\@tempcntb%
        \kern -\@tempdima \kern \@wholewidth}}%
   \vskip -.5\@tempdima \vskip\@wholewidth}}}}%

%
% modification of \@outputpage (from latex.tex)
%
\def\@outputpage{\begingroup\catcode`\ =10
     \let\-\@dischyph \let\'\@acci \let\`\@accii \let\=\@acciii
    \if@specialpage
     \global\@specialpagefalse\@nameuse{ps@\@specialstyle}\fi
     \if@twoside
       \ifodd\count\z@ \let\@thehead\@oddhead \let\@thefoot\@oddfoot
            \let\@themargin\oddsidemargin
          \else \let\@thehead\@evenhead
          \let\@thefoot\@evenfoot \let\@themargin\evensidemargin
     \fi\fi
     \shipout
     \vbox{\normalsize \baselineskip\z@ \lineskip\z@
           \let\par\@@par %% 15 Sep 87
           \vskip \topmargin \moveright\@themargin
           \my@frame{%
           \vbox{\setbox\@tempboxa
                   \vbox to\headheight{\vfil \hbox to\textwidth
                                       {\let\label\@gobble \let\index\@gobble
                                         \@thehead}} %% 22 Feb 87
                 \dp\@tempboxa\z@
                 \box\@tempboxa
                 \vskip \headsep
                 \box\@outputbox
                 \baselineskip\footskip
                 \hbox to\textwidth{\let\label\@gobble
                           \let\index\@gobble  %% 22 Feb 87
                           \@thefoot}}%
           }% end of my@frame
           }%
           \global\@colht\textheight
           \endgroup\stepcounter{page}\let\firstmark\botmark}

%
% Heading and Footing
%  In part, from fancyheading.sty
%

\def\lhead#1{\gdef\@elhead{#1}\gdef\@olhead{#1}}
\def\chead#1{\gdef\@echead{#1}\gdef\@ochead{#1}}
\def\rhead#1{\gdef\@erhead{#1}\gdef\@orhead{#1}}

\def\lfoot#1{\gdef\@elfoot{#1}\gdef\@olfoot{#1}}
\def\cfoot#1{\gdef\@ecfoot{#1}\gdef\@ocfoot{#1}}
\def\rfoot#1{\gdef\@erfoot{#1}\gdef\@orfoot{#1}}

\def\@slidehead#1#2#3#4#5{#1\hbox to\textwidth%
    {\vbox{\hbox{\rlap{\parbox[b]{\textwidth}%
    {\raggedright#2\strut}}\hfill\parbox[b]{\textwidth}%
    {\centering#3\strut}\hfill\llap{\parbox[b]{\textwidth}%
    {\raggedleft#4\strut}}}}}#5}

\def\@slidefoot#1#2#3#4#5{
    \vspace*{-4mm}\hspace*{7mm}%  
    {\thinredline}%
    \hspace*{-\textwidth}\hspace*{-12mm}%  
    #1\hbox to\textwidth%
    {\vbox{\hbox{\rlap{\parbox[t]{\textwidth}%
    {\raggedright#2\strut}}\hfill\parbox[t]{\textwidth}%
    {\centering#3\strut}\hfill\llap{\parbox[t]{\textwidth}%
    {\raggedleft#4\strut}}}}}#5}

\def\ps@slide{%
    \def\@oddhead{\@slidehead\relax\@olhead\@ochead\@orhead\hss}%
    \def\@oddfoot{\@slidefoot\relax\@olfoot\@ocfoot\@orfoot\hss}%
    \def\@evenhead{\@slidehead\hss\@elhead\@echead\@erhead\relax}%
    \def\@evenfoot{\@slidefoot\hss\@elfoot\@ecfoot\@erfoot\relax}%
    }

\def\ps@empty{%
    \def\@oddhead{\@slidehead\relax\space\space\space\hss}%
    \def\@oddfoot{\@slidefoot\relax\space\space\space\hss}%
    \def\@evenhead{\@slidehead\hss\space\space\space\relax}%
    \def\@evenfoot{\@slidefoot\hss\space\space\space\relax}%
    }

%
% by modifying \fbox in latex.tex
% \Fbox{box sep}{box rule width/height}{...}
%
\def\Fbox#1#2#3{\@alt@box@frame{#2}{#1}{#1}{#3}}

%
% Places a shadow box
% \SFbox{box sep}{box rule width/height}{shade rule width/height}{...}
% 
\def\SFbox#1#2#3#4{\@alt@shadow@box@frame{#2}{#3}{#1}{#1}{#4}}

%
% by modifying \fbox in latex.tex
% \Underline & \Underbar
%
\def\Underline#1{\Red{%
    \leavevmode%
    \setbox\@tempboxa\hbox{\Black{#1}}%
    \@tempdima1pt
    \advance\@tempdima 3pt
    \advance\@tempdima \dp\@tempboxa
    \hbox{\lower \@tempdima%
          \hbox{\vbox{\hbox{\vbox{\box\@tempboxa\vskip3pt}}%
                      \hrule height1pt}}}}}

% from plain.tex
\def\Underbar#1{\Green{$\setbox\z@\hbox{\Black{#1}}\dp\z@\z@
  \m@th \Underline{\box\z@}$}}

%
% Things to be entered in texts
%
\def\title{\@ifnextchar[{\@@Title}{\@Title}}
\def\@Title#1{\def\slide@title{\uppercase{\NavyBlue{#1}}}
              \def\slidetitle{#1}}
\def\@@Title[#1]#2{\def\slide@title{\uppercase{\NavyBlue{#2}}}
              \def\slidetitle{\Blue{#1}}}
\def\slide@title{\hspace*{1pt}}
\def\slidetitle{\hspace*{1pt}}

\def\author{\@ifnextchar[{\@@Author}{\@Author}}
\def\@@Author[#1]#2{\def\slide@author{#2}%
                    \def\slideauthor{#1}}
\def\@Author#1{\def\slide@author{#1}
               \def\slideauthor{#1}}
\def\slide@author{\hspace*{1pt}}
\def\slideauthor{\hspace*{1pt}}

\def\organization#1{\def\authororga{#1}}
\def\authororga{\hspace*{1pt}}

\def\date#1{\def\slidedate{#1}}
\def\slidedate{\today}

%
% section and subsection
%
\newcounter{sec@ctr}
\setcounter{sec@ctr}{1}

\def\section{\@ifnextchar[{\@@Section}{\@Section}}

\def\@Section#1{\clearpage
               \thispagestyle{empty}
               \vspace*{\fill}
%              \begin{center}
               \centerline{\Hugesize\uppercase{\NavyBlue{#1}}}
%              \end{center}
               \vspace*{\fill}
               \def\sectiontitle{#1}
               \Add@@secitem{toc}{\thesec@ctr}{#1}
               \addtocounter{sec@ctr}{1}
               \xdef\sub@section@text{#1}
               \clearpage}

\def\@@Section[#1]#2{\clearpage
               \thispagestyle{empty}
               \vspace*{\fill}
%              \begin{center}
               \centerline{\Hugesize\uppercase{\NavyBlue{#2}}}
%              \end{center}
               \vspace*{\fill}
               \def\sectiontitle{#1}
               \Add@@secitem{toc}{\thesec@ctr}{#1}
               \addtocounter{sec@ctr}{1}
               \xdef\sub@section@text{#1}
               \clearpage}

\def\sectiontitle{\relax}

\def\Add@@secitem#1#2#3{\if@filesw \begingroup
\let\label\@gobble \let\index\@gobble \let\glossary\@gobble
\def\protect##1{\string\string\string##1\string\space
   \space}\@temptokena{\thepage}%
\edef\@tempa{\write \@auxout{\string\@writefile{#1}{\protect
     \secitem{#2}{#3}{\the\@temptokena}}}}\@tempa
   \if@nobreak \ifvmode\nobreak\fi\fi\endgroup\fi}

\gdef\sub@section@text{}

\def\subsection#1{\clearpage
                  \addtocounter{sec@ctr}{-1}
                  \Add@@subsecitem{toc}{\thesec@ctr}{#1}
                  \addtocounter{sec@ctr}{1}
                  \def\subsectiontitle{#1}
                  \xdef\sub@section@text{#1}
                  \pseudosubsection{#1}}

\def\pseudosubsection#1{
%%                  \subsec@begin@vspace
%%                  \hspace*{\fill}
                 \vspace*{-1cm}
                 {\Largesize \Red{#1}}\\
                 \blueline 
%%                   \sub@section@frame{\Largesize #1}
%%                   \hspace*{\fill}
%%                   \subsec@end@vspace
        }

\def\remindtitle{\pseudosubsection{\sub@section@text}}

\def\anitem#1{\addtocounter{sec@ctr}{-1}
              \Add@@subsecitem{toc}{\thesec@ctr}{#1}
              \addtocounter{sec@ctr}{1}
              {#1}}

\def\Add@@subsecitem#1#2#3{\if@filesw \begingroup
\let\label\@gobble \let\index\@gobble \let\glossary\@gobble
\def\protect##1{\string\string\string##1\string\space
   \space}\@temptokena{\thepage}%
\edef\@tempa{\write \@auxout{\string\@writefile{#1}{\protect
     \subsecitem{#2}{#3}{\the\@temptokena}}}}\@tempa
   \if@nobreak \ifvmode\nobreak\fi\fi\endgroup\fi}

%
% titlepage
%
\def\titlepage{\thispagestyle{empty}
    \vspace*{\fill}
    \begin{center}
    \Hugesize \slide@title \\ [2em]
    \Normalsize\slide@author \\ [.5em]
    \Normalsize{\em \authororga} \\ [1em]
    \Normalsize\slidedate
    \end{center}
    \vspace*{\fill}
    \setcounter{page}{0}
    \clearpage}

%
% tables of contents
%
\def\contentsname{CONTENTS}
\def\partcontentsname{PART CONTENTS}

\newcounter{@@@dum@@@}
\setcounter{@@@dum@@@}{0}

\newcounter{@@@dummy@@@}
\setcounter{@@@dummy@@@}{0}

\def\slidecontents{\@ifnextchar*{\@@slidecontents}{\@slidecontents}}

\def\fullslidecontents{\openin1 \jobname.toc \ifeof1 \typeout
           {No file \jobname.toc}\else\closein1\relax
           \def\secitem##1##2##3{%
                 \begin{ccitemize}\contsize
                 \item[\labelitemi] ##2 \dotfill\ ##3\ignorespaces
                 \end{ccitemize}}
           \def\subsecitem##1##2##3{%
                  \begin{citemize}\contsizesize
                  \item[\labelitemii] ##2 \dotfill\ ##3\ignorespaces
                  \end{citemize}}
           \clearpage
           \thispagestyle{empty}
           \addtocounter{page}{-1}
%          \subsec@begin@vspace
           \hspace*{\fill}
           \sub@section@frame{\Largesize\contentsname}
           \hspace*{\fill}
           \subsec@end@vspace
           \input{\jobname.toc}
           \vspace*{\fill}
           \clearpage
           \fi}

\def\@slidecontents{\openin1 \jobname.toc \ifeof1 \typeout
           {No file \jobname.toc}\else\closein1\relax
           \def\secitem##1##2##3{%
               \ifnum\value{@@@dum@@@}=0%
                  \setcounter{@@@dum@@@}{1}%
                  \begin{citemize}\contsize\fi
                  \item[\labelitemi] ##2 \dotfill\ ##3\ignorespaces}
           \def\subsecitem##1##2##3{\ignorespaces}
           \clearpage
           \thispagestyle{empty}
           \addtocounter{page}{-1}
           \subsec@begin@vspace
           \hspace*{\fill}
           \sub@section@frame{\Largesize\contentsname}
           \hspace*{\fill}
           \subsec@end@vspace
           \input{\jobname.toc}
           \ifnum\value{@@@dum@@@}=1%
              \setcounter{@@@dum@@@}{0}%
              \end{citemize}\fi
           \vspace*{\fill}
           \clearpage
           \fi}

\def\@@slidecontents{\openin1 \jobname.toc \ifeof1 \typeout
           {No file \jobname.toc}\else\closein1\relax
           \def\secitem##1##2##3{%
               \ifnum\value{@@@dum@@@}=0%
                  \setcounter{@@@dum@@@}{1}%
                  \begin{citemize}\contsize\fi
                  \item[\labelitemi] ##2 \hspace{\fill}}
           \def\subsecitem##1##2##3{\ignorespaces}
           \clearpage
           \thispagestyle{empty}
           \addtocounter{page}{-1}
           \subsec@begin@vspace
           \hspace*{\fill}
           \sub@section@frame{\Largesize\contentsname}
           \hspace*{\fill}
           \subsec@end@vspace
           \input{\jobname.toc}
           \ifnum\value{@@@dum@@@}=1%
              \setcounter{@@@dum@@@}{0}%
              \end{citemize}\fi
           \vspace*{\fill}
           \clearpage
           \fi}

\def\sectioncontents{\@ifnextchar*{\@@sectioncontents}{\@sectioncontents}}

\@ifundefined{checkmark}%
    {\def\mycheckmark{\Green{\surd}}}%
    {\def\mycheckmark{\Green{\checkmark}}}

\def\mysecpointer{\Red{\Rightarrow}}

\def\@sectioncontents{\openin1 \jobname.toc \ifeof1 \typeout
           {No file \jobname.toc}\else\closein1\relax
           \def\secitem##1##2##3{%
               \ifnum\value{@@@dum@@@}=0%
                  \setcounter{@@@dum@@@}{1}%
                  \begin{citemize}\contsize\fi
               \ifnum\value{@@@dummy@@@}=1%
                  \setcounter{@@@dummy@@@}{0}%
                  \end{ccitemize}\fi
               \item[\ifnum\value{sec@ctr}>##1$\mycheckmark\;$\labelitemi%
                     \else\ifnum\value{sec@ctr}=##1$\mysecpointer$\labelitemi%
                     \else\labelitemi\fi\fi] ##2 \dotfill\ ##3\ignorespaces}
           \def\subsecitem##1##2##3{%
               \ifnum\value{sec@ctr}=##1%
                  \ifnum\value{@@@dummy@@@}=0
                     \setcounter{@@@dummy@@@}{1}
                     \begin{ccitemize}\contsizesize\fi
                  \item[\labelitemii] ##2 \dotfill\ ##3\ignorespaces\fi}
           \clearpage
           \thispagestyle{empty}
           \addtocounter{page}{-1}
%          \subsec@begin@vspace
           \hspace*{\fill}
           \sub@section@frame{\Largesize\partcontentsname}
           \hspace*{\fill}
           \subsec@end@vspace
           \input{\jobname.toc}
           \ifnum\value{@@@dummy@@@}=1%
              \setcounter{@@@dummy@@@}{0}%
              \end{ccitemize}\fi
           \ifnum\value{@@@dum@@@}=1%
              \setcounter{@@@dum@@@}{0}%
              \end{citemize}\fi
           \vspace*{\fill}
           \clearpage
           \fi}

\def\@@sectioncontents*{\openin1 \jobname.toc \ifeof1 \typeout
           {No file \jobname.toc}\else\closein1\relax
           \def\secitem##1##2##3{%
               \ifnum\value{@@@dum@@@}=0%
                  \setcounter{@@@dum@@@}{1}%
                  \begin{citemize}\contsize\fi
               \ifnum\value{@@@dummy@@@}=1%
                  \setcounter{@@@dummy@@@}{0}%
                  \end{ccitemize}\fi
               \item[\ifnum\value{sec@ctr}>##1$\mycheckmark\;$\labelitemi%
                     \else\ifnum\value{sec@ctr}=##1$\mysecpointer$\labelitemi%
                     \else\labelitemi\fi\fi] ##2 \hspace*{\fill}}
           \def\subsecitem##1##2##3{%
               \ifnum\value{sec@ctr}=##1%
                  \ifnum\value{@@@dummy@@@}=0
                     \setcounter{@@@dummy@@@}{1}
                     \begin{ccitemize}\contsizesize\fi
                  \item[\labelitemi]i] ##2 \hspace{\fill}\fi}
           \clearpage
           \thispagestyle{empty}
           \addtocounter{page}{-1}
%          \subsec@begin@vspace
           \hspace*{\fill}
           \sub@section@frame{\Largesize\partcontentsname}
           \hspace*{\fill}
           \subsec@end@vspace
           \input{\jobname.toc}
           \ifnum\value{@@@dummy@@@}=1%
               \setcounter{@@@dummy@@@}{0}%
               \end{ccitemize}\fi
           \ifnum\value{@@@dum@@@}=1%
               \setcounter{@@@dum@@@}{0}%
               \end{citemize}\fi
           \vspace*{\fill}
           \clearpage
           \fi}

\def\citemize{\list{\relax}%
    {\leftmargin=2.5em
     \rightmargin=.5em
     \labelwidth=2em
     \labelsep=.5em
     \def\makelabel##1{\hss\llap{##1}}}}
\let\endcitemize =\endlist

\def\ccitemize{\list{\relax}%
    {\leftmargin=1em
     \rightmargin=.5em % Was 0
     \labelwidth=.5em
     \labelsep=.5em
     \def\makelabel##1{\hss\llap{##1}}}}
\let\endccitemize =\endlist

%
% modifications to enumerate env.
%
\def\labelenumi{\NavyBlue{\theenumi.}}
        \def\theenumi{\arabic{enumi}}
\def\labelenumii{\BurntOrange{\theenumi.\theenumii.}}
        \def\theenumii{\arabic{enumii}}
        \def\p@enumii{\theenumi.}
\def\labelenumiii{\Green{\theenumi.\theenumii.\theenumiii.}}
        \def\theenumiii{\arabic{enumiii}}
        \def\p@enumiii{\theenumi.\theenumii.}
\def\labelenumiv{\Red{\theenumi.\theenumii.\theenumiii.\theenumiv.}}
        \def\theenumiv{\arabic{enumiv}}
        \def\p@enumiv{\theenumi.\theenumii.\theenumiii.}

\def\enumerate{\ifnum \@enumdepth >3 \@toodeep\else
      \advance\@enumdepth \@ne
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}\list
      {\csname label\@enumctr\endcsname}{\usecounter{\@enumctr}
      \labelsep =  .2em
      \ifnum \@enumdepth = 1
             \labelwidth = 1em
             \leftmargin=\leftskip
             \advance\leftmargin1.8em
      \else \ifnum \@enumdepth = 2
                   \labelwidth = 1.6em
                   \leftmargin = 1.8em  %\leftmargin = \labelwidth+\labelsep
            \else \ifnum \@enumdepth = 3
                         \labelwidth = 2.4em
                         \leftmargin = 2.6em
                  \else
                         \labelwidth = 3.2em
                         \leftmargin = 3.4em
                  \fi
            \fi
      \fi
      \def\makelabel##1{\rlap{##1}\hss}}\fi}

%
% Font sizes
%

\def\normalfonts{ 
  \def\Hugesize{\Huge}   % in art12.sty, \Huge = \huge
  \def\Largesize{\huge}  % in art11.sty, \Huge > \huge
  \def\Normalsize{\LARGE}
  \def\Smallsize{\Large}
  \def\contsize{\LARGE}
  \def\contsizesize{\Large}
  \def\smallcontentsfonts{%
    \def\contsize{\Large}
    \def\contsizesize{\large}}
  }
\normalfonts

\def\smallerfonts{%
    \def\Hugesize{\huge}
    \def\Largesize{\LARGE}
    \def\Normalsize{\Large}
    \def\Smallsize{\large}
    \def\contsize{\Large}
    \def\contsizesize{\large}
    \def\smallcontentsfonts{%
        \def\contsize{\large}
        \def\contsizesize{\normalsize}}%
    }

\def\tinyfonts{%
    \def\Hugesize{\Huge}
    \def\Largesize{\Large}
    \def\Normalsize{\normalsize}
    \def\Smallsize{\small}
    \def\contsize{\normalsize}
    \def\contsizesize{\normalsize}
    \def\smallcontentsfonts{%
        \def\contsize{\normalsize}
        \def\contsizesize{\small}}%
    }


%
% modifications to document env.
%

\let\@@@@document\document
\def\document{\@@@@document
    \Normalsize}
\let\@@end@@document\enddocument
\def\enddocument{%
\if@filesw \newwrite\tf@toc
  \immediate\openout\tf@toc=\jobname.toc
  \typeout{Writing toc file \jobname.toc}\fi
    \@@end@@document}

%
% slide environment
%
\newdimen\defaultskip
\def\slide{\@ifnextchar[{\@@Slide}{\@Slide}}
\def\@Slide{\@@Slide[0pt]}
\def\@@Slide[#1]{\slide@begin@vspace
           \begingroup
           \advance\leftskip\defaultskip
           \advance\rightskip\defaultskip
           \advance\leftskip#1
           \advance\rightskip#1
           \advance\leftmargini\leftskip}
\def\endslide{\par\endgroup
              \slide@end@vspace
              \clearpage}

%
% Page vertical spacing types
%
\def\vertcenter{%
    \def\subsec@begin@vspace{\vspace*{\fill}}
    \def\subsec@end@vspace{\vspace*{\fill}}
    \def\slide@begin@vspace{\vspace*{\fill}}
    \def\slide@end@vspace{\vspace*{\fill}}%
    }
\def\verttop{%
    \def\subsec@begin@vspace{\relax}
    \def\subsec@end@vspace{\vspace*{2em}}
    \def\slide@begin@vspace{\relax}
    \def\slide@end@vspace{\relax}%
    }

%
% Page Frame Definitions
%
%% MH if no frame, special version of outputpage!
\def\noframe{\def\my@frame##1{\vbox{##1}}}

\def\doubleboxframe{%
    \def\my@frame##1{%
        \@my@box@frame{.4em}{.3em}{.3em}%
        {\@my@box@frame{1.6pt}{.8em}{.8em}{##1}}}}

\def\shadowframe{%
    \def\my@frame##1{%
        \@my@shadow@box@frame{1.6pt}{3.2pt}{.8em}{.8em}{##1}}}

\def\ovalframe{%
 \def\my@frame##1{\@my@oval@frame{\thicklines}{.4em}{.3em}{##1}}}

%
% Subsection frames
%
\def\boxsecframe{\def\sub@section@frame##1{\Fbox{3pt}{1pt}{##1}}}
\def\shadowsecframe{\def\sub@section@frame##1{\SFbox{3pt}{1pt}{2pt}{##1}}}



%
% defaults
%
% slide head and foot
\lhead{\date}
\chead{\relax}   % empty
\rhead{\sectiontitle}
\lfoot{\slideauthor}
\cfoot{\relax}   % empty
\rfoot{\thepage}

%
\defaultskip=1em
%
\pagestyle{slide}

% no parindent
\parindent 0pt

% \vertcenter vs. \verttop
\vertcenter   % vertical centering

% \doubleboxframe vs. \shadowframe vs. \ovalframe
\shadowframe

% \boxsecframe vs. \shadowsecframe
\shadowsecframe

% hyphenation off. Comment the following line if you want hyphenation on
\pretolerance=10000

% right-justification off
% Comment the following two lines if you want right-justification on
\@rightskip\@flushglue
\rightskip\@rightskip

%% Taken from options
\slidesizes

%
% use pointing hand
%
%\font\handsfont=hands scaled\magstep5
%\def\handright{{\handsfont \char"41}} % 1 in diameter
%\def\handleft{{\handsfont \char"42}} % 2 in diameter
%\def\mysecpointer{\mbox{\handright}\,}
