/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import java.util.HashSet;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.TransactionEntry;
import org.apache.zookeeper.graph.servlets.JsonServlet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Throughput
extends JsonServlet {
    private static final int MS_PER_SEC = 1000;
    private static final int MS_PER_MIN = 60000;
    private static final int MS_PER_HOUR = 3600000;
    private LogSource source = null;

    public Throughput(LogSource src) throws Exception {
        this.source = src;
    }

    @Override
    public String handleRequest(JsonServlet.JsonRequest request) throws Exception {
        String scalestr;
        long starttime = 0L;
        long endtime = 0L;
        long period = 0L;
        long scale = 0L;
        starttime = request.getNumber("start", 0L);
        endtime = request.getNumber("end", 0L);
        period = request.getNumber("period", 0L);
        if (starttime == 0L) {
            starttime = this.source.getStartTime();
        }
        if (endtime == 0L) {
            endtime = period > 0L ? starttime + period : this.source.getEndTime();
        }
        scale = (scalestr = request.getString("scale", "minutes")).equals("seconds") ? 1000L : (scalestr.equals("hours") ? 3600000L : 60000L);
        LogIterator iter = this.source.iterator(starttime, endtime);
        long current = 0L;
        long currentms = 0L;
        HashSet<Long> zxids_ms = new HashSet<Long>();
        long zxidcount = 0L;
        JSONArray events = new JSONArray();
        while (iter.hasNext()) {
            LogEntry e = (LogEntry)iter.next();
            if (e.getType() != LogEntry.Type.TXN) continue;
            TransactionEntry cxn = (TransactionEntry)e;
            long ms = cxn.getTimestamp();
            long inscale = ms / scale;
            if (currentms != ms && currentms != 0L) {
                zxidcount += (long)zxids_ms.size();
                zxids_ms.clear();
            }
            if (inscale != current && current != 0L) {
                JSONObject o = new JSONObject();
                o.put((Object)"time", (Object)(current * scale));
                o.put((Object)"count", (Object)zxidcount);
                events.add((Object)o);
                zxidcount = 0L;
            }
            current = inscale;
            currentms = ms;
            zxids_ms.add(cxn.getZxid());
        }
        JSONObject o = new JSONObject();
        o.put((Object)"time", (Object)(current * scale));
        o.put((Object)"count", (Object)zxidcount);
        events.add((Object)o);
        iter.close();
        return JSONValue.toJSONString((Object)events);
    }
}

