/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.xliff;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.filters4.xml.xliff.AbstractXliffFilter;
import org.omegat.util.OStrings;

public class Xliff1Filter
extends AbstractXliffFilter {
    private String unitId = null;
    private boolean flushedUnit = false;
    private int lastGroupId = 0;
    private final List<XMLEvent> segSource = new LinkedList<XMLEvent>();
    private final Map<String, List<XMLEvent>> subSegments = new TreeMap<String, List<XMLEvent>>();
    private StartElement targetStartEvent = null;
    private int inSubSeg = 0;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("XLIFF1FILTER_FILTER_NAME");
    }

    @Override
    protected final String versionPrefix() {
        return "1.";
    }

    @Override
    protected void cleanBuffers() {
        this.source.clear();
        this.target = null;
        this.note.clear();
        this.segSource.clear();
        this.subSegments.clear();
    }

    @Override
    protected void checkCurrentCursorPosition(XMLStreamReader reader, boolean doWrite) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName().equals("body")) {
                this.isEventMode = true;
            } else if (reader.getLocalName().equals("xliff")) {
                if (this.namespace == null) {
                    this.namespace = reader.getName().getNamespaceURI();
                }
            } else if (reader.getLocalName().equals("file") || reader.getLocalName().equals("group") || reader.getLocalName().equals("unit")) {
                LinkedList<Attribute> attributes = new LinkedList<Attribute>();
                int len = reader.getAttributeCount();
                for (int i = 0; i < len; ++i) {
                    attributes.add(eFactory.createAttribute(reader.getAttributeName(i), reader.getAttributeValue(i)));
                }
                try {
                    this.processStartElement(eFactory.createStartElement(reader.getName(), attributes.iterator(), null), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLStreamWriter writer) throws XMLStreamException {
        switch (startElement.getName().getLocalPart()) {
            case "xliff": {
                if (this.namespace != null) break;
                this.namespace = startElement.getName().getNamespaceURI();
                break;
            }
            case "file": {
                try {
                    this.path = this.path + "/" + startElement.getAttributeByName(new QName("original")).getValue();
                }
                catch (NullPointerException noid) {
                    throw new XMLStreamException(OStrings.getString("XLIFF_MANDATORY_ORIGINAL_MISSING", "original", "file"));
                }
                this.updateIgnoreScope(startElement);
                break;
            }
            case "group": {
                try {
                    this.path = this.path + "/" + startElement.getAttributeByName(new QName("id")).getValue();
                }
                catch (NullPointerException noid) {
                    try {
                        this.path = this.path + "/" + startElement.getAttributeByName(new QName("resname")).getValue();
                    }
                    catch (NullPointerException noresname) {
                        this.path = this.path + "/x-auto-" + this.lastGroupId;
                        ++this.lastGroupId;
                    }
                }
                this.updateIgnoreScope(startElement);
                break;
            }
            case "trans-unit": {
                try {
                    this.unitId = startElement.getAttributeByName(new QName("id")).getValue();
                }
                catch (NullPointerException noid) {
                    throw new XMLStreamException(OStrings.getString("XLIFF_MANDATORY_ORIGINAL_MISSING", "id", "trans-unit"));
                }
                this.flushedUnit = false;
                this.targetStartEvent = null;
                this.updateIgnoreScope(startElement);
                break;
            }
            case "source": {
                this.currentBuffer = this.source;
                this.source.clear();
                break;
            }
            case "target": {
                this.target = new LinkedList();
                this.currentBuffer = this.target;
                this.inTarget = true;
                this.targetStartEvent = startElement;
                break;
            }
            case "note": {
                this.currentBuffer = this.note;
                this.note.clear();
                break;
            }
            case "seg-source": {
                this.currentBuffer = this.segSource;
                this.segSource.clear();
                break;
            }
            case "mrk": {
                if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                    String mid = startElement.getAttributeByName(new QName("mid")).getValue();
                    this.currentBuffer.add(startElement);
                    this.currentBuffer = new LinkedList();
                    if (!this.inTarget) {
                        this.subSegments.put(mid, this.currentBuffer);
                    }
                    ++this.inSubSeg;
                    break;
                }
                if (this.inSubSeg > 0) {
                    ++this.inSubSeg;
                }
            }
            default: {
                if (this.currentBuffer != null) {
                    this.currentBuffer.add(startElement);
                    break;
                }
                if (this.ignoreScope != null && !this.ignoreScope.startsWith("!") || this.unitId == null || startElement.getName().getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:1.2")) break;
                this.flushTranslations(writer);
            }
        }
        return !this.inTarget;
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLStreamWriter writer) throws XMLStreamException {
        switch (endElement.getName().getLocalPart()) {
            case "source": 
            case "seg-source": 
            case "note": {
                this.currentBuffer = null;
                break;
            }
            case "target": {
                this.currentBuffer = null;
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    this.flushTranslations(writer);
                }
                this.inTarget = false;
                return false;
            }
            case "trans-unit": {
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    this.flushTranslations(writer);
                }
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    if (this.subSegments.isEmpty()) {
                        this.registerCurrentTransUnit(this.unitId, this.source, this.target, ".*");
                    } else {
                        for (Map.Entry<String, List<XMLEvent>> me : this.subSegments.entrySet()) {
                            this.registerCurrentTransUnit(this.unitId + "/" + me.getKey(), me.getValue(), this.findSubsegment(this.target, me.getKey()), "\\[(\\d+)\\](.*)\\[\\1\\]");
                        }
                    }
                }
                this.unitId = null;
                this.cleanBuffers();
                if (endElement.getName().getLocalPart().equals(this.ignoreScope)) {
                    this.ignoreScope = null;
                    break;
                }
                if (this.ignoreScope == null || !this.ignoreScope.startsWith("!" + endElement.getName().getLocalPart())) break;
                this.ignoreScope = this.ignoreScope.substring(endElement.getName().getLocalPart().length() + 2);
                break;
            }
            case "group": 
            case "file": {
                this.path = this.path.substring(0, this.path.lastIndexOf(47));
                this.cleanBuffers();
                if (endElement.getName().getLocalPart().equals(this.ignoreScope)) {
                    this.ignoreScope = null;
                    break;
                }
                if (this.ignoreScope == null || !this.ignoreScope.startsWith("!" + endElement.getName().getLocalPart())) break;
                this.ignoreScope = this.ignoreScope.substring(endElement.getName().getLocalPart().length() + 2);
                break;
            }
            case "mrk": {
                if (this.inSubSeg == 1) {
                    List<XMLEvent> save = this.inTarget ? this.target : this.segSource;
                    save.addAll(this.currentBuffer);
                    this.currentBuffer = save;
                    this.currentBuffer.add(endElement);
                    this.inSubSeg = 0;
                    break;
                }
                if (this.inSubSeg > 0) {
                    --this.inSubSeg;
                }
            }
            default: {
                if (this.currentBuffer == null) break;
                this.currentBuffer.add(endElement);
            }
        }
        return !this.inTarget;
    }

    protected void addNoteFromSource(String tag, String noteText) {
        this.note.add(eFactory.createCharacters("[" + tag + "]" + noteText + "[/" + tag + "]"));
    }

    @Override
    protected String[] getPairIdNames(boolean start) {
        return new String[]{"rid", "id", "i"};
    }

    protected boolean isCurrentSegmentTranslated(String mid) {
        if (this.entryTranslateCallback == null || mid == null) {
            return false;
        }
        if (this.subSegments.get(mid) == null) {
            return false;
        }
        return this.entryTranslateCallback.getTranslation(this.unitId + "/" + mid, this.buildTags(this.subSegments.get(mid), false), this.path) != null;
    }

    @Override
    protected String buildTags(List<XMLEvent> srcList, boolean reuse) {
        if (!reuse) {
            this.tagsMap.clear();
            for (Character c : this.tagsCount.keySet()) {
                this.tagsCount.put(c, 0);
            }
        }
        StringBuffer res = new StringBuffer();
        LinkedList<StringBuffer> saveBuf = new LinkedList<StringBuffer>();
        LinkedList<XMLEvent> nativeCode = null;
        block26: for (XMLEvent ev : srcList) {
            if (nativeCode != null) {
                nativeCode.add(ev);
            }
            if (ev.isCharacters()) {
                if (nativeCode != null) continue;
                res.append(ev.asCharacters().getData());
                continue;
            }
            if (ev.isStartElement()) {
                StartElement stEl = ev.asStartElement();
                String name = stEl.getName().getLocalPart();
                char prefix = this.findPrefix(stEl);
                Integer count = (Integer)this.tagsCount.get(Character.valueOf(prefix));
                if (count == null) {
                    count = 0;
                }
                this.tagsCount.put(Character.valueOf(prefix), count + 1);
                switch (name) {
                    case "x": {
                        res.append(this.startPair(reuse, true, stEl, 'x', count, Xliff1Filter.toPair(stEl)));
                        break;
                    }
                    case "bx": {
                        res.append(this.startPair(reuse, false, stEl, prefix, count, Xliff1Filter.toPair(stEl)));
                        break;
                    }
                    case "ex": {
                        res.append(this.endPair(reuse, stEl, prefix, count, Xliff1Filter.toPair(stEl)));
                        break;
                    }
                    case "bpt": {
                        nativeCode = new LinkedList<XMLEvent>();
                        res.append(this.startPair(reuse, false, stEl, prefix, count, nativeCode));
                        saveBuf.push(res);
                        res = new StringBuffer();
                        nativeCode.add(ev);
                        break;
                    }
                    case "ept": {
                        nativeCode = new LinkedList();
                        res.append(this.endPair(reuse, stEl, prefix, count, nativeCode));
                        saveBuf.push(res);
                        res = new StringBuffer();
                        nativeCode.add(ev);
                        break;
                    }
                    default: {
                        if (this.isProtectedTag(stEl)) {
                            nativeCode = new LinkedList();
                            if (reuse) {
                                res.append(this.findKey(stEl, true));
                            } else {
                                String posVal;
                                Attribute posAttr = stEl.getAttributeByName(new QName("pos"));
                                String string = posVal = posAttr == null ? "" : posAttr.getValue();
                                if ("close".equals(posVal) || "end".equals(posVal)) {
                                    this.tagsMap.put("/" + prefix + count, nativeCode);
                                    res.append("</").append(prefix).append(count).append(">");
                                } else {
                                    this.tagsMap.put("" + prefix + count, nativeCode);
                                    if ("open".equals(posVal) || "begin".equals(posVal)) {
                                        res.append("<").append(prefix).append(count).append(">");
                                    } else {
                                        res.append("<").append(prefix).append(count).append("/>");
                                    }
                                }
                            }
                            saveBuf.push(res);
                            res = new StringBuffer();
                            nativeCode.add(ev);
                            this.tagStack.push("mark-protected");
                            break;
                        }
                        if (this.isDeletedTag(stEl)) {
                            this.tagStack.push("mark-deleted");
                            saveBuf.add(res);
                            res = new StringBuffer();
                            break;
                        }
                        if (this.isUntaggedTag(stEl)) {
                            this.tagStack.push("mark-ignored");
                            break;
                        }
                        this.startStackElement(reuse, stEl, prefix, count, res);
                        break;
                    }
                }
                continue;
            }
            if (!ev.isEndElement()) continue;
            EndElement endEl = ev.asEndElement();
            switch (endEl.getName().getLocalPart()) {
                case "x": 
                case "bx": 
                case "ex": {
                    continue block26;
                }
                case "bpt": 
                case "ept": {
                    nativeCode = null;
                    res.setLength(0);
                    res = (StringBuffer)saveBuf.pop();
                    continue block26;
                }
            }
            String pop = (String)this.tagStack.pop();
            if (pop.equals("mark-protected")) {
                nativeCode = null;
                res.setLength(0);
                res = (StringBuffer)saveBuf.pop();
                continue;
            }
            if (pop.equals("mark-deleted")) {
                res.setLength(0);
                res = (StringBuffer)saveBuf.pop();
                continue;
            }
            if (pop.equals("mark-ignored")) continue;
            this.tagsMap.put("/" + pop, Collections.singletonList(ev));
            res.append("</").append(pop).append(">");
        }
        return res.toString();
    }

    protected char findPrefix(StartElement stEl) {
        Attribute ctype = stEl.getAttributeByName(new QName("ctype"));
        if (ctype == null || ctype.getValue() == null || ctype.getValue().length() == 0) {
            ctype = stEl.getAttributeByName(new QName("type"));
        }
        if (ctype != null && ctype.getValue().length() > 0) {
            if (ctype.getValue().startsWith("x-")) {
                return Character.toLowerCase(ctype.getValue().charAt(2));
            }
            return Character.toLowerCase(ctype.getValue().charAt(0));
        }
        String name = stEl.getName().getLocalPart();
        if (name.equals("bx") || name.equals("ex")) {
            return 'e';
        }
        if (name.equals("bpt") || name.equals("ept")) {
            return 't';
        }
        if (name.equals("it")) {
            return 'a';
        }
        if (!stEl.getName().getNamespaceURI().equals(this.namespace)) {
            return 'o';
        }
        return name.charAt(0);
    }

    protected boolean isProtectedTag(StartElement stEl) {
        return stEl.getName().equals(new QName(this.namespace, "ph")) || stEl.getName().equals(new QName(this.namespace, "it")) || stEl.getName().equals(new QName(this.namespace, "mrk")) && stEl.getAttributeByName(new QName("mtype")).getValue().equals("protected");
    }

    protected boolean isDeletedTag(StartElement stEl) {
        return false;
    }

    protected boolean isUntaggedTag(StartElement stEl) {
        return false;
    }

    protected boolean isStandardTranslationState() {
        return true;
    }

    protected final void generateTargetStartElement(XMLStreamWriter writer) throws XMLStreamException {
        boolean isTranslated;
        if (!this.isStandardTranslationState()) {
            if (this.targetStartEvent == null) {
                writer.writeStartElement(this.namespace, "target");
            } else {
                this.fromEventToWriter(this.targetStartEvent, writer);
            }
            return;
        }
        if (this.subSegments.isEmpty()) {
            isTranslated = this.entryTranslateCallback.getTranslation(this.unitId, this.buildTags(this.source, false), this.path) != null;
        } else {
            isTranslated = true;
            for (String mid : this.subSegments.keySet()) {
                isTranslated = isTranslated && null != this.entryTranslateCallback.getTranslation(this.unitId + "/" + mid, this.buildTags(this.subSegments.get(mid), false), this.path);
            }
        }
        if (isTranslated) {
            writer.writeStartElement(this.namespace, "target");
            writer.writeAttribute("state", "translated");
            if (this.targetStartEvent != null) {
                Iterator<Attribute> iter = this.targetStartEvent.getAttributes();
                while (iter.hasNext()) {
                    Attribute next = iter.next();
                    if ("state".equals(next.getName().getLocalPart())) continue;
                    writer.writeAttribute(next.getName().getPrefix(), next.getName().getNamespaceURI(), next.getName().getLocalPart(), next.getValue());
                }
            }
        } else if (this.targetStartEvent == null) {
            writer.writeStartElement(this.namespace, "target");
        } else {
            this.fromEventToWriter(this.targetStartEvent, writer);
        }
    }

    private void flushTranslations(XMLStreamWriter writer) throws XMLStreamException {
        if (writer == null) {
            return;
        }
        if (this.flushedUnit) {
            return;
        }
        if (this.subSegments.isEmpty()) {
            String src = this.buildTags(this.source, false);
            String tra = this.entryTranslateCallback.getTranslation(this.unitId, src, this.path);
            if (tra != null) {
                this.generateTargetStartElement(writer);
                for (XMLEvent ev : this.restoreTags(tra)) {
                    this.fromEventToWriter(ev, writer);
                }
            } else {
                if (this.target == null) {
                    return;
                }
                this.generateTargetStartElement(writer);
                for (XMLEvent ev : this.target) {
                    this.fromEventToWriter(ev, writer);
                }
            }
        } else {
            this.inSubSeg = 0;
            this.generateTargetStartElement(writer);
            for (XMLEvent ev : this.segSource) {
                XMLEvent el;
                if (ev.isStartElement() && (el = ev.asStartElement()).getName().getLocalPart().equals("mrk")) {
                    if (el.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                        this.fromEventToWriter(ev, writer);
                        String mid = el.getAttributeByName(new QName("mid")).getValue();
                        String src = this.buildTags(this.subSegments.get(mid), false);
                        String tra = this.entryTranslateCallback.getTranslation(this.unitId + "/" + mid, src, this.path);
                        if (tra != null) {
                            for (XMLEvent tev : this.restoreTags(this.unitId, this.path, src, tra)) {
                                this.fromEventToWriter(tev, writer);
                            }
                        } else {
                            List<XMLEvent> fromTarget = this.findSubsegment(this.target, mid);
                            if (fromTarget != null && fromTarget.size() > 0) {
                                for (XMLEvent tev : fromTarget) {
                                    this.fromEventToWriter(tev, writer);
                                }
                            } else {
                                for (XMLEvent tev : this.subSegments.get(mid)) {
                                    this.fromEventToWriter(tev, writer);
                                }
                            }
                        }
                        ++this.inSubSeg;
                    } else if (this.inSubSeg > 0) {
                        ++this.inSubSeg;
                    }
                }
                if (ev.isEndElement() && (el = ev.asEndElement()).getName().getLocalPart().equals("mrk") && this.inSubSeg > 0) {
                    --this.inSubSeg;
                }
                if (this.inSubSeg != 0) continue;
                this.fromEventToWriter(ev, writer);
            }
        }
        writer.writeEndElement();
        this.flushedUnit = true;
    }

    protected List<XMLEvent> restoreTags(String unitId, String path, String src, String tra) {
        return this.restoreTags(tra);
    }

    private List<XMLEvent> findSubsegment(List<XMLEvent> list, String mid) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        LinkedList<XMLEvent> buf = new LinkedList<XMLEvent>();
        int depth = 0;
        for (XMLEvent ev : this.target) {
            XMLEvent el;
            if (ev.isEndElement() && (el = ev.asEndElement()).getName().getLocalPart().equals("mrk")) {
                if (depth == 1) {
                    return buf;
                }
                if (depth > 0) {
                    --depth;
                }
            }
            if (depth > 0) {
                buf.add(ev);
            }
            if (!ev.isStartElement() || !(el = ev.asStartElement()).getName().getLocalPart().equals("mrk")) continue;
            if (el.getAttributeByName(new QName("mtype")).getValue().equals("seg") && el.getAttributeByName(new QName("mid")).getValue().equals(mid)) {
                depth = 1;
                continue;
            }
            if (depth <= 0) continue;
            ++depth;
        }
        return buf;
    }
}

