/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.StyleConstants;
import org.omegat.core.data.ProtectedPart;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.util.Preferences;
import org.omegat.util.gui.UIThreadsUtil;

public class DocumentFilter3
extends DocumentFilter {
    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        UIThreadsUtil.mustBeSwingThread();
        if (this.isPossible(fb.getDocument(), offset, length)) {
            super.remove(fb, offset, length);
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        UIThreadsUtil.mustBeSwingThread();
        if (attr != null) {
            ((Document3)fb.getDocument()).textBeingComposed = attr.isDefined(StyleConstants.ComposedTextAttribute);
        }
        if (this.isPossible(fb.getDocument(), offset, 0)) {
            super.insertString(fb, offset, string, attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        UIThreadsUtil.mustBeSwingThread();
        if (attrs != null) {
            ((Document3)fb.getDocument()).textBeingComposed = attrs.isDefined(StyleConstants.ComposedTextAttribute);
        }
        if (this.isPossible(fb.getDocument(), offset, length)) {
            super.replace(fb, offset, length, text, attrs);
        }
    }

    private boolean isPossible(Document d, int offset, int length) throws BadLocationException {
        Document3 doc = (Document3)d;
        if (doc.trustedChangesInProgress) {
            return true;
        }
        if (!doc.isEditMode()) {
            return false;
        }
        if (offset < doc.getTranslationStart() || offset + length > doc.getTranslationEnd()) {
            return false;
        }
        if (!Preferences.isPreference("allowTagEditing")) {
            SegmentBuilder sb = doc.controller.getCurrentSegmentBuilder();
            if (sb == null) {
                return false;
            }
            String text = doc.getText(doc.getTranslationStart(), doc.getTranslationEnd() - doc.getTranslationStart());
            int off = offset - doc.getTranslationStart();
            for (ProtectedPart pp : sb.ste.getProtectedParts()) {
                int pos = -1;
                while ((pos = text.indexOf(pp.getTextInSourceSegment(), pos + 1)) >= 0) {
                    int checkPos = pos;
                    int checkLen = pp.getTextInSourceSegment().length();
                    if (sb.hasRTL && doc.controller.targetLangIsRTL && EditorUtils.hasBidiAroundTag(text, pp.getTextInSourceSegment(), pos)) {
                        checkPos -= 2;
                        checkLen += 4;
                    }
                    if (off > checkPos && off < checkPos + checkLen) {
                        return false;
                    }
                    if (off + length <= checkPos || off + length >= checkPos + checkLen) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

