/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.notes;

import java.awt.Dimension;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.undo.UndoManager;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.notes.INotes;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.JTextPaneLinkifier;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class NotesTextArea
extends EntryInfoPane<String>
implements INotes,
IPaneMenu {
    private static final String EXPLANATION = OStrings.getString("GUI_NOTESWINDOW_explanation");
    UndoManager undoManager;
    private DockableScrollPane scrollPane;

    public NotesTextArea(IMainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_NOTESWINDOW_SUBWINDOWTITLE_Notes");
        this.scrollPane = new DockableScrollPane("NOTES", title, this, true);
        mw.addDockable(this.scrollPane);
        this.setEditable(false);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        JTextPaneLinkifier.linkify(this);
        this.undoManager = new UndoManager();
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
    }

    @Override
    public void clear() {
        super.clear();
        this.setEditable(false);
        this.undoManager.discardAllEdits();
    }

    @Override
    public void setNoteText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        if (Preferences.isPreference("notify_notes")) {
            if (StringUtil.isEmpty(text)) {
                this.scrollPane.stopNotifying();
            } else {
                this.scrollPane.notify(true);
            }
        }
        this.setText(text);
        this.setEditable(true);
    }

    @Override
    public String getNoteText() {
        UIThreadsUtil.mustBeSwingThread();
        String text = this.getText();
        return text.isEmpty() ? null : text;
    }

    @Override
    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    @Override
    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    @Override
    public void populatePaneMenu(JPopupMenu menu) {
        JCheckBoxMenuItem notify = new JCheckBoxMenuItem(OStrings.getString("GUI_NOTESWINDOW_NOTIFICATIONS"));
        notify.setSelected(Preferences.isPreference("notify_notes"));
        notify.addActionListener(e -> Preferences.setPreference("notify_notes", notify.isSelected()));
        menu.add(notify);
    }

    @Override
    public void requestFocus() {
        StaticUIUtils.requestVisible(this.scrollPane);
        this.scrollPane.getViewport().getView().requestFocusInWindow();
    }
}

