/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;

public class SVNLogEntryPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char TYPE_ADDED = 'A';
    public static final char TYPE_DELETED = 'D';
    public static final char TYPE_MODIFIED = 'M';
    public static final char TYPE_REPLACED = 'R';
    private String myPath;
    private char myType;
    private String myCopyPath;
    private long myCopyRevision;
    private SVNNodeKind myNodeKind;

    public SVNLogEntryPath(String path, char type, String copyPath, long copyRevision) {
        this(path, type, copyPath, copyRevision, SVNNodeKind.UNKNOWN);
    }

    public SVNLogEntryPath(String path, char type, String copyPath, long copyRevision, SVNNodeKind kind) {
        this.myPath = path;
        this.myType = type;
        this.myCopyPath = copyPath;
        this.myCopyRevision = copyRevision;
        this.myNodeKind = kind;
    }

    public String getCopyPath() {
        return this.myCopyPath;
    }

    public long getCopyRevision() {
        return this.myCopyRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    public char getType() {
        return this.myType;
    }

    public SVNNodeKind getKind() {
        return this.myNodeKind;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    protected void setChangeType(char type) {
        this.myType = type;
    }

    protected void setCopyRevision(long revision) {
        this.myCopyRevision = revision;
    }

    protected void setCopyPath(String path) {
        this.myCopyPath = path;
    }

    protected void setNodeKind(SVNNodeKind nodeKind) {
        this.myNodeKind = nodeKind;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.myPath == null ? 0 : this.myPath.hashCode());
        result = 31 * result + this.myType;
        result = 31 * result + (this.myCopyPath == null ? 0 : this.myCopyPath.hashCode());
        result = 31 * result + (int)(this.myCopyRevision ^ this.myCopyRevision >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SVNLogEntryPath)) {
            return false;
        }
        SVNLogEntryPath other = (SVNLogEntryPath)obj;
        return this.myCopyRevision == other.myCopyRevision && this.myType == other.myType && SVNLogEntry.compare(this.myPath, other.myPath) && SVNLogEntry.compare(this.myCopyPath, other.myCopyPath);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.myType);
        result.append(' ');
        result.append(this.myPath);
        if (this.myCopyPath != null) {
            result.append("(from ");
            result.append(this.myCopyPath);
            result.append(':');
            result.append(this.myCopyRevision);
            result.append(')');
        }
        return result.toString();
    }
}

