/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.gosen.GosenPartOfSpeechStopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.Version;

public class GosenPartOfSpeechStopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private boolean enablePositionIncrements;
    private final String stopTagFiles;
    private Set<String> stopTags;

    public GosenPartOfSpeechStopFilterFactory(Map<String, String> args) {
        super(args);
        this.stopTagFiles = this.require(args, "tags");
        if (!this.luceneMatchVersion.onOrAfter(Version.LUCENE_5_0_0)) {
            this.enablePositionIncrements = this.getBoolean(args, "enablePositionIncrements", true);
            if (!this.enablePositionIncrements && (this.luceneMatchVersion == null || this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0))) {
                throw new IllegalArgumentException("enablePositionIncrements=false is not supported anymore as of Lucene 4.4");
            }
        } else if (args.containsKey("enablePositionIncrements")) {
            throw new IllegalArgumentException("enablePositionIncrements is not a valid option as of Lucene 5.0");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public void inform(ResourceLoader loader) {
        try {
            CharArraySet cas = this.getWordSet(loader, this.stopTagFiles, false);
            this.stopTags = new HashSet<String>();
            for (Object element : cas) {
                char[] chars = (char[])element;
                this.stopTags.add(new String(chars));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenStream create(TokenStream stream) {
        if (this.stopTags != null) {
            GosenPartOfSpeechStopFilter filter = new GosenPartOfSpeechStopFilter(stream, this.stopTags);
            return filter;
        }
        return stream;
    }
}

