/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.shardresultserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommandResult;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformerUtils;

public class SearchGroupsResultTransformer
implements ShardResultTransformer<List<Command>, Map<String, SearchGroupsFieldCommandResult>> {
    private static final String TOP_GROUPS = "topGroups";
    private static final String GROUP_COUNT = "groupCount";
    private final SolrIndexSearcher searcher;

    public SearchGroupsResultTransformer(SolrIndexSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public NamedList transform(List<Command> data) throws IOException {
        NamedList result = new NamedList(data.size());
        for (Command command : data) {
            Integer groupedCount;
            NamedList commandResult = new NamedList(2);
            if (!SearchGroupsFieldCommand.class.isInstance(command)) continue;
            SearchGroupsFieldCommand fieldCommand = (SearchGroupsFieldCommand)command;
            SearchGroupsFieldCommandResult fieldCommandResult = fieldCommand.result();
            Collection<SearchGroup<BytesRef>> searchGroups = fieldCommandResult.getSearchGroups();
            if (searchGroups != null) {
                commandResult.add(TOP_GROUPS, (Object)this.serializeSearchGroup(searchGroups, fieldCommand));
            }
            if ((groupedCount = fieldCommandResult.getGroupCount()) != null) {
                commandResult.add(GROUP_COUNT, (Object)groupedCount);
            }
            result.add(command.getKey(), (Object)commandResult);
        }
        return result;
    }

    private SearchGroup<BytesRef> deserializeOneSearchGroup(SchemaField groupField, String groupValue, SortField[] groupSortField, List<Comparable> rawSearchGroupData) {
        SearchGroup searchGroup = new SearchGroup();
        searchGroup.groupValue = null;
        if (groupValue != null) {
            if (groupField != null) {
                BytesRefBuilder builder = new BytesRefBuilder();
                groupField.getType().readableToIndexed(groupValue, builder);
                searchGroup.groupValue = builder.get();
            } else {
                searchGroup.groupValue = new BytesRef((CharSequence)groupValue);
            }
        }
        searchGroup.sortValues = rawSearchGroupData.toArray(new Comparable[rawSearchGroupData.size()]);
        for (int i = 0; i < searchGroup.sortValues.length; ++i) {
            SchemaField field = groupSortField[i].getField() != null ? this.searcher.getSchema().getFieldOrNull(groupSortField[i].getField()) : null;
            searchGroup.sortValues[i] = ShardResultTransformerUtils.unmarshalSortValue(searchGroup.sortValues[i], field);
        }
        return searchGroup;
    }

    @Override
    public Map<String, SearchGroupsFieldCommandResult> transformToNative(NamedList<NamedList> shardResponse, Sort groupSort, Sort withinGroupSort, String shard) {
        HashMap<String, SearchGroupsFieldCommandResult> result = new HashMap<String, SearchGroupsFieldCommandResult>(shardResponse.size());
        for (Map.Entry command : shardResponse) {
            ArrayList<SearchGroup<BytesRef>> searchGroups = new ArrayList<SearchGroup<BytesRef>>();
            NamedList topGroupsAndGroupCount = (NamedList)command.getValue();
            NamedList rawSearchGroups = (NamedList)topGroupsAndGroupCount.get(TOP_GROUPS);
            if (rawSearchGroups != null) {
                SchemaField groupField = this.searcher.getSchema().getFieldOrNull((String)command.getKey());
                SortField[] groupSortField = groupSort.getSort();
                for (Map.Entry rawSearchGroup : rawSearchGroups) {
                    SearchGroup<BytesRef> searchGroup = this.deserializeOneSearchGroup(groupField, (String)rawSearchGroup.getKey(), groupSortField, (List)rawSearchGroup.getValue());
                    searchGroups.add(searchGroup);
                }
            }
            Integer groupCount = (Integer)topGroupsAndGroupCount.get(GROUP_COUNT);
            result.put((String)command.getKey(), new SearchGroupsFieldCommandResult(groupCount, searchGroups));
        }
        return result;
    }

    private Object[] serializeOneSearchGroup(SortField[] groupSortField, SearchGroup<BytesRef> searchGroup) {
        Object[] convertedSortValues = new Object[searchGroup.sortValues.length];
        for (int i = 0; i < searchGroup.sortValues.length; ++i) {
            Object sortValue = searchGroup.sortValues[i];
            SchemaField field = groupSortField[i].getField() != null ? this.searcher.getSchema().getFieldOrNull(groupSortField[i].getField()) : null;
            convertedSortValues[i] = ShardResultTransformerUtils.marshalSortValue(sortValue, field);
        }
        return convertedSortValues;
    }

    private NamedList serializeSearchGroup(Collection<SearchGroup<BytesRef>> data, SearchGroupsFieldCommand command) {
        NamedList result = new NamedList(data.size());
        SortField[] groupSortField = command.getGroupSort().getSort();
        for (SearchGroup<BytesRef> searchGroup : data) {
            Object[] convertedSortValues = this.serializeOneSearchGroup(groupSortField, searchGroup);
            SchemaField field = this.searcher.getSchema().getFieldOrNull(command.getKey());
            String groupValue = searchGroup.groupValue != null ? field.getType().indexedToReadable((BytesRef)searchGroup.groupValue, new CharsRefBuilder()).toString() : null;
            result.add(groupValue, (Object)convertedSortValues);
        }
        return result;
    }
}

