/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.MemoryGroup;
import org.apache.catalina.users.MemoryGroupCreationFactory;
import org.apache.catalina.users.MemoryRole;
import org.apache.catalina.users.MemoryRoleCreationFactory;
import org.apache.catalina.users.MemoryUser;
import org.apache.catalina.users.MemoryUserCreationFactory;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.ObjectCreationFactory;

public class MemoryUserDatabase
implements UserDatabase {
    private static Log log = LogFactory.getLog((Class)MemoryUserDatabase.class);
    protected HashMap groups = new HashMap();
    protected String id = null;
    protected String pathname = "conf/tomcat-users.xml";
    protected String pathnameOld = this.pathname + ".old";
    protected String pathnameNew = this.pathname + ".new";
    protected boolean readonly = false;
    protected HashMap roles = new HashMap();
    private static StringManager sm = StringManager.getManager("org.apache.catalina.users");
    protected HashMap users = new HashMap();

    public MemoryUserDatabase() {
    }

    public MemoryUserDatabase(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGroups() {
        HashMap hashMap = this.groups;
        synchronized (hashMap) {
            return this.groups.values().iterator();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.pathnameOld = pathname + ".old";
        this.pathnameNew = pathname + ".new";
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getRoles() {
        HashMap hashMap = this.roles;
        synchronized (hashMap) {
            return this.roles.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getUsers() {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            return this.users.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        this.save();
        HashMap hashMap = this.groups;
        synchronized (hashMap) {
            HashMap hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.clear();
                this.groups.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group createGroup(String groupname, String description) {
        MemoryGroup group = new MemoryGroup(this, groupname, description);
        HashMap hashMap = this.groups;
        synchronized (hashMap) {
            this.groups.put(group.getGroupname(), group);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role createRole(String rolename, String description) {
        MemoryRole role = new MemoryRole(this, rolename, description);
        HashMap hashMap = this.roles;
        synchronized (hashMap) {
            this.roles.put(role.getRolename(), role);
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User createUser(String username, String password, String fullName) {
        MemoryUser user = new MemoryUser(this, username, password, fullName);
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            this.users.put(user.getUsername(), user);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group findGroup(String groupname) {
        HashMap hashMap = this.groups;
        synchronized (hashMap) {
            return (Group)this.groups.get(groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role findRole(String rolename) {
        HashMap hashMap = this.roles;
        synchronized (hashMap) {
            return (Role)this.roles.get(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUser(String username) {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            return (User)this.users.get(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        HashMap hashMap = this.groups;
        synchronized (hashMap) {
            HashMap hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.clear();
                this.groups.clear();
                this.roles.clear();
                File file = new File(this.pathname);
                if (!file.isAbsolute()) {
                    file = new File(System.getProperty("catalina.base"), this.pathname);
                }
                if (!file.exists()) {
                    return;
                }
                FileInputStream fis = new FileInputStream(file);
                Digester digester = new Digester();
                digester.addFactoryCreate("tomcat-users/group", (ObjectCreationFactory)new MemoryGroupCreationFactory(this));
                digester.addFactoryCreate("tomcat-users/role", (ObjectCreationFactory)new MemoryRoleCreationFactory(this));
                digester.addFactoryCreate("tomcat-users/user", (ObjectCreationFactory)new MemoryUserCreationFactory(this));
                try {
                    digester.parse((InputStream)fis);
                    fis.close();
                }
                catch (Exception e) {
                    try {
                        fis.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(Group group) {
        HashMap hashMap = this.groups;
        synchronized (hashMap) {
            Iterator users = this.getUsers();
            while (users.hasNext()) {
                User user = (User)users.next();
                user.removeGroup(group);
            }
            this.groups.remove(group.getGroupname());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRole(Role role) {
        HashMap hashMap = this.roles;
        synchronized (hashMap) {
            Iterator groups = this.getGroups();
            while (groups.hasNext()) {
                Group group = (Group)groups.next();
                group.removeRole(role);
            }
            Iterator users = this.getUsers();
            while (users.hasNext()) {
                User user = (User)users.next();
                user.removeRole(role);
            }
            this.roles.remove(role.getRolename());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(User user) {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            this.users.remove(user.getUsername());
        }
    }

    public boolean isWriteable() {
        File dir;
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        return (dir = file.getParentFile()).exists() && dir.isDirectory() && dir.canWrite();
    }

    public void save() throws Exception {
        if (this.getReadonly()) {
            return;
        }
        if (!this.isWriteable()) {
            log.warn((Object)sm.getString("memoryUserDatabase.notPersistable"));
            return;
        }
        File fileNew = new File(this.pathnameNew);
        if (!fileNew.isAbsolute()) {
            fileNew = new File(System.getProperty("catalina.base"), this.pathnameNew);
        }
        PrintWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileNew);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
            writer = new PrintWriter(osw);
            writer.println("<?xml version='1.0' encoding='utf-8'?>");
            writer.println("<tomcat-users>");
            Iterator values = null;
            values = this.getRoles();
            while (values.hasNext()) {
                writer.print("  ");
                writer.println(values.next());
            }
            values = this.getGroups();
            while (values.hasNext()) {
                writer.print("  ");
                writer.println(values.next());
            }
            values = this.getUsers();
            while (values.hasNext()) {
                writer.print("  ");
                writer.println(((MemoryUser)values.next()).toXml());
            }
            writer.println("</tomcat-users>");
            if (writer.checkError()) {
                writer.close();
                fileNew.delete();
                throw new IOException(sm.getString("memoryUserDatabase.writeException", fileNew.getAbsolutePath()));
            }
            writer.close();
        }
        catch (IOException e) {
            if (writer != null) {
                writer.close();
            }
            fileNew.delete();
            throw e;
        }
        File fileOld = new File(this.pathnameOld);
        if (!fileOld.isAbsolute()) {
            fileOld = new File(System.getProperty("catalina.base"), this.pathnameOld);
        }
        fileOld.delete();
        File fileOrig = new File(this.pathname);
        if (!fileOrig.isAbsolute()) {
            fileOrig = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (fileOrig.exists()) {
            fileOld.delete();
            if (!fileOrig.renameTo(fileOld)) {
                throw new IOException(sm.getString("memoryUserDatabase.renameOld", fileOld.getAbsolutePath()));
            }
        }
        if (!fileNew.renameTo(fileOrig)) {
            if (fileOld.exists()) {
                fileOld.renameTo(fileOrig);
            }
            throw new IOException(sm.getString("memoryUserDatabase.renameNew", fileOrig.getAbsolutePath()));
        }
        fileOld.delete();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MemoryUserDatabase[id=");
        sb.append(this.id);
        sb.append(",pathname=");
        sb.append(this.pathname);
        sb.append(",groupCount=");
        sb.append(this.groups.size());
        sb.append(",roleCount=");
        sb.append(this.roles.size());
        sb.append(",userCount=");
        sb.append(this.users.size());
        sb.append("]");
        return sb.toString();
    }

    StringManager getStringManager() {
        return sm;
    }
}

