#!/bin/sh
#
# Extract summary results from the ATF test output and store it in
# the database.
#
# Copyright (c) 2009-2010 Andreas Gustafsson.  All rights reserved.
# Please refer to the file COPYRIGHT for detailed copyright information.
#

cd $1

if test -f test.log.gz
then
    # Note: some versions of atf-report say "expected failures", while the current
    # version says "expected failed test cases".
    zcat test.log.gz | sed -n \
        -e 's/^ *\([0-9][0-9]*\) \([a-z][a-z]*\) test cases.*$/\2_tests=\1/p' \
        -e 's/^ *\([0-9][0-9]*\) expected fail.*$/\expected_failure_tests=\1/p' \
        -e 's!^df-pre-test /dev/wd0a  *[0-9][0-9]*  *\([0-9][0-9]*\).*$!disk_usage_after_install=\1!p' \
        -e 's!^df-post-test /dev/wd0a  *[0-9][0-9]*  *\([0-9][0-9]*\).*$!disk_usage_after_test=\1!p' \
        >>bracket.db
fi
