/*****
 NAME
	cstring.h - header file for CString class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(CSTRING_H_INCLUDED)
#define CSTRING_H_INCLUDED

#include <coconut/cobject.h>
#include <coconut/pstring.h>
#include <coconut/pmemory.h>

@interface CString : CObject <PStringFactory, PString>
{
	id <PMemory>	this_memory ;
}

  /* if you pass null pointer as source strings, this method returns the
     empty strings */
+ (id <PString>) newString ;
+ (id <PString>) newString: (const utf8_char *) str ;
+ (id <PString>) newString: (const utf8_char *) str length: (u_int) len ;
+ (id <PString>) newStringFromBasicStr: (id <PBasicStr>) conststr ;

- initStringWithPtr: (const utf8_char *) str ;
- initStringWithPtr: (const utf8_char *) str length: (u_int) len ;
- initStringWithPage: (size_t) unit ;
- initStringWithPtrAndPage: (const utf8_char *) str page: (size_t) unit ;
- initStringWithPtrAndPage: (const utf8_char *) str length: (u_int) len 
    page: (size_t) unit ;
- initString: (id <PMemory>) memory str:(const utf8_char *) str ;
- initString: (id <PMemory>) memory str:(const utf8_char *) str 
    length: (u_int) len ;

@end

#endif /* defined(CSTRING_H_INCLUDED) */

