/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class SubQueryAlias
extends UnaryPlan {
    private final String alias;

    public SubQueryAlias(Source source, LogicalPlan child, String alias) {
        super(source, child);
        this.alias = alias;
    }

    @Override
    protected NodeInfo<SubQueryAlias> info() {
        return NodeInfo.create(this, SubQueryAlias::new, this.child(), this.alias);
    }

    @Override
    protected SubQueryAlias replaceChild(LogicalPlan newChild) {
        return new SubQueryAlias(this.source(), newChild, this.alias);
    }

    public String alias() {
        return this.alias;
    }

    @Override
    public List<Attribute> output() {
        return this.alias == null ? this.child().output() : this.child().output().stream().map(e -> e.withQualifier(this.alias)).collect(Collectors.toList());
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alias, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SubQueryAlias other = (SubQueryAlias)obj;
        return Objects.equals(this.alias, other.alias);
    }
}

