/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.kerberos;

import java.util.Arrays;
import java.util.Base64;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;

public final class KerberosAuthenticationToken
implements AuthenticationToken {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTH_HEADER = "Authorization";
    public static final String NEGOTIATE_SCHEME_NAME = "Negotiate";
    public static final String NEGOTIATE_AUTH_HEADER_PREFIX = "Negotiate ";
    private static final boolean IGNORE_CASE_AUTH_HEADER_MATCH = true;
    private final byte[] decodedToken;

    public KerberosAuthenticationToken(byte[] decodedToken) {
        this.decodedToken = decodedToken;
    }

    public static KerberosAuthenticationToken extractToken(String authorizationHeader) {
        if (Strings.isNullOrEmpty((String)authorizationHeader)) {
            return null;
        }
        if (!authorizationHeader.regionMatches(true, 0, NEGOTIATE_AUTH_HEADER_PREFIX, 0, NEGOTIATE_AUTH_HEADER_PREFIX.length())) {
            return null;
        }
        String base64EncodedToken = authorizationHeader.substring(NEGOTIATE_AUTH_HEADER_PREFIX.length()).trim();
        if (Strings.isEmpty((CharSequence)base64EncodedToken)) {
            throw KerberosAuthenticationToken.unauthorized("invalid negotiate authentication header value, expected base64 encoded token but value is empty", null, new Object[0]);
        }
        byte[] decodedKerberosTicket = null;
        try {
            decodedKerberosTicket = Base64.getDecoder().decode(base64EncodedToken);
        }
        catch (IllegalArgumentException iae) {
            throw KerberosAuthenticationToken.unauthorized("invalid negotiate authentication header value, could not decode base64 token {}", iae, base64EncodedToken);
        }
        return new KerberosAuthenticationToken(decodedKerberosTicket);
    }

    public String principal() {
        return "<Kerberos Token>";
    }

    public Object credentials() {
        return this.decodedToken;
    }

    public void clearCredentials() {
        Arrays.fill(this.decodedToken, (byte)0);
    }

    public int hashCode() {
        return Arrays.hashCode(this.decodedToken);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KerberosAuthenticationToken otherKerbToken = (KerberosAuthenticationToken)other;
        return Arrays.equals(otherKerbToken.decodedToken, this.decodedToken);
    }

    static ElasticsearchSecurityException unauthorized(String message, Throwable cause, Object ... args) {
        ElasticsearchSecurityException ese = new ElasticsearchSecurityException(message, RestStatus.UNAUTHORIZED, cause, args);
        ese.addHeader(WWW_AUTHENTICATE, new String[]{NEGOTIATE_SCHEME_NAME});
        return ese;
    }

    static ElasticsearchSecurityException unauthorizedWithOutputToken(ElasticsearchSecurityException ese, String outToken) {
        assert (ese.status() == RestStatus.UNAUTHORIZED);
        if (Strings.hasText((String)outToken)) {
            ese.addHeader(WWW_AUTHENTICATE, new String[]{NEGOTIATE_AUTH_HEADER_PREFIX + outToken});
        }
        return ese;
    }
}

