/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class PutCcrRestoreSessionRequest
extends SingleShardRequest<PutCcrRestoreSessionRequest> {
    private String sessionUUID;
    private ShardId shardId;

    PutCcrRestoreSessionRequest() {
    }

    public PutCcrRestoreSessionRequest(String sessionUUID, ShardId shardId) {
        super(shardId.getIndexName());
        this.sessionUUID = sessionUUID;
        this.shardId = shardId;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.sessionUUID = in.readString();
        this.shardId = ShardId.readShardId((StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sessionUUID);
        this.shardId.writeTo(out);
    }

    String getSessionUUID() {
        return this.sessionUUID;
    }

    ShardId getShardId() {
        return this.shardId;
    }
}

