/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.flexdock.util.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OsInfo {
    private static final OsInfo SINGLETON = new OsInfo();
    private static final String XML_RESOURCE = "org/flexdock/util/os-info.xml";
    private String osArch;
    private List osNameList;
    private List osLibraryList;
    private List prefixOsLibraryList;

    public static OsInfo getInstance() {
        return SINGLETON;
    }

    public OsInfo() {
        this(null);
    }

    public OsInfo(Properties systemProps) {
        if (systemProps == null) {
            systemProps = System.getProperties();
        }
        Document doc = ResourceManager.getDocument(XML_RESOURCE);
        this.osArch = this.getSystemArch(doc, systemProps);
        this.osNameList = Collections.unmodifiableList(this.getOSChain(doc, systemProps));
        ArrayList<String> libList = new ArrayList<String>(this.osNameList.size());
        ArrayList<String> prefixLibList = new ArrayList<String>(this.osNameList.size());
        Iterator it = this.osNameList.iterator();
        while (it.hasNext()) {
            String osName = (String)it.next();
            libList.add(osName + "-" + this.osArch);
        }
        libList.addAll(this.osNameList);
        it = libList.iterator();
        while (it.hasNext()) {
            String prefixed = "-" + it.next();
            prefixLibList.add(prefixed);
        }
        this.osLibraryList = Collections.unmodifiableList(libList);
        this.prefixOsLibraryList = Collections.unmodifiableList(prefixLibList);
    }

    private String getSystemArch(Document doc, Properties systemProps) {
        String archTag = "arch";
        String sysArch = this.format(systemProps.getProperty("os.arch"));
        Element archElem = this.findElementByName(doc, archTag, sysArch);
        while (this.isNested(archElem, archTag)) {
            archElem = (Element)archElem.getParentNode();
        }
        return archElem == null ? sysArch : archElem.getAttribute("name");
    }

    private List getOSChain(Document doc, Properties systemProps) {
        String osTag = "os";
        String osName = this.format(systemProps.getProperty("os.name"));
        ArrayList<String> list = new ArrayList<String>();
        for (Element osElem = this.findElementByName(doc, osTag, osName); osElem != null && osTag.equals(osElem.getTagName()); osElem = (Element)osElem.getParentNode()) {
            list.add(osElem.getAttribute("name"));
        }
        if (list.isEmpty()) {
            list.add(osName);
        }
        return list;
    }

    private Element findElementByName(Document doc, String tagName, String nameAttrib) {
        NodeList list = doc.getElementsByTagName(tagName);
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            if (!nameAttrib.equals(elem.getAttribute("name"))) continue;
            return elem;
        }
        return null;
    }

    private String format(String data) {
        return data.replace(' ', '_').toLowerCase();
    }

    private boolean isNested(Element elem, String tagName) {
        if (elem == null) {
            return false;
        }
        Element parent = (Element)elem.getParentNode();
        return parent == null ? false : tagName.equals(parent.getTagName());
    }

    public String getArch() {
        return this.osArch;
    }

    public List getLibraryKeys() {
        return this.osLibraryList;
    }

    public List getPrefixLibraryKeys() {
        return this.prefixOsLibraryList;
    }

    public List getOsNames() {
        return this.osNameList;
    }

    public String getLibraryKey() {
        return (String)this.getLibraryKeys().get(0);
    }

    public String getPrefixLibraryKey() {
        return (String)this.getPrefixLibraryKeys().get(0);
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        props.setProperty("os.name", System.getProperty("os.name"));
        props.setProperty("os.arch", System.getProperty("os.arch"));
        OsInfo info = new OsInfo(props);
        List libList = info.getLibraryKeys();
        System.out.println("Library Keychain");
        System.out.println("----------------");
        Iterator it = libList.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println();
        System.out.println("Default Library Key: " + info.getLibraryKey());
    }
}

