/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.auth;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.auth.AuthenticationAuthority;
import org.jitsi.jicofo.auth.AuthenticationListener;
import org.jitsi.jicofo.auth.AuthenticationSession;
import org.jitsi.jicofo.auth.ErrorFactory;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jitsi.xmpp.extensions.jitsimeet.LogoutIq;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public abstract class AbstractAuthAuthority
implements AuthenticationAuthority,
ConferenceStore.Listener {
    private static final Logger logger = new LoggerImpl(AbstractAuthAuthority.class.getName());
    private static final long EXPIRE_POLLING_INTERVAL = 10000L;
    private final long authenticationLifetime;
    private final boolean enableAutoLogin;
    private Timer expireTimer;
    protected final Object syncRoot = new Object();
    private final Map<String, AuthenticationSession> authenticationSessions = new ConcurrentHashMap<String, AuthenticationSession>();
    private final List<AuthenticationListener> authenticationListeners = new CopyOnWriteArrayList<AuthenticationListener>();

    public AbstractAuthAuthority(boolean enableAutoLogin2, Duration authenticationLifetime2) {
        this.enableAutoLogin = enableAutoLogin2;
        this.authenticationLifetime = authenticationLifetime2.toMillis();
        if (!enableAutoLogin2) {
            logger.info((Object)"Auto login disabled");
        }
        logger.info((Object)("Authentication lifetime: " + authenticationLifetime2));
    }

    protected AuthenticationSession findSession(Predicate<AuthenticationSession> selector) {
        ArrayList<AuthenticationSession> sessions = new ArrayList<AuthenticationSession>(this.authenticationSessions.values());
        return sessions.stream().filter(selector).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationSession createNewSession(String machineUID, String authIdentity, EntityBareJid roomName) {
        Object object = this.syncRoot;
        synchronized (object) {
            AuthenticationSession session = new AuthenticationSession(machineUID, this.createNonExistingUUID().toString(), authIdentity, roomName);
            this.authenticationSessions.put(session.getSessionId(), session);
            logger.info((Object)("Authentication session created for " + authIdentity + " SID: " + session.getSessionId()));
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID createNonExistingUUID() {
        Object object = this.syncRoot;
        synchronized (object) {
            UUID uuid = UUID.randomUUID();
            while (this.authenticationSessions.containsKey(uuid.toString())) {
                uuid = UUID.randomUUID();
            }
            return uuid;
        }
    }

    protected AuthenticationSession findSessionForIdentity(String machineUID, String authIdentity) {
        if (StringUtils.isBlank((CharSequence)authIdentity) || StringUtils.isBlank((CharSequence)machineUID)) {
            return null;
        }
        return this.findSession(session -> session.getUserIdentity().equals(authIdentity) && session.getMachineUID().equals(machineUID));
    }

    protected AuthenticationSession findSessionForJabberId(Jid jabberId) {
        if (jabberId == null) {
            return null;
        }
        return this.findSession(session -> jabberId.equals((CharSequence)session.getUserJabberId()));
    }

    protected AuthenticationSession getSession(String sessionId) {
        return sessionId != null ? this.authenticationSessions.get(sessionId) : null;
    }

    @Override
    public String getSessionForJid(Jid jabberId) {
        AuthenticationSession session = this.findSessionForJabberId(jabberId);
        return session != null ? session.getSessionId() : null;
    }

    @Override
    public String getUserIdentity(Jid jabberId) {
        AuthenticationSession session = this.findSessionForJabberId(jabberId);
        return session != null ? session.getUserIdentity() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(String sessionId) {
        Object object = this.syncRoot;
        synchronized (object) {
            AuthenticationSession session = this.getSession(sessionId);
            if (session == null) {
                return;
            }
            if (this.authenticationSessions.remove(sessionId) != null) {
                logger.info((Object)("Authentication removed: " + session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conferenceEnded(EntityBareJid roomName) {
        if (this.enableAutoLogin) {
            return;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            Iterator<AuthenticationSession> sessionIterator = this.authenticationSessions.values().iterator();
            while (sessionIterator.hasNext()) {
                AuthenticationSession session = sessionIterator.next();
                if (!roomName.equals((CharSequence)session.getRoomName())) continue;
                logger.info((Object)("Removing session for ended conference, S: " + session));
                sessionIterator.remove();
            }
        }
    }

    @Override
    public void addAuthenticationListener(AuthenticationListener l) {
        if (!this.authenticationListeners.contains(l)) {
            this.authenticationListeners.add(l);
        }
    }

    @Override
    public void removeAuthenticationListener(AuthenticationListener l) {
        this.authenticationListeners.remove(l);
    }

    protected void notifyUserAuthenticated(Jid userJid, String identity, String sessionId) {
        logger.info((Object)("Jid " + userJid + " authenticated as: " + identity));
        for (AuthenticationListener l : this.authenticationListeners) {
            l.jidAuthenticated(userJid, identity, sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQ processAuthentication(ConferenceIq query, ConferenceIq response) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.processAuthLocked(query, response);
        }
    }

    protected abstract IQ processAuthLocked(ConferenceIq var1, ConferenceIq var2);

    protected IQ verifySession(ConferenceIq query) {
        String sessionId = query.getSessionId();
        AuthenticationSession session = this.getSession(sessionId);
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            String queryMUID;
            if (session == null) {
                return ErrorFactory.createSessionInvalidResponse((IQ)query);
            }
            String sessionMUID = session.getMachineUID();
            if (!sessionMUID.equals(queryMUID = query.getMachineUID())) {
                return ErrorFactory.createNotAcceptableError((IQ)query, "machine UID mismatch or empty");
            }
        }
        return null;
    }

    protected void authenticateJidWithSession(AuthenticationSession session, Jid peerJid, ConferenceIq response) {
        session.setUserJabberId(peerJid);
        logger.info((Object)("Authenticated jid: " + peerJid + " with session: " + session));
        this.notifyUserAuthenticated(peerJid, session.getUserIdentity(), session.getSessionId());
        session.touch();
        response.setIdentity(session.getUserIdentity());
        response.setSessionId(session.getSessionId());
    }

    @Override
    @NotNull
    public IQ processLogoutIq(LogoutIq iq) {
        String sessionId = iq.getSessionId();
        if (this.getSession(sessionId) == null) {
            return ErrorFactory.createSessionInvalidResponse((IQ)iq);
        }
        LogoutIq result = new LogoutIq();
        result.setType(IQ.Type.result);
        result.setStanzaId(iq.getStanzaId());
        result.setFrom(iq.getTo());
        result.setTo(iq.getFrom());
        String logoutUrl = this.createLogoutUrl(sessionId);
        result.setLogoutUrl(logoutUrl);
        this.destroySession(sessionId);
        return result;
    }

    protected abstract String createLogoutUrl(String var1);

    @Override
    public void start() {
        this.expireTimer = new Timer("AuthenticationExpireTimer", true);
        this.expireTimer.scheduleAtFixedRate((TimerTask)new ExpireTask(), 10000L, 10000L);
    }

    @Override
    public void shutdown() {
        if (this.expireTimer != null) {
            this.expireTimer.cancel();
            this.expireTimer = null;
        }
    }

    private class ExpireTask
    extends TimerTask {
        private ExpireTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AbstractAuthAuthority.this.syncRoot;
            synchronized (object) {
                Iterator<AuthenticationSession> sessionsIter = AbstractAuthAuthority.this.authenticationSessions.values().iterator();
                while (sessionsIter.hasNext()) {
                    AuthenticationSession session = sessionsIter.next();
                    if (System.currentTimeMillis() - session.getActivityTimestamp() <= AbstractAuthAuthority.this.authenticationLifetime) continue;
                    logger.info((Object)("Expiring session:" + session));
                    sessionsIter.remove();
                }
            }
        }
    }
}

