/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.auth;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.jicofo.auth.AbstractAuthAuthority;
import org.jitsi.jicofo.auth.AuthenticationSession;
import org.jitsi.jicofo.auth.ErrorFactory;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class XMPPDomainAuthAuthority
extends AbstractAuthAuthority {
    private final DomainBareJid domain;

    public XMPPDomainAuthAuthority(boolean enableAutoLogin2, Duration authenticationLifetime2, DomainBareJid domain) {
        super(enableAutoLogin2, authenticationLifetime2);
        this.domain = domain;
    }

    private boolean verifyJid(Jid fullJid) {
        return fullJid.asDomainBareJid().equals((CharSequence)this.domain);
    }

    @Override
    protected IQ processAuthLocked(ConferenceIq query, ConferenceIq response) {
        Jid peerJid = query.getFrom();
        String sessionId = query.getSessionId();
        AuthenticationSession session = this.getSession(sessionId);
        IQ error = this.verifySession(query);
        if (error != null) {
            return error;
        }
        if (session == null && this.verifyJid(peerJid)) {
            BareJid bareJid = peerJid.asBareJid();
            String machineUID = query.getMachineUID();
            if (StringUtils.isBlank((CharSequence)machineUID)) {
                return ErrorFactory.createNotAcceptableError((IQ)query, "Missing mandatory attribute 'machine-uid'");
            }
            session = this.createNewSession(machineUID, bareJid.toString(), query.getRoom());
        }
        if (session != null) {
            this.authenticateJidWithSession(session, peerJid, response);
        }
        return null;
    }

    @Override
    public String createLoginUrl(String machineUID, EntityFullJid peerFullJid, EntityBareJid roomName, boolean popup) {
        return "./" + roomName.getLocalpartOrThrow() + "?login=true";
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    protected String createLogoutUrl(String sessionId) {
        return null;
    }
}

