/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.ReinviteMethod;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.auth.AbstractAuthAuthority;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.bridge.colibri.ColibriSessionManager;
import org.jitsi.jicofo.bridge.colibri.ColibriV2SessionManager;
import org.jitsi.jicofo.conference.ConferenceMetrics;
import org.jitsi.jicofo.conference.ConferenceUtilKt;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.JitsiMeetConfig;
import org.jitsi.jicofo.conference.MuteResult;
import org.jitsi.jicofo.conference.Participant;
import org.jitsi.jicofo.conference.ParticipantInviteRunnable;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.ValidatingConferenceSourceMap;
import org.jitsi.jicofo.conference.source.ValidationFailedException;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriRecorder;
import org.jitsi.jicofo.jibri.JibriSipGateway;
import org.jitsi.jicofo.jigasi.JigasiConfig;
import org.jitsi.jicofo.jigasi.TranscriberManager;
import org.jitsi.jicofo.util.RateLimitedStat;
import org.jitsi.jicofo.version.CurrentVersionImpl;
import org.jitsi.jicofo.visitors.VisitorsConfig;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.XmppVisitorConnectionConfig;
import org.jitsi.jicofo.xmpp.muc.AuthenticationRoleManager;
import org.jitsi.jicofo.xmpp.muc.AutoOwnerRoleManager;
import org.jitsi.jicofo.xmpp.muc.ChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.ChatRoomRoleManager;
import org.jitsi.jicofo.xmpp.muc.DefaultChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeNotAvailablePacketExt;
import org.jitsi.xmpp.extensions.jitsimeet.ComponentVersionsExtension;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceProperties;
import org.jitsi.xmpp.extensions.jitsimeet.EtherpadPacketExt;
import org.jitsi.xmpp.extensions.jitsimeet.MuteIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteVideoIq;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;

public class JitsiMeetConferenceImpl
implements JitsiMeetConference,
XmppProvider.Listener {
    @NotNull
    private final EntityBareJid roomName;
    private final ConferenceListener listener;
    @NotNull
    private final Logger logger;
    @NotNull
    private final JitsiMeetConfig config;
    private final ChatRoomListener chatRoomListener = new ChatRoomListenerImpl();
    private volatile ChatRoom chatRoom;
    private final Map<String, ChatRoom> visitorChatRooms = new ConcurrentHashMap<String, ChatRoom>();
    private final Map<Jid, Participant> participants = new ConcurrentHashMap<Jid, Participant>();
    private final Object participantLock = new Object();
    private final RateLimitedStat visitorCount = new RateLimitedStat(VisitorsConfig.config.getNotificationInterval(), (Function1<? super Integer, Unit>)((Function1)numVisitors -> {
        this.setConferenceProperty("visitor-count", Integer.toString(numVisitors));
        return null;
    }));
    private JibriRecorder jibriRecorder;
    private JibriSipGateway jibriSipGateway;
    private TranscriberManager transcriberManager;
    private ChatRoomRoleManager chatRoomRoleManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Instant creationTime = Instant.now();
    private boolean hasHadAtLeastOneParticipant = false;
    private Future<?> singleParticipantTout;
    private boolean startAudioMuted = false;
    private boolean startVideoMuted = false;
    private final String etherpadName;
    private ColibriSessionManager colibriSessionManager;
    private final ColibriSessionManagerListener colibriSessionManagerListener = new ColibriSessionManagerListener();
    private final ConcurrentHashMap<String, String> conferenceProperties = new ConcurrentHashMap();
    private final boolean includeInStatistics;
    private final BridgeSelectorEventHandler bridgeSelectorEventHandler = new BridgeSelectorEventHandler();
    @NotNull
    private final JicofoServices jicofoServices;
    private final ValidatingConferenceSourceMap conferenceSources = new ValidatingConferenceSourceMap(ConferenceConfig.config.getMaxSsrcsPerUser(), ConferenceConfig.config.getMaxSsrcGroupsPerUser());
    private boolean audioLimitReached = false;
    private boolean videoLimitReached = false;
    private final String jvbVersion;

    public JitsiMeetConferenceImpl(@NotNull EntityBareJid roomName, ConferenceListener listener, @NotNull Map<String, String> properties, Level logLevel, String jvbVersion, boolean includeInStatistics, @NotNull JicofoServices jicofoServices) {
        this.logger = new LoggerImpl(JitsiMeetConferenceImpl.class.getName(), logLevel);
        this.logger.addContext("room", roomName.toString());
        this.config = new JitsiMeetConfig(properties);
        this.roomName = roomName;
        this.listener = listener;
        this.etherpadName = this.createSharedDocumentName();
        this.includeInStatistics = includeInStatistics;
        this.jicofoServices = jicofoServices;
        this.jvbVersion = jvbVersion;
        this.logger.info((Object)"Created new conference.");
    }

    private ColibriSessionManager getColibriSessionManager() {
        if (this.colibriSessionManager == null) {
            String meetingId;
            String string = meetingId = this.chatRoom == null ? null : this.chatRoom.getMeetingId();
            if (meetingId == null) {
                this.logger.warn((Object)"No meetingId set for the MUC. Generating one locally.");
                meetingId = UUID.randomUUID().toString();
            }
            this.colibriSessionManager = new ColibriV2SessionManager(this.jicofoServices.getXmppServices().getServiceConnection().getXmppConnection(), this.jicofoServices.getBridgeSelector(), this.getRoomName().toString(), meetingId, this.config.getRtcStatsEnabled(), this.jvbVersion, this.logger);
            this.colibriSessionManager.addListener((ColibriSessionManager.Listener)this.colibriSessionManagerListener);
        }
        return this.colibriSessionManager;
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            JibriDetector sipJibriDetector;
            JibriDetector jibriDetector;
            XmppProvider clientXmppProvider = this.getClientXmppProvider();
            BridgeSelector bridgeSelector = this.jicofoServices.getBridgeSelector();
            bridgeSelector.addHandler((BridgeSelector.EventHandler)this.bridgeSelectorEventHandler);
            if (clientXmppProvider.getRegistered()) {
                this.joinTheRoom();
            }
            if ((jibriDetector = this.jicofoServices.getJibriDetector()) != null) {
                this.jibriRecorder = new JibriRecorder(this, jibriDetector, this.logger);
            }
            if ((sipJibriDetector = this.jicofoServices.getSipJibriDetector()) != null) {
                this.jibriSipGateway = new JibriSipGateway(this, sipJibriDetector, this.logger);
            }
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception x) {
                this.logger.warn((Object)"An exception was caught while invoking stop()", (Throwable)x);
            }
            throw e;
        }
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.visitorCount.stop();
        if (this.jibriSipGateway != null) {
            try {
                this.jibriSipGateway.shutdown();
            }
            catch (Exception e) {
                this.logger.error((Object)"jibriSipGateway.shutdown error", (Throwable)e);
            }
            this.jibriSipGateway = null;
        }
        if (this.jibriRecorder != null) {
            try {
                this.jibriRecorder.shutdown();
            }
            catch (Exception e) {
                this.logger.error((Object)"jibriRecorder.shutdown error", (Throwable)e);
            }
            this.jibriRecorder = null;
        }
        BridgeSelector bridgeSelector = this.jicofoServices.getBridgeSelector();
        bridgeSelector.removeHandler((BridgeSelector.EventHandler)this.bridgeSelectorEventHandler);
        if (this.colibriSessionManager != null) {
            this.colibriSessionManager.removeListener((ColibriSessionManager.Listener)this.colibriSessionManagerListener);
        }
        try {
            this.expireBridgeSessions();
        }
        catch (Exception e) {
            this.logger.error((Object)"disposeConference error", (Throwable)e);
        }
        try {
            this.leaveTheRoom();
        }
        catch (Exception e) {
            this.logger.error((Object)"leaveTheRoom error", (Throwable)e);
        }
        this.logger.info((Object)"Stopped.");
        if (this.listener != null) {
            this.listener.conferenceEnded(this);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private void joinTheRoom() throws Exception {
        ChatRoom chatRoom;
        this.logger.info((Object)("Joining " + this.roomName));
        this.chatRoom = chatRoom = this.getClientXmppProvider().findOrCreateRoom(this.roomName);
        chatRoom.addListener(this.chatRoomListener);
        AbstractAuthAuthority authenticationAuthority = this.jicofoServices.getAuthenticationAuthority();
        if (authenticationAuthority != null) {
            this.chatRoomRoleManager = new AuthenticationRoleManager(chatRoom, authenticationAuthority);
            chatRoom.addListener((ChatRoomListener)this.chatRoomRoleManager);
        } else if (ConferenceConfig.config.enableAutoOwner()) {
            this.chatRoomRoleManager = new AutoOwnerRoleManager(chatRoom);
            chatRoom.addListener((ChatRoomListener)this.chatRoomRoleManager);
        }
        this.transcriberManager = new TranscriberManager(this.jicofoServices.getXmppServices().getXmppConnectionByName(JigasiConfig.config.xmppConnectionName()), this, chatRoom, this.jicofoServices.getXmppServices().getJigasiDetector(), this.logger);
        chatRoom.join();
        if (chatRoom.getMeetingId() != null) {
            this.logger.addContext("meeting_id", chatRoom.getMeetingId());
        }
        ArrayList<Object> presenceExtensions = new ArrayList<Object>();
        presenceExtensions.add(EtherpadPacketExt.forDocumentName((String)this.etherpadName));
        ComponentVersionsExtension versionsExtension = new ComponentVersionsExtension();
        versionsExtension.addComponentVersion("focus", CurrentVersionImpl.VERSION.toString());
        presenceExtensions.add(versionsExtension);
        this.setConferenceProperty("support-terminate-restart", Boolean.TRUE.toString(), false);
        if (VisitorsConfig.config.getEnabled()) {
            this.setConferenceProperty("visitors-enabled", Boolean.TRUE.toString(), false);
        }
        presenceExtensions.add(this.createConferenceProperties());
        chatRoom.modifyPresence(null, presenceExtensions);
    }

    private void setConferenceProperty(@NotNull String key, @NotNull String value) {
        this.setConferenceProperty(key, value, true);
    }

    private void setConferenceProperty(@NotNull String key, @NotNull String value, boolean updatePresence) {
        String oldValue = this.conferenceProperties.put(key, value);
        if (updatePresence && this.chatRoom != null && !value.equals(oldValue)) {
            this.chatRoom.setPresenceExtension((ExtensionElement)this.createConferenceProperties(), false);
        }
    }

    private ConferenceProperties createConferenceProperties() {
        ConferenceProperties conferenceProperties = new ConferenceProperties();
        this.conferenceProperties.forEach((arg_0, arg_1) -> ((ConferenceProperties)conferenceProperties).put(arg_0, arg_1));
        return conferenceProperties;
    }

    private void onNumAudioSendersChanged(int numAudioSenders) {
        boolean newValue;
        boolean bl = newValue = numAudioSenders >= ConferenceConfig.config.getMaxAudioSenders();
        if (this.audioLimitReached != newValue) {
            this.audioLimitReached = newValue;
            this.setConferenceProperty("audio-limit-reached", String.valueOf(this.audioLimitReached));
        }
    }

    private void onNumVideoSendersChanged(int numVideoSenders) {
        boolean newValue;
        boolean bl = newValue = numVideoSenders >= ConferenceConfig.config.getMaxVideoSenders();
        if (this.videoLimitReached != newValue) {
            this.videoLimitReached = newValue;
            this.setConferenceProperty("video-limit-reached", String.valueOf(this.videoLimitReached));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveTheRoom() {
        if (this.chatRoom == null) {
            this.logger.error((Object)"Chat room already left!");
            return;
        }
        if (this.chatRoomRoleManager != null) {
            this.chatRoom.removeListener((ChatRoomListener)this.chatRoomRoleManager);
            this.chatRoomRoleManager.stop();
        }
        if (this.transcriberManager != null) {
            this.transcriberManager.dispose();
            this.transcriberManager = null;
        }
        this.chatRoom.leave();
        this.chatRoom.removeListener(this.chatRoomListener);
        this.chatRoom = null;
        Map<String, ChatRoom> map = this.visitorChatRooms;
        synchronized (map) {
            this.visitorChatRooms.values().forEach(c -> {
                try {
                    c.removeAllListeners();
                    c.leave();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to leave visitor room", (Throwable)e);
                }
            });
            this.visitorChatRooms.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberJoined(@NotNull ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            if (chatRoomMember.getRole() == MemberRole.VISITOR && !VisitorsConfig.config.getEnabled()) {
                this.logger.warn((Object)("Ignoring a visitor because visitors are not configured:" + chatRoomMember.getName()));
                return;
            }
            this.logger.info((Object)("Member joined:" + chatRoomMember.getName() + " stats-id=" + chatRoomMember.getStatsId() + " region=" + chatRoomMember.getRegion() + " audioMuted=" + chatRoomMember.isAudioMuted() + " videoMuted=" + chatRoomMember.isVideoMuted() + " role=" + chatRoomMember.getRole() + " isJibri=" + chatRoomMember.isJibri() + " isJigasi=" + chatRoomMember.isJigasi()));
            this.hasHadAtLeastOneParticipant = true;
            if (!this.checkMinParticipants()) {
                return;
            }
            this.cancelSingleParticipantTimeout();
            if (this.participants.size() == 0) {
                Iterator iterator = this.chatRoom.getMembers().iterator();
                while (iterator.hasNext()) {
                    ChatRoomMember member;
                    this.inviteChatMember(member, (member = (ChatRoomMember)iterator.next()) == chatRoomMember);
                }
            } else {
                this.inviteChatMember(chatRoomMember, true);
            }
            if (chatRoomMember.getRole() == MemberRole.VISITOR) {
                this.visitorAdded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inviteChatMember(ChatRoomMember chatRoomMember, boolean justJoined) {
        Object object = this.participantLock;
        synchronized (object) {
            if (this.participants.get(chatRoomMember.getOccupantJid()) != null) {
                return;
            }
            Set features = chatRoomMember.getFeatures();
            this.logger.info((Object)("Creating participant " + chatRoomMember.getName() + " with features=" + features));
            Participant participant = new Participant(chatRoomMember, this, this.jicofoServices.getXmppServices().getJingleHandler(), this.logger, features);
            ConferenceMetrics.participants.inc();
            if (!participant.supportsReceivingMultipleVideoStreams() && !participant.getChatMember().isJigasi()) {
                ConferenceMetrics.participantsNoMultiStream.inc();
            }
            if (!participant.hasSourceNameSupport() && !participant.getChatMember().isJigasi()) {
                ConferenceMetrics.participantsNoSourceName.inc();
            }
            this.participants.put((Jid)chatRoomMember.getOccupantJid(), participant);
            this.inviteParticipant(participant, false, justJoined);
        }
    }

    private void inviteParticipant(@NotNull Participant participant, boolean reInvite, boolean justJoined) {
        ParticipantInviteRunnable channelAllocator = new ParticipantInviteRunnable(this, this.getColibriSessionManager(), participant, this.hasToStartAudioMuted(justJoined), this.hasToStartVideoMuted(justJoined), reInvite, this.logger);
        participant.setInviteRunnable(channelAllocator);
        TaskPools.getIoPool().execute(channelAllocator);
    }

    @NotNull
    EndpointSourceSet getSourcesForParticipant(@NotNull Participant participant) {
        EndpointSourceSet s = this.conferenceSources.get(participant.getEndpointId());
        return s != null ? s : EndpointSourceSet.EMPTY;
    }

    private boolean hasToStartAudioMuted(boolean justJoined) {
        if (this.startAudioMuted && justJoined) {
            return true;
        }
        int limit = ConferenceConfig.config.getMaxAudioSenders();
        Integer startAudioMutedInt = this.config.getStartAudioMuted();
        if (startAudioMutedInt != null) {
            limit = Math.min(limit, startAudioMutedInt);
        }
        return this.getParticipantCount() > limit;
    }

    private boolean hasToStartVideoMuted(boolean justJoined) {
        if (this.startVideoMuted && justJoined) {
            return true;
        }
        int limit = ConferenceConfig.config.getMaxVideoSenders();
        Integer startVideoMutedInt = this.config.getStartVideoMuted();
        if (startVideoMutedInt != null) {
            limit = Math.min(limit, startVideoMutedInt);
        }
        return this.getParticipantCount() > limit;
    }

    private boolean checkMinParticipants() {
        int minParticipants = ConferenceConfig.config.getMinParticipants();
        ChatRoom chatRoom = this.getChatRoom();
        return chatRoom != null && chatRoom.getMembersCount() >= minParticipants;
    }

    private void expireBridgeSessions() {
        this.cancelSingleParticipantTimeout();
        if (this.colibriSessionManager != null) {
            this.colibriSessionManager.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberKicked(ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            this.logger.info((Object)("Member kicked: " + chatRoomMember.getName()));
            this.onMemberLeft(chatRoomMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberLeft(ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            this.logger.info((Object)("Member left:" + chatRoomMember.getName()));
            Participant leftParticipant = this.participants.get(chatRoomMember.getOccupantJid());
            if (leftParticipant != null) {
                this.terminateParticipant(leftParticipant, Reason.GONE, null, false, false);
            } else {
                this.logger.warn((Object)("Participant not found for " + chatRoomMember.getName() + ". Terminated already or never started?"));
            }
            if (this.participants.size() == 1) {
                this.rescheduleSingleParticipantTimeout();
            } else if (this.participants.size() == 0) {
                this.expireBridgeSessions();
            }
        }
        if (chatRoomMember.getRole() == MemberRole.VISITOR) {
            this.visitorRemoved();
        }
        if (this.chatRoom == null || this.chatRoom.getMembersCount() == 0) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateParticipant(Participant participant, @NotNull Reason reason, String message, boolean sendSessionTerminate, boolean sendSourceRemove) {
        this.logger.info((Object)String.format("Terminating %s, reason: %s, send session-terminate: %s", participant.getChatMember().getName(), reason, sendSessionTerminate));
        Object object = this.participantLock;
        synchronized (object) {
            participant.terminateJingleSession(reason, message, sendSessionTerminate);
            this.removeParticipantSources(participant, sendSourceRemove);
            Participant removed = this.participants.remove(participant.getChatMember().getOccupantJid());
            this.logger.info((Object)("Removed participant " + participant.getChatMember().getName() + " removed=" + (removed != null)));
        }
        this.getColibriSessionManager().removeParticipant(participant.getEndpointId());
    }

    public void componentsChanged(Set<XmppProvider.Component> components) {
    }

    public void registrationChanged(boolean registered) {
        if (registered) {
            this.logger.info((Object)"XMPP reconnected");
            if (this.chatRoom == null) {
                try {
                    this.joinTheRoom();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to join the room: " + this.roomName), (Throwable)e);
                    this.stop();
                }
            }
        } else {
            this.logger.info((Object)"XMPP disconnected.");
            this.stop();
        }
    }

    @Override
    @Nullable
    public Participant getParticipant(@NotNull Jid occupantJid) {
        return this.participants.get(occupantJid);
    }

    @Override
    public MemberRole getRoleForMucJid(Jid mucJid) {
        if (this.chatRoom == null) {
            return null;
        }
        for (ChatRoomMember member : this.chatRoom.getMembers()) {
            if (!member.getOccupantJid().equals((CharSequence)mucJid)) continue;
            return member.getRole();
        }
        return null;
    }

    public void iceFailed(@NotNull Participant participant, String bridgeSessionId) {
        String existingBridgeSessionId = this.getColibriSessionManager().getBridgeSessionId(participant.getEndpointId());
        if (Objects.equals(bridgeSessionId, existingBridgeSessionId)) {
            this.logger.info((Object)String.format("Received ICE failed notification from %s, bridge-session ID: %s", participant.getEndpointId(), bridgeSessionId));
            this.reInviteParticipant(participant);
        } else {
            this.logger.info((Object)String.format("Ignored ICE failed notification for invalid session, participant: %s, bridge session ID: %s", participant.getEndpointId(), bridgeSessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateSession(@NotNull Participant participant, String bridgeSessionId, boolean reinvite) throws InvalidBridgeSessionIdException {
        String existingBridgeSessionId = this.getColibriSessionManager().getBridgeSessionId(participant.getEndpointId());
        if (!Objects.equals(bridgeSessionId, existingBridgeSessionId)) {
            throw new InvalidBridgeSessionIdException(bridgeSessionId + " is not a currently active session");
        }
        Object object = this.participantLock;
        synchronized (object) {
            this.terminateParticipant(participant, Reason.SUCCESS, reinvite ? "reinvite requested" : null, false, true);
            if (reinvite) {
                this.participants.put((Jid)participant.getChatMember().getOccupantJid(), participant);
                this.inviteParticipant(participant, false, false);
            }
        }
    }

    private void propagateNewSources(Participant sourceOwner, EndpointSourceSet sources) {
        if (sources.isEmpty()) {
            this.logger.debug((Object)"No new sources to propagate.");
            return;
        }
        ConferenceSourceMap conferenceSourceMap = new ConferenceSourceMap(sourceOwner.getEndpointId(), sources);
        this.participants.values().stream().filter(otherParticipant -> otherParticipant != sourceOwner).forEach(participant -> participant.addRemoteSources(conferenceSourceMap));
    }

    public void updateTransport(@NotNull Participant participant, @NotNull IceUdpTransportPacketExtension transport) {
        this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), transport, null);
    }

    public void addSource(@NotNull Participant participant, @NotNull EndpointSourceSet sourcesAdvertised) throws SenderCountExceededException, ValidationFailedException {
        boolean rejectedVideoSource;
        boolean rejectedAudioSource = sourcesAdvertised.getHasAudio() && this.chatRoom.getAudioSendersCount() >= ConferenceConfig.config.getMaxAudioSenders();
        boolean bl = rejectedVideoSource = sourcesAdvertised.getHasVideo() && this.chatRoom.getVideoSendersCount() >= ConferenceConfig.config.getMaxVideoSenders();
        if (rejectedAudioSource || rejectedVideoSource) {
            throw new SenderCountExceededException("Sender count exceeded for: " + (rejectedAudioSource ? "audio " : "") + (rejectedVideoSource ? "video" : ""));
        }
        EndpointSourceSet sourcesAccepted = this.conferenceSources.tryToAdd(participant.getEndpointId(), sourcesAdvertised);
        this.logger.debug(() -> "Accepted sources from " + participant.getEndpointId() + ": " + sourcesAccepted);
        if (sourcesAccepted.isEmpty()) {
            this.logger.warn((Object)("Stop processing source-add, no new sources added: " + participant.getEndpointId()));
            return;
        }
        this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), null, participant.getSources());
        this.propagateNewSources(participant, sourcesAccepted);
    }

    public void removeSources(@NotNull Participant participant, @NotNull EndpointSourceSet sourcesRequestedToBeRemoved) throws ValidationFailedException {
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesAcceptedToBeRemoved = this.conferenceSources.tryToRemove(participantId, sourcesRequestedToBeRemoved);
        this.logger.debug(() -> "Received source removal request from " + participantId + ": " + sourcesRequestedToBeRemoved);
        this.logger.debug(() -> "Accepted sources to remove from " + participantId + ": " + sourcesAcceptedToBeRemoved);
        if (sourcesAcceptedToBeRemoved.isEmpty()) {
            this.logger.warn((Object)("No sources or groups to be removed from " + participantId + ". The requested sources to remove: " + sourcesRequestedToBeRemoved));
            return;
        }
        this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), null, participant.getSources(), false);
        this.sendSourceRemove(new ConferenceSourceMap(participantId, sourcesAcceptedToBeRemoved), participant);
    }

    void acceptSession(@NotNull Participant participant, @NotNull EndpointSourceSet sourcesAdvertised, IceUdpTransportPacketExtension transport) throws ValidationFailedException {
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesAccepted = EndpointSourceSet.EMPTY;
        if (!sourcesAdvertised.isEmpty()) {
            sourcesAccepted = this.conferenceSources.tryToAdd(participantId, sourcesAdvertised);
        }
        this.getColibriSessionManager().updateParticipant(participantId, transport, this.getSourcesForParticipant(participant));
        if (!sourcesAccepted.isEmpty()) {
            this.logger.info((Object)("Accepted initial sources from " + participantId + ": " + sourcesAccepted));
            this.propagateNewSources(participant, sourcesAccepted);
        } else {
            this.logger.debug((Object)"Session accepted with no sources.");
        }
        participant.sendQueuedRemoteSources();
    }

    private void removeParticipantSources(@NotNull Participant participant, boolean sendSourceRemove) {
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesRemoved = this.conferenceSources.remove(participantId);
        if (sourcesRemoved != null && !sourcesRemoved.isEmpty()) {
            this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), null, participant.getSources(), true);
            if (sendSourceRemove) {
                this.sendSourceRemove(new ConferenceSourceMap(participantId, sourcesRemoved), participant);
            }
        }
    }

    private void sendSourceRemove(ConferenceSourceMap sources, Participant except) {
        if (sources.isEmpty()) {
            this.logger.debug((Object)"No sources to remove.");
            return;
        }
        this.participants.values().stream().filter(participant -> participant != except).forEach(participant -> participant.removeRemoteSources(sources));
    }

    @NotNull
    public ConferenceSourceMap getSources() {
        return this.conferenceSources.unmodifiable();
    }

    @Override
    @NotNull
    public EntityBareJid getRoomName() {
        return this.roomName;
    }

    @NotNull
    public XmppProvider getClientXmppProvider() {
        return this.jicofoServices.getXmppServices().getClientConnection();
    }

    public boolean hasMember(Jid jid) {
        ChatRoom chatRoom = this.chatRoom;
        return this.hasMember(jid, chatRoom) || this.visitorChatRooms.values().stream().anyMatch(c -> this.hasMember(jid, (ChatRoom)c));
    }

    private boolean hasMember(Jid jid, ChatRoom chatRoom) {
        return chatRoom != null && jid instanceof EntityFullJid && chatRoom.getChatMember((EntityFullJid)jid) != null;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public boolean hasHadAtLeastOneParticipant() {
        return this.hasHadAtLeastOneParticipant;
    }

    @Override
    @NotNull
    public MuteResult handleMuteRequest(@NotNull Jid muterJid, @NotNull Jid toBeMutedJid, boolean doMute, @NotNull MediaType mediaType) {
        Participant muter = this.getParticipant(muterJid);
        if (muter == null) {
            this.logger.warn((Object)("Muter participant not found, jid=" + muterJid));
            return MuteResult.ERROR;
        }
        if (!muterJid.equals((CharSequence)toBeMutedJid) && !MemberRoleKt.hasModeratorRights((MemberRole)muter.getChatMember().getRole())) {
            this.logger.warn((Object)("Mute not allowed for non-moderator " + muterJid));
            return MuteResult.NOT_ALLOWED;
        }
        Participant participant = this.getParticipant(toBeMutedJid);
        if (participant == null) {
            this.logger.warn((Object)("Participant to be muted not found, jid=" + toBeMutedJid));
            return MuteResult.ERROR;
        }
        if (!doMute) {
            if (!muterJid.equals((CharSequence)toBeMutedJid)) {
                this.logger.warn((Object)("Unmute not allowed, muterJid=" + muterJid + ", toBeMutedJid=" + toBeMutedJid));
                return MuteResult.NOT_ALLOWED;
            }
            if (!participant.hasModeratorRights() && !this.chatRoom.isMemberAllowedToUnmute(toBeMutedJid, mediaType)) {
                this.logger.warn((Object)("Unmute not allowed due to av moderation for jid=" + toBeMutedJid));
                return MuteResult.NOT_ALLOWED;
            }
        }
        if (participant.shouldSuppressForceMute()) {
            this.logger.warn((Object)("Force mute suppressed, returning NOT_ALLOWED:" + participant));
            return MuteResult.NOT_ALLOWED;
        }
        this.logger.info((Object)("Will " + (doMute ? "mute" : "unmute") + " " + toBeMutedJid + " on behalf of " + muterJid + " for " + mediaType));
        this.getColibriSessionManager().mute(participant.getEndpointId(), doMute, mediaType);
        return MuteResult.SUCCESS;
    }

    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject o = new OrderedJsonObject();
        o.put((Object)"name", (Object)this.roomName.toString());
        o.put((Object)"config", (Object)this.config.getDebugState());
        ChatRoom chatRoom = this.chatRoom;
        o.put((Object)"chat_room", (Object)(chatRoom == null ? "null" : chatRoom.getDebugState()));
        OrderedJsonObject participantsJson = new OrderedJsonObject();
        for (Participant participant : this.participants.values()) {
            participantsJson.put((Object)participant.getEndpointId(), (Object)participant.getDebugState());
        }
        o.put((Object)"participants", (Object)participantsJson);
        ChatRoomRoleManager chatRoomRoleManager = this.chatRoomRoleManager;
        o.put((Object)"chat_room_role_manager", (Object)(chatRoomRoleManager == null ? "null" : chatRoomRoleManager.getDebugState()));
        o.put((Object)"started", (Object)this.started.get());
        o.put((Object)"creation_time", (Object)this.creationTime.toString());
        o.put((Object)"has_had_at_least_one_participant", (Object)this.hasHadAtLeastOneParticipant);
        o.put((Object)"start_audio_muted", (Object)this.startAudioMuted);
        o.put((Object)"start_video_muted", (Object)this.startVideoMuted);
        if (this.colibriSessionManager != null) {
            o.put((Object)"colibri_session_manager", (Object)this.colibriSessionManager.getDebugState());
        }
        OrderedJsonObject conferencePropertiesJson = new OrderedJsonObject();
        conferencePropertiesJson.putAll(this.conferenceProperties);
        o.put((Object)"conference_properties", (Object)conferencePropertiesJson);
        o.put((Object)"include_in_statistics", (Object)this.includeInStatistics);
        o.put((Object)"conference_sources", (Object)this.conferenceSources.toJson());
        o.put((Object)"audio_limit_reached", (Object)this.audioLimitReached);
        o.put((Object)"video_limit_reached", (Object)this.videoLimitReached);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void muteAllParticipants(MediaType mediaType) {
        HashSet<Participant> participantsToMute = new HashSet<Participant>();
        Iterator iterator = this.participantLock;
        synchronized (iterator) {
            for (Participant participant : this.participants.values()) {
                if (participant.shouldSuppressForceMute()) {
                    this.logger.info((Object)("Will not mute a trusted participant without unmute support (jibri, jigasi): " + participant));
                    continue;
                }
                participantsToMute.add(participant);
            }
        }
        this.getColibriSessionManager().mute(participantsToMute.stream().map(Participant::getEndpointId).collect(Collectors.toSet()), true, mediaType);
        for (Participant participant : participantsToMute) {
            MuteIq muteStatusUpdate;
            MuteIq muteIq = null;
            if (mediaType == MediaType.AUDIO) {
                muteStatusUpdate = new MuteIq();
                muteStatusUpdate.setType(IQ.Type.set);
                muteStatusUpdate.setTo((Jid)participant.getMucJid());
                muteStatusUpdate.setMute(Boolean.valueOf(true));
                muteIq = muteStatusUpdate;
            } else if (mediaType == MediaType.VIDEO) {
                muteStatusUpdate = new MuteVideoIq();
                muteStatusUpdate.setType(IQ.Type.set);
                muteStatusUpdate.setTo((Jid)participant.getMucJid());
                muteStatusUpdate.setMute(Boolean.valueOf(true));
                muteIq = muteStatusUpdate;
            }
            if (muteIq == null) continue;
            UtilKt.tryToSendStanza((XMPPConnection)this.getClientXmppProvider().getXmppConnection(), muteIq);
        }
    }

    @Override
    public int getParticipantCount() {
        return this.participants.size();
    }

    @Nullable
    public String redirectVisitor(boolean visitorRequested) throws Exception {
        if (!VisitorsConfig.config.getEnabled()) {
            return null;
        }
        if (!visitorRequested && this.getParticipantCount() < VisitorsConfig.config.getMaxParticipants()) {
            return null;
        }
        return this.selectVisitorNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectVisitorNode() throws Exception {
        ChatRoom chatRoomToJoin;
        String node;
        Map<String, ChatRoom> map = this.visitorChatRooms;
        synchronized (map) {
            node = ConferenceUtilKt.selectVisitorNode(this.visitorChatRooms, this.jicofoServices.getXmppServices().getVisitorConnections());
            if (node == null) {
                this.logger.warn((Object)"Visitor node required, but none available.");
                return null;
            }
            if (this.visitorChatRooms.containsKey(node)) {
                return node;
            }
            XmppProvider xmppProvider = this.jicofoServices.getXmppServices().getXmppVisitorConnectionByName(node);
            if (xmppProvider == null) {
                this.logger.error((Object)("No XMPP provider for node " + node));
                return null;
            }
            XmppVisitorConnectionConfig config = (XmppVisitorConnectionConfig)XmppConfig.getVisitors().get(node);
            if (config == null) {
                this.logger.error((Object)("No XMPP config for node " + node));
                return null;
            }
            EntityBareJid visitorMucJid = JidCreate.entityBareFrom((Localpart)this.roomName.getLocalpart(), (DomainBareJid)config.getConferenceService());
            chatRoomToJoin = xmppProvider.findOrCreateRoom(visitorMucJid);
            chatRoomToJoin.addListener((ChatRoomListener)new VisitorChatRoomListenerImpl(chatRoomToJoin));
            this.visitorChatRooms.put(node, chatRoomToJoin);
        }
        chatRoomToJoin.join();
        ArrayList<Object> presenceExtensions = new ArrayList<Object>();
        ComponentVersionsExtension versionsExtension = new ComponentVersionsExtension();
        versionsExtension.addComponentVersion("focus", CurrentVersionImpl.VERSION.toString());
        presenceExtensions.add(versionsExtension);
        presenceExtensions.add(this.createConferenceProperties());
        chatRoomToJoin.modifyPresence(null, presenceExtensions);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBridgeUp(Jid bridgeJid) {
        if (!this.started.get()) {
            return;
        }
        if (this.chatRoom != null && this.checkMinParticipants() && this.getColibriSessionManager().getBridgeCount() == 0) {
            this.logger.info((Object)("New bridge available, will try to restart: " + bridgeJid));
            Object object = this.participantLock;
            synchronized (object) {
                this.reInviteParticipants(this.participants.values());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInviteParticipantsById(@NotNull List<String> participantIdsToReinvite) {
        if (!participantIdsToReinvite.isEmpty()) {
            ConferenceMetrics.participantsMoved.addAndGet((long)participantIdsToReinvite.size());
            Object object = this.participantLock;
            synchronized (object) {
                ArrayList<Participant> participantsToReinvite = new ArrayList<Participant>();
                for (Participant participant : this.participants.values()) {
                    if (!participantIdsToReinvite.contains(participant.getEndpointId())) continue;
                    participantsToReinvite.add(participant);
                }
                if (participantsToReinvite.size() != participantIdsToReinvite.size()) {
                    this.logger.error((Object)"Can not re-invite all participants, no Participant object for some of them.");
                }
                this.reInviteParticipants(participantsToReinvite);
            }
        }
    }

    public void onInviteFailed(ParticipantInviteRunnable channelAllocator) {
        this.terminateParticipant(channelAllocator.getParticipant(), Reason.GENERAL_ERROR, "jingle session failed", true, true);
    }

    @Override
    @Nullable
    public ChatRoom getChatRoom() {
        return this.chatRoom;
    }

    private String createSharedDocumentName() {
        if (ConferenceConfig.config.useRandomSharedDocumentName()) {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        return this.roomName.getLocalpart().toString();
    }

    private void reInviteParticipant(Participant participant) {
        ArrayList<Participant> l = new ArrayList<Participant>(1);
        l.add(participant);
        this.reInviteParticipants(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInviteParticipants(Collection<Participant> participants) {
        Object object = this.participantLock;
        synchronized (object) {
            for (Participant participant : participants) {
                boolean restartJingle;
                participant.setInviteRunnable(null);
                boolean bl = restartJingle = ConferenceConfig.config.getReinviteMethod() == ReinviteMethod.RestartJingle;
                if (restartJingle) {
                    this.removeParticipantSources(participant, true);
                    participant.terminateJingleSession(Reason.SUCCESS, "moving", true);
                }
                this.inviteParticipant(participant, !restartJingle, false);
            }
        }
    }

    private void rescheduleSingleParticipantTimeout() {
        this.cancelSingleParticipantTimeout();
        long timeout = ConferenceConfig.config.getSingleParticipantTimeout().toMillis();
        this.singleParticipantTout = TaskPools.getScheduledPool().schedule(new SinglePersonTimeout(), timeout, TimeUnit.MILLISECONDS);
        this.logger.info((Object)"Scheduled single person timeout.");
    }

    private void visitorAdded() {
        this.visitorCount.adjustValue(1);
    }

    private void visitorRemoved() {
        this.visitorCount.adjustValue(-1);
    }

    private void cancelSingleParticipantTimeout() {
        if (this.singleParticipantTout != null) {
            this.logger.debug((Object)"Cancelling single person timeout.");
            this.singleParticipantTout.cancel(false);
            this.singleParticipantTout = null;
        }
    }

    @Override
    @NotNull
    public Set<String> getBridgeRegions() {
        return this.colibriSessionManager != null ? this.colibriSessionManager.getBridgeRegions() : Collections.emptySet();
    }

    @Override
    public boolean includeInStatistics() {
        return this.includeInStatistics;
    }

    @Override
    @NotNull
    public IqProcessingResult handleJibriRequest(@NotNull IqRequest<JibriIq> request) {
        IqProcessingResult.NotProcessed result = new IqProcessingResult.NotProcessed();
        if (this.started.get()) {
            if (this.jibriRecorder != null) {
                result = this.jibriRecorder.handleJibriRequest(request);
            }
            if (result instanceof IqProcessingResult.NotProcessed && this.jibriSipGateway != null) {
                result = this.jibriSipGateway.handleJibriRequest(request);
            }
        }
        return result;
    }

    @Override
    public boolean acceptJigasiRequest(@NotNull Jid from) {
        return MemberRoleKt.hasModeratorRights((MemberRole)this.getRoleForMucJid(from));
    }

    @Override
    public JibriRecorder getJibriRecorder() {
        return this.jibriRecorder;
    }

    @Override
    public JibriSipGateway getJibriSipGateway() {
        return this.jibriSipGateway;
    }

    void desktopSourceIsMutedChanged(Participant participant, boolean desktopSourceIsMuted) {
        if (!ConferenceConfig.config.getMultiStreamBackwardCompat()) {
            return;
        }
        this.participants.values().stream().filter(p -> p != participant).filter(p -> !p.supportsReceivingMultipleVideoStreams()).forEach(p -> p.remoteDesktopSourceIsMutedChanged(participant.getEndpointId(), desktopSourceIsMuted));
    }

    public String toString() {
        return String.format("JitsiMeetConferenceImpl[name=%s]", this.getRoomName());
    }

    private class ChatRoomListenerImpl
    implements ChatRoomListener {
        private ChatRoomListenerImpl() {
        }

        public void roomDestroyed(String reason) {
            JitsiMeetConferenceImpl.this.logger.info((Object)("Room destroyed with reason=" + reason));
            JitsiMeetConferenceImpl.this.stop();
        }

        public void startMutedChanged(boolean startAudioMuted, boolean startVideoMuted) {
            JitsiMeetConferenceImpl.this.startAudioMuted = startAudioMuted;
            JitsiMeetConferenceImpl.this.startVideoMuted = startVideoMuted;
        }

        public void memberJoined(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberJoined(member);
        }

        public void memberKicked(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberKicked(member);
        }

        public void memberLeft(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberLeft(member);
        }

        public void localRoleChanged(@NotNull MemberRole newRole, @Nullable MemberRole oldRole) {
            if (newRole != MemberRole.OWNER) {
                JitsiMeetConferenceImpl.this.logger.warn((Object)("Stopping, because the local role changed to " + newRole + " (owner privileges are required)."));
                JitsiMeetConferenceImpl.this.stop();
            }
        }

        public void memberPresenceChanged(@NotNull ChatRoomMember member) {
            Participant participant = JitsiMeetConferenceImpl.this.getParticipant((Jid)member.getOccupantJid());
            if (participant != null) {
                participant.presenceChanged();
            }
        }

        public void numAudioSendersChanged(int numAudioSenders) {
            JitsiMeetConferenceImpl.this.onNumAudioSendersChanged(numAudioSenders);
        }

        public void numVideoSendersChanged(int numVideoSenders) {
            JitsiMeetConferenceImpl.this.onNumVideoSendersChanged(numVideoSenders);
        }
    }

    private class ColibriSessionManagerListener
    implements ColibriSessionManager.Listener {
        private ColibriSessionManagerListener() {
        }

        public void bridgeCountChanged(int bridgeCount) {
            JitsiMeetConferenceImpl.this.setConferenceProperty("bridge-count", Integer.toString(bridgeCount));
        }

        public void bridgeSelectionFailed() {
            ChatRoom chatRoom = JitsiMeetConferenceImpl.this.getChatRoom();
            if (chatRoom != null && !chatRoom.containsPresenceExtension("bridgeNotAvailable", "http://jitsi.org/protocol/focus")) {
                chatRoom.setPresenceExtension((ExtensionElement)new BridgeNotAvailablePacketExt(), false);
            }
        }

        public void bridgeSelectionSucceeded() {
            ChatRoom chatRoom = JitsiMeetConferenceImpl.this.chatRoom;
            if (chatRoom != null) {
                chatRoom.setPresenceExtension((ExtensionElement)new BridgeNotAvailablePacketExt(), true);
            }
        }

        public void bridgeRemoved(@NotNull Bridge bridge, @NotNull List<String> participantIds) {
            JitsiMeetConferenceImpl.this.logger.info((Object)("Bridge " + bridge + " was removed from the conference. Re-inviting its participants: " + participantIds));
            JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIds);
        }
    }

    private class BridgeSelectorEventHandler
    implements BridgeSelector.EventHandler {
        private BridgeSelectorEventHandler() {
        }

        public void bridgeIsShuttingDown(@NotNull Bridge bridge) {
            List participantIdsToReinvite;
            List list = participantIdsToReinvite = JitsiMeetConferenceImpl.this.colibriSessionManager != null ? JitsiMeetConferenceImpl.this.colibriSessionManager.removeBridge(bridge) : Collections.emptyList();
            if (!participantIdsToReinvite.isEmpty()) {
                JitsiMeetConferenceImpl.this.logger.info((Object)("Bridge " + bridge.getJid() + " is shutting down, re-inviting " + participantIdsToReinvite));
                JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIdsToReinvite);
            }
        }

        public void bridgeRemoved(@NotNull Bridge bridge) {
            List participantIdsToReinvite;
            List list = participantIdsToReinvite = JitsiMeetConferenceImpl.this.colibriSessionManager != null ? JitsiMeetConferenceImpl.this.colibriSessionManager.removeBridge(bridge) : Collections.emptyList();
            if (!participantIdsToReinvite.isEmpty()) {
                JitsiMeetConferenceImpl.this.logger.info((Object)("Removed " + bridge.getJid() + ", re-inviting " + participantIdsToReinvite));
                JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIdsToReinvite);
            }
        }

        public void bridgeAdded(Bridge bridge) {
            JitsiMeetConferenceImpl.this.onBridgeUp(bridge.getJid());
        }
    }

    public static interface ConferenceListener {
        public void conferenceEnded(JitsiMeetConferenceImpl var1);
    }

    static class InvalidBridgeSessionIdException
    extends Exception {
        InvalidBridgeSessionIdException(String message) {
            super(message);
        }
    }

    public static class SenderCountExceededException
    extends Exception {
        SenderCountExceededException(String message) {
            super(message);
        }
    }

    private class VisitorChatRoomListenerImpl
    extends DefaultChatRoomListener {
        private final Logger logger;
        private final ChatRoom chatRoom;

        private VisitorChatRoomListenerImpl(ChatRoom chatRoom) {
            this.logger = JitsiMeetConferenceImpl.this.logger.createChildLogger(VisitorChatRoomListenerImpl.class.getSimpleName());
            this.chatRoom = chatRoom;
            this.logger.addContext("visitor_muc", chatRoom.getRoomJid().toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void roomDestroyed(String reason) {
            this.logger.info((Object)("Visitor room destroyed with reason=" + reason));
            ChatRoom chatRoomToLeave = null;
            Map<String, ChatRoom> map = JitsiMeetConferenceImpl.this.visitorChatRooms;
            synchronized (map) {
                Map.Entry entry = JitsiMeetConferenceImpl.this.visitorChatRooms.entrySet().stream().filter(e -> e.getValue() == this.chatRoom).findFirst().orElse(null);
                if (entry != null) {
                    chatRoomToLeave = (ChatRoom)entry.getValue();
                    JitsiMeetConferenceImpl.this.visitorChatRooms.remove(entry.getKey());
                }
            }
            if (chatRoomToLeave != null) {
                ChatRoom finalChatRoom = chatRoomToLeave;
                TaskPools.getIoPool().submit(() -> {
                    try {
                        this.logger.info((Object)"Removing visitor chat room");
                        finalChatRoom.leave();
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Error while leaving chat room.", (Throwable)e);
                    }
                });
            }
        }

        public void memberJoined(@NotNull ChatRoomMember member) {
            if (member.getRole() != MemberRole.VISITOR) {
                this.logger.debug((Object)("Ignoring non-visitor member of visitor room: " + member));
                return;
            }
            JitsiMeetConferenceImpl.this.onMemberJoined(member);
        }

        public void memberKicked(@NotNull ChatRoomMember member) {
            if (member.getRole() != MemberRole.VISITOR) {
                this.logger.debug((Object)("Member kicked for non-visitor member of visitor room: " + member));
            }
            JitsiMeetConferenceImpl.this.onMemberKicked(member);
        }

        public void memberLeft(@NotNull ChatRoomMember member) {
            if (member.getRole() != MemberRole.VISITOR) {
                this.logger.debug((Object)("Member left for non-visitor member of visitor room: " + member));
            }
            JitsiMeetConferenceImpl.this.onMemberLeft(member);
        }
    }

    private class SinglePersonTimeout
    implements Runnable {
        private SinglePersonTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = JitsiMeetConferenceImpl.this.participantLock;
            synchronized (object) {
                if (JitsiMeetConferenceImpl.this.participants.size() == 1) {
                    Participant p = JitsiMeetConferenceImpl.this.participants.values().stream().findFirst().orElse(null);
                    JitsiMeetConferenceImpl.this.logger.info((Object)("Timing out single participant: " + p.getChatMember().getName()));
                    JitsiMeetConferenceImpl.this.terminateParticipant(p, Reason.EXPIRED, "Idle session timeout", true, false);
                    JitsiMeetConferenceImpl.this.expireBridgeSessions();
                } else {
                    JitsiMeetConferenceImpl.this.logger.error((Object)"Should never execute if more than 1 participant?");
                }
                JitsiMeetConferenceImpl.this.singleParticipantTout = null;
            }
        }
    }
}

