/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.AbstractDebugger;
import org.jivesoftware.smack.packet.TopLevelStreamElement;

public class PacketDebugger
extends AbstractDebugger {
    private static final Logger logger = new LoggerImpl(PacketDebugger.class.getName());
    @NonNull
    private final String id;

    public static boolean isEnabled() {
        return logger.isDebugEnabled();
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public PacketDebugger(XMPPConnection connection, @NonNull String id) {
        super(connection);
        this.id = id;
        AbstractDebugger.printInterpreted = true;
    }

    public void onIncomingStreamElement(TopLevelStreamElement streamElement) {
        logger.debug(() -> "RCV PKT (" + this.id + "): " + streamElement.toXML());
    }

    public void onOutgoingStreamElement(TopLevelStreamElement streamElement) {
        logger.debug(() -> "SENT PKT (" + this.id + "): " + streamElement.toXML());
    }

    protected void log(String logMessage) {
        if (logger.isDebugEnabled() && !logMessage.startsWith("RECV (") && !logMessage.startsWith("SENT (")) {
            logger.debug((Object)logMessage);
        }
    }

    protected void log(String logMessage, Throwable throwable) {
        logger.warn((Object)("Smack: " + logMessage), throwable);
    }
}

