/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.streams.processor.TaskId;

public class ClientState {
    private final Set<TaskId> activeTasks;
    private final Set<TaskId> standbyTasks;
    private final Set<TaskId> assignedTasks;
    private final Set<TaskId> prevActiveTasks;
    private final Set<TaskId> prevAssignedTasks;
    private int capacity;

    public ClientState() {
        this(0);
    }

    ClientState(int capacity) {
        this(new HashSet<TaskId>(), new HashSet<TaskId>(), new HashSet<TaskId>(), new HashSet<TaskId>(), new HashSet<TaskId>(), capacity);
    }

    private ClientState(Set<TaskId> activeTasks, Set<TaskId> standbyTasks, Set<TaskId> assignedTasks, Set<TaskId> prevActiveTasks, Set<TaskId> prevAssignedTasks, int capacity) {
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
        this.assignedTasks = assignedTasks;
        this.prevActiveTasks = prevActiveTasks;
        this.prevAssignedTasks = prevAssignedTasks;
        this.capacity = capacity;
    }

    public ClientState copy() {
        return new ClientState(new HashSet<TaskId>(this.activeTasks), new HashSet<TaskId>(this.standbyTasks), new HashSet<TaskId>(this.assignedTasks), new HashSet<TaskId>(this.prevActiveTasks), new HashSet<TaskId>(this.prevAssignedTasks), this.capacity);
    }

    public void assign(TaskId taskId, boolean active) {
        if (active) {
            this.activeTasks.add(taskId);
        } else {
            this.standbyTasks.add(taskId);
        }
        this.assignedTasks.add(taskId);
    }

    public Set<TaskId> activeTasks() {
        return this.activeTasks;
    }

    public Set<TaskId> standbyTasks() {
        return this.standbyTasks;
    }

    public int assignedTaskCount() {
        return this.assignedTasks.size();
    }

    public void incrementCapacity() {
        ++this.capacity;
    }

    public int activeTaskCount() {
        return this.activeTasks.size();
    }

    public void addPreviousActiveTasks(Set<TaskId> prevTasks) {
        this.prevActiveTasks.addAll(prevTasks);
        this.prevAssignedTasks.addAll(prevTasks);
    }

    public void addPreviousStandbyTasks(Set<TaskId> standbyTasks) {
        this.prevAssignedTasks.addAll(standbyTasks);
    }

    public String toString() {
        return "[activeTasks: (" + this.activeTasks + ") standbyTasks: (" + this.standbyTasks + ") assignedTasks: (" + this.assignedTasks + ") prevActiveTasks: (" + this.prevActiveTasks + ") prevAssignedTasks: (" + this.prevAssignedTasks + ") capacity: " + this.capacity + "]";
    }

    boolean reachedCapacity() {
        return this.assignedTasks.size() >= this.capacity;
    }

    boolean hasMoreAvailableCapacityThan(ClientState other) {
        if (this.capacity <= 0) {
            throw new IllegalStateException("Capacity of this ClientState must be greater than 0.");
        }
        if (other.capacity <= 0) {
            throw new IllegalStateException("Capacity of other ClientState must be greater than 0");
        }
        double otherLoad = (double)other.assignedTaskCount() / (double)other.capacity;
        double thisLoad = (double)this.assignedTaskCount() / (double)this.capacity;
        if (thisLoad < otherLoad) {
            return true;
        }
        if (thisLoad > otherLoad) {
            return false;
        }
        return this.capacity > other.capacity;
    }

    Set<TaskId> previousStandbyTasks() {
        HashSet<TaskId> standby = new HashSet<TaskId>(this.prevAssignedTasks);
        standby.removeAll(this.prevActiveTasks);
        return standby;
    }

    Set<TaskId> previousActiveTasks() {
        return this.prevActiveTasks;
    }

    boolean hasAssignedTask(TaskId taskId) {
        return this.assignedTasks.contains(taskId);
    }

    Set<TaskId> assignedTasks() {
        return this.assignedTasks;
    }

    Set<TaskId> previousAssignedTasks() {
        return this.prevAssignedTasks;
    }

    int capacity() {
        return this.capacity;
    }

    boolean hasUnfulfilledQuota(int tasksPerThread) {
        return this.activeTasks.size() < this.capacity * tasksPerThread;
    }
}

