/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class RocksDbWindowBytesStoreSupplier
implements WindowBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;
    private final int segments;
    private final long windowSize;
    private final boolean retainDuplicates;

    public RocksDbWindowBytesStoreSupplier(String name, long retentionPeriod, int segments, long windowSize, boolean retainDuplicates) {
        if (segments < 2) {
            throw new IllegalArgumentException("numSegments must be >= 2");
        }
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.segments = segments;
        this.windowSize = windowSize;
        this.retainDuplicates = retainDuplicates;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public WindowStore<Bytes, byte[]> get() {
        RocksDBSegmentedBytesStore segmentedBytesStore = new RocksDBSegmentedBytesStore(this.name, this.retentionPeriod, this.segments, new WindowKeySchema());
        return RocksDBWindowStore.bytesStore(segmentedBytesStore, this.retainDuplicates, this.windowSize);
    }

    @Override
    public String metricsScope() {
        return "rocksdb-window";
    }

    @Override
    public int segments() {
        return this.segments;
    }

    @Override
    public long windowSize() {
        return this.windowSize;
    }

    @Override
    public boolean retainDuplicates() {
        return this.retainDuplicates;
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

