/*****************************************************************************
 * info.h: DVD Video Manager library, information getting functions.
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: info.h,v 1.5 2003/01/29 20:55:26 sam Exp $
 *
 * Authors: Stphane Borel <stef@via.ecp.fr>
 *
 * Adapted from Ogle - A video player
 * Copyright (C) 2000, 2001 Hkan Hjort
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#ifndef _DVDPLAY_INFO_H
#define _DVDPLAY_INFO_H  1

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * Exported prototypes
 *****************************************************************************/

/* Title info */
extern int           dvdplay_title_nr    ( dvdplay_ptr );
extern int           dvdplay_title_cur   ( dvdplay_ptr );
extern int           dvdplay_title_first ( dvdplay_ptr );
extern int           dvdplay_title_end   ( dvdplay_ptr );

extern int           dvdplay_title_time  ( dvdplay_ptr );
/* Chapter info */
extern int           dvdplay_chapter_nr  ( dvdplay_ptr, int );
extern int           dvdplay_chapter_cur ( dvdplay_ptr );
/* Angle info */
extern int           dvdplay_angle_info  ( dvdplay_ptr, int*, int* );

/* Audio properties */
extern int           dvdplay_audio_info  ( dvdplay_ptr, int*, int* );
extern int           dvdplay_audio_id    ( dvdplay_ptr, int );
extern audio_attr_t* dvdplay_audio_attr  ( dvdplay_ptr, int );

/* Sub-picture properties */
extern int           dvdplay_subp_info   ( dvdplay_ptr, int*, int* );
extern int           dvdplay_subp_id     ( dvdplay_ptr, int );
//extern int           dvdplay_get_subp_active_stream( dvdplay_ptr );
extern subp_attr_t*  dvdplay_subp_attr   ( dvdplay_ptr, int );
extern uint32_t*     dvdplay_subp_palette( dvdplay_ptr );

/* Video attributes */
extern video_attr_t* dvdplay_video_attr  ( dvdplay_ptr );
//extern void          dvdplay_get_video_res ( dvdplay_ptr, int*, int* );


#ifdef __cplusplus
}
#endif

#endif /* <dvdplay/info.h> */
