/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.plain;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.analysis.TextAnalyzer;
import org.opensolaris.opengrok.analysis.plain.XMLXref;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.Annotation;

public class XMLAnalyzer
extends TextAnalyzer {
    private final XMLXref xref = new XMLXref(AnalyzerGuru.dummyR);

    protected XMLAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        doc.add((IndexableField)new TextField("full", this.getReader(src.getStream())));
        if (xrefOut != null) {
            try (Reader in = this.getReader(src.getStream());){
                this.writeXref(in, xrefOut);
            }
        }
    }

    private void writeXref(Reader in, Writer out) throws IOException {
        this.xref.reInit(in);
        this.xref.project = this.project;
        this.xref.write(out);
    }

    static void writeXref(Reader in, Writer out, Definitions defs, Annotation annotation, Project project) throws IOException {
        XMLXref xref = new XMLXref(in);
        xref.annotation = annotation;
        xref.project = project;
        xref.setDefs(defs);
        xref.write(out);
    }
}

