# pylint:disable=line-too-long
import logging
from collections import OrderedDict

from ...sim_type import (SimTypeFunction,
    SimTypeShort,
    SimTypeInt,
    SimTypeLong,
    SimTypeLongLong,
    SimTypeDouble,
    SimTypeFloat,
    SimTypePointer,
    SimTypeChar,
    SimStruct,
    SimTypeArray,
    SimTypeBottom,
    SimUnion,
    SimTypeBool,
    SimTypeRef,
)
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.type_collection_names = ["win32"]
lib.set_default_cc("X86", SimCCStdcall)
lib.set_default_cc("AMD64", SimCCMicrosoftAMD64)
lib.set_library_names("odbc32.dll")
prototypes = \
    {
        #
        'SQLBindCol': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "TargetType", "TargetValue", "BufferLength", "StrLen_or_Ind"]),
        #
        'SQLBindParam': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ParameterNumber", "ValueType", "ParameterType", "LengthPrecision", "ParameterScale", "ParameterValue", "StrLen_or_Ind"]),
        #
        'SQLColAttribute': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "FieldIdentifier", "CharacterAttribute", "BufferLength", "StringLength", "NumericAttribute"]),
        #
        'SQLDescribeCol': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "ColumnName", "BufferLength", "NameLength", "DataType", "ColumnSize", "DecimalDigits", "Nullable"]),
        #
        'SQLFetchScroll': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeLongLong(signed=True, label="Int64")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "FetchOrientation", "FetchOffset"]),
        #
        'SQLGetData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "TargetType", "TargetValue", "BufferLength", "StrLen_or_IndPtr"]),
        #
        'SQLGetDescRec': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["DescriptorHandle", "RecNumber", "Name", "BufferLength", "StringLengthPtr", "TypePtr", "SubTypePtr", "LengthPtr", "PrecisionPtr", "ScalePtr", "NullablePtr"]),
        #
        'SQLPutData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=True, label="Int64")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Data", "StrLen_or_Ind"]),
        #
        'SQLRowCount': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "RowCount"]),
        #
        'SQLSetConnectOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "Option", "Value"]),
        #
        'SQLSetDescRec': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeLongLong(signed=True, label="Int64"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["DescriptorHandle", "RecNumber", "Type", "SubType", "Length", "Precision", "Scale", "Data", "StringLength", "Indicator"]),
        #
        'SQLSetParam': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ParameterNumber", "ValueType", "ParameterType", "LengthPrecision", "ParameterScale", "ParameterValue", "StrLen_or_Ind"]),
        #
        'SQLSetStmtOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Option", "Value"]),
        #
        'SQLColAttributes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "fDescType", "rgbDesc", "cbDescMax", "pcbDesc", "pfDesc"]),
        #
        'SQLDescribeParam': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "ipar", "pfSqlType", "pcbParamDef", "pibScale", "pfNullable"]),
        #
        'SQLExtendedFetch': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fFetchType", "irow", "pcrow", "rgfRowStatus"]),
        #
        'SQLParamOptions': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "crow", "pirow"]),
        #
        'SQLSetPos': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "irow", "fOption", "fLock"]),
        #
        'SQLBindParameter': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "ipar", "fParamType", "fCType", "fSqlType", "cbColDef", "ibScale", "rgbValue", "cbValueMax", "pcbValue"]),
        #
        'SQLSetScrollOptions': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeLongLong(signed=True, label="Int64"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fConcurrency", "crowKeyset", "crowRowset"]),
        #
        'SQLColAttributeW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "iCol", "iField", "pCharAttr", "cbDescMax", "pcbCharAttr", "pNumAttr"]),
        #
        'SQLColAttributesW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "fDescType", "rgbDesc", "cbDescMax", "pcbDesc", "pfDesc"]),
        #
        'SQLDescribeColW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "szColName", "cchColNameMax", "pcchColName", "pfSqlType", "pcbColDef", "pibScale", "pfNullable"]),
        #
        'SQLGetDescRecW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdesc", "iRecord", "szName", "cchNameMax", "pcchName", "pfType", "pfSubType", "pLength", "pPrecision", "pScale", "pNullable"]),
        #
        'SQLSetConnectOptionW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fOption", "vParam"]),
        #
        'SQLColAttributeA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "iCol", "iField", "pCharAttr", "cbCharAttrMax", "pcbCharAttr", "pNumAttr"]),
        #
        'SQLColAttributesA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "fDescType", "rgbDesc", "cbDescMax", "pcbDesc", "pfDesc"]),
        #
        'SQLDescribeColA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "szColName", "cbColNameMax", "pcbColName", "pfSqlType", "pcbColDef", "pibScale", "pfNullable"]),
        #
        'SQLGetDescRecA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdesc", "iRecord", "szName", "cbNameMax", "pcbName", "pfType", "pfSubType", "pLength", "pPrecision", "pScale", "pNullable"]),
        #
        'SQLSetConnectOptionA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fOption", "vParam"]),
        #
        'SQLAllocConnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle", "ConnectionHandle"]),
        #
        'SQLAllocEnv': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle"]),
        #
        'SQLAllocHandle': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["HandleType", "InputHandle", "OutputHandle"]),
        #
        'SQLAllocStmt': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "StatementHandle"]),
        #
        'SQLBindCol': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "TargetType", "TargetValue", "BufferLength", "StrLen_or_Ind"]),
        #
        'SQLBindParam': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ParameterNumber", "ValueType", "ParameterType", "LengthPrecision", "ParameterScale", "ParameterValue", "StrLen_or_Ind"]),
        #
        'SQLCancel': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle"]),
        #
        'SQLCancelHandle': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["HandleType", "InputHandle"]),
        #
        'SQLCloseCursor': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle"]),
        #
        'SQLColAttribute': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "FieldIdentifier", "CharacterAttribute", "BufferLength", "StringLength", "NumericAttribute"]),
        #
        'SQLColumns': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "CatalogName", "NameLength1", "SchemaName", "NameLength2", "TableName", "NameLength3", "ColumnName", "NameLength4"]),
        #
        'SQLCompleteAsync': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["HandleType", "Handle", "AsyncRetCodePtr"]),
        #
        'SQLConnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "ServerName", "NameLength1", "UserName", "NameLength2", "Authentication", "NameLength3"]),
        #
        'SQLCopyDesc': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["SourceDescHandle", "TargetDescHandle"]),
        #
        'SQLDataSources': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle", "Direction", "ServerName", "BufferLength1", "NameLength1Ptr", "Description", "BufferLength2", "NameLength2Ptr"]),
        #
        'SQLDescribeCol': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "ColumnName", "BufferLength", "NameLength", "DataType", "ColumnSize", "DecimalDigits", "Nullable"]),
        #
        'SQLDisconnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle"]),
        #
        'SQLEndTran': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["HandleType", "Handle", "CompletionType"]),
        #
        'SQLError': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle", "ConnectionHandle", "StatementHandle", "Sqlstate", "NativeError", "MessageText", "BufferLength", "TextLength"]),
        #
        'SQLExecDirect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "StatementText", "TextLength"]),
        #
        'SQLExecute': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle"]),
        #
        'SQLFetch': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle"]),
        #
        'SQLFetchScroll': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "FetchOrientation", "FetchOffset"]),
        #
        'SQLFreeConnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle"]),
        #
        'SQLFreeEnv': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle"]),
        #
        'SQLFreeHandle': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["HandleType", "Handle"]),
        #
        'SQLFreeStmt': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Option"]),
        #
        'SQLGetConnectAttr': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "Attribute", "Value", "BufferLength", "StringLengthPtr"]),
        #
        'SQLGetConnectOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "Option", "Value"]),
        #
        'SQLGetCursorName': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "CursorName", "BufferLength", "NameLengthPtr"]),
        #
        'SQLGetData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnNumber", "TargetType", "TargetValue", "BufferLength", "StrLen_or_IndPtr"]),
        #
        'SQLGetDescField': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["DescriptorHandle", "RecNumber", "FieldIdentifier", "Value", "BufferLength", "StringLength"]),
        #
        'SQLGetDescRec': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["DescriptorHandle", "RecNumber", "Name", "BufferLength", "StringLengthPtr", "TypePtr", "SubTypePtr", "LengthPtr", "PrecisionPtr", "ScalePtr", "NullablePtr"]),
        #
        'SQLGetDiagField': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["HandleType", "Handle", "RecNumber", "DiagIdentifier", "DiagInfo", "BufferLength", "StringLength"]),
        #
        'SQLGetDiagRec': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["HandleType", "Handle", "RecNumber", "Sqlstate", "NativeError", "MessageText", "BufferLength", "TextLength"]),
        #
        'SQLGetEnvAttr': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle", "Attribute", "Value", "BufferLength", "StringLength"]),
        #
        'SQLGetFunctions': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "FunctionId", "Supported"]),
        #
        'SQLGetInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "InfoType", "InfoValue", "BufferLength", "StringLengthPtr"]),
        #
        'SQLGetStmtAttr': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Attribute", "Value", "BufferLength", "StringLength"]),
        #
        'SQLGetStmtOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Option", "Value"]),
        #
        'SQLGetTypeInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "DataType"]),
        #
        'SQLNumResultCols': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ColumnCount"]),
        #
        'SQLParamData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Value"]),
        #
        'SQLPrepare': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "StatementText", "TextLength"]),
        #
        'SQLPutData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Data", "StrLen_or_Ind"]),
        #
        'SQLRowCount': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "RowCount"]),
        #
        'SQLSetConnectAttr': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "Attribute", "Value", "StringLength"]),
        #
        'SQLSetConnectOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32")], SimTypeShort(signed=True, label="Int16"), arg_names=["ConnectionHandle", "Option", "Value"]),
        #
        'SQLSetCursorName': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "CursorName", "NameLength"]),
        #
        'SQLSetDescField': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["DescriptorHandle", "RecNumber", "FieldIdentifier", "Value", "BufferLength"]),
        #
        'SQLSetDescRec': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeInt(signed=True, label="Int32"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["DescriptorHandle", "RecNumber", "Type", "SubType", "Length", "Precision", "Scale", "Data", "StringLength", "Indicator"]),
        #
        'SQLSetEnvAttr': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle", "Attribute", "Value", "StringLength"]),
        #
        'SQLSetParam': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "ParameterNumber", "ValueType", "ParameterType", "LengthPrecision", "ParameterScale", "ParameterValue", "StrLen_or_Ind"]),
        #
        'SQLSetStmtAttr': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Attribute", "Value", "StringLength"]),
        #
        'SQLSetStmtOption': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Option", "Value"]),
        #
        'SQLSpecialColumns': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "IdentifierType", "CatalogName", "NameLength1", "SchemaName", "NameLength2", "TableName", "NameLength3", "Scope", "Nullable"]),
        #
        'SQLStatistics': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "CatalogName", "NameLength1", "SchemaName", "NameLength2", "TableName", "NameLength3", "Unique", "Reserved"]),
        #
        'SQLTables': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "CatalogName", "NameLength1", "SchemaName", "NameLength2", "TableName", "NameLength3", "TableType", "NameLength4"]),
        #
        'SQLTransact': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["EnvironmentHandle", "ConnectionHandle", "CompletionType"]),
        #
        'SQLDriverConnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "hwnd", "szConnStrIn", "cchConnStrIn", "szConnStrOut", "cchConnStrOutMax", "pcchConnStrOut", "fDriverCompletion"]),
        #
        'SQLBrowseConnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szConnStrIn", "cchConnStrIn", "szConnStrOut", "cchConnStrOutMax", "pcchConnStrOut"]),
        #
        'SQLBulkOperations': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "Operation"]),
        #
        'SQLColAttributes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "fDescType", "rgbDesc", "cbDescMax", "pcbDesc", "pfDesc"]),
        #
        'SQLColumnPrivileges': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName", "szColumnName", "cchColumnName"]),
        #
        'SQLDescribeParam': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "ipar", "pfSqlType", "pcbParamDef", "pibScale", "pfNullable"]),
        #
        'SQLExtendedFetch': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fFetchType", "irow", "pcrow", "rgfRowStatus"]),
        #
        'SQLForeignKeys': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szPkCatalogName", "cchPkCatalogName", "szPkSchemaName", "cchPkSchemaName", "szPkTableName", "cchPkTableName", "szFkCatalogName", "cchFkCatalogName", "szFkSchemaName", "cchFkSchemaName", "szFkTableName", "cchFkTableName"]),
        #
        'SQLMoreResults': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt"]),
        #
        'SQLNativeSql': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szSqlStrIn", "cchSqlStrIn", "szSqlStr", "cchSqlStrMax", "pcbSqlStr"]),
        #
        'SQLNumParams': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "pcpar"]),
        #
        'SQLParamOptions': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "crow", "pirow"]),
        #
        'SQLPrimaryKeys': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName"]),
        #
        'SQLProcedureColumns': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szProcName", "cchProcName", "szColumnName", "cchColumnName"]),
        #
        'SQLProcedures': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szProcName", "cchProcName"]),
        #
        'SQLSetPos': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "irow", "fOption", "fLock"]),
        #
        'SQLTablePrivileges': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName"]),
        #
        'SQLDrivers': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["henv", "fDirection", "szDriverDesc", "cchDriverDescMax", "pcchDriverDesc", "szDriverAttributes", "cchDrvrAttrMax", "pcchDrvrAttr"]),
        #
        'SQLBindParameter': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "ipar", "fParamType", "fCType", "fSqlType", "cbColDef", "ibScale", "rgbValue", "cbValueMax", "pcbValue"]),
        #
        'SQLAllocHandleStd': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["fHandleType", "hInput", "phOutput"]),
        #
        'SQLSetScrollOptions': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=True, label="Int32"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fConcurrency", "crowKeyset", "crowRowset"]),
        #
        'ODBCSetTryWaitValue': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwValue"]),
        #
        'ODBCGetTryWaitValue': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        #
        'SQLColAttributeW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "iCol", "iField", "pCharAttr", "cbDescMax", "pcbCharAttr", "pNumAttr"]),
        #
        'SQLColAttributesW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "fDescType", "rgbDesc", "cbDescMax", "pcbDesc", "pfDesc"]),
        #
        'SQLConnectW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szDSN", "cchDSN", "szUID", "cchUID", "szAuthStr", "cchAuthStr"]),
        #
        'SQLDescribeColW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "szColName", "cchColNameMax", "pcchColName", "pfSqlType", "pcbColDef", "pibScale", "pfNullable"]),
        #
        'SQLErrorW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["henv", "hdbc", "hstmt", "wszSqlState", "pfNativeError", "wszErrorMsg", "cchErrorMsgMax", "pcchErrorMsg"]),
        #
        'SQLExecDirectW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szSqlStr", "TextLength"]),
        #
        'SQLGetConnectAttrW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fAttribute", "rgbValue", "cbValueMax", "pcbValue"]),
        #
        'SQLGetCursorNameW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCursor", "cchCursorMax", "pcchCursor"]),
        #
        'SQLSetDescFieldW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["DescriptorHandle", "RecNumber", "FieldIdentifier", "Value", "BufferLength"]),
        #
        'SQLGetDescFieldW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdesc", "iRecord", "iField", "rgbValue", "cbBufferLength", "StringLength"]),
        #
        'SQLGetDescRecW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdesc", "iRecord", "szName", "cchNameMax", "pcchName", "pfType", "pfSubType", "pLength", "pPrecision", "pScale", "pNullable"]),
        #
        'SQLGetDiagFieldW': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["fHandleType", "handle", "iRecord", "fDiagField", "rgbDiagInfo", "cbBufferLength", "pcbStringLength"]),
        #
        'SQLGetDiagRecW': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["fHandleType", "handle", "iRecord", "szSqlState", "pfNativeError", "szErrorMsg", "cchErrorMsgMax", "pcchErrorMsg"]),
        #
        'SQLPrepareW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szSqlStr", "cchSqlStr"]),
        #
        'SQLSetConnectAttrW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fAttribute", "rgbValue", "cbValue"]),
        #
        'SQLSetCursorNameW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCursor", "cchCursor"]),
        #
        'SQLColumnsW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName", "szColumnName", "cchColumnName"]),
        #
        'SQLGetConnectOptionW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fOption", "pvParam"]),
        #
        'SQLGetInfoW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fInfoType", "rgbInfoValue", "cbInfoValueMax", "pcbInfoValue"]),
        #
        'SQLGetTypeInfoW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "DataType"]),
        #
        'SQLSetConnectOptionW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fOption", "vParam"]),
        #
        'SQLSpecialColumnsW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fColType", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName", "fScope", "fNullable"]),
        #
        'SQLStatisticsW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName", "fUnique", "fAccuracy"]),
        #
        'SQLTablesW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName", "szTableType", "cchTableType"]),
        #
        'SQLDataSourcesW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["henv", "fDirection", "szDSN", "cchDSNMax", "pcchDSN", "wszDescription", "cchDescriptionMax", "pcchDescription"]),
        #
        'SQLDriverConnectW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "hwnd", "szConnStrIn", "cchConnStrIn", "szConnStrOut", "cchConnStrOutMax", "pcchConnStrOut", "fDriverCompletion"]),
        #
        'SQLBrowseConnectW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szConnStrIn", "cchConnStrIn", "szConnStrOut", "cchConnStrOutMax", "pcchConnStrOut"]),
        #
        'SQLColumnPrivilegesW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName", "szColumnName", "cchColumnName"]),
        #
        'SQLGetStmtAttrW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fAttribute", "rgbValue", "cbValueMax", "pcbValue"]),
        #
        'SQLSetStmtAttrW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fAttribute", "rgbValue", "cbValueMax"]),
        #
        'SQLForeignKeysW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szPkCatalogName", "cchPkCatalogName", "szPkSchemaName", "cchPkSchemaName", "szPkTableName", "cchPkTableName", "szFkCatalogName", "cchFkCatalogName", "szFkSchemaName", "cchFkSchemaName", "szFkTableName", "cchFkTableName"]),
        #
        'SQLNativeSqlW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szSqlStrIn", "cchSqlStrIn", "szSqlStr", "cchSqlStrMax", "pcchSqlStr"]),
        #
        'SQLPrimaryKeysW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName"]),
        #
        'SQLProcedureColumnsW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szProcName", "cchProcName", "szColumnName", "cchColumnName"]),
        #
        'SQLProceduresW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szProcName", "cchProcName"]),
        #
        'SQLTablePrivilegesW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cchCatalogName", "szSchemaName", "cchSchemaName", "szTableName", "cchTableName"]),
        #
        'SQLDriversW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["henv", "fDirection", "szDriverDesc", "cchDriverDescMax", "pcchDriverDesc", "szDriverAttributes", "cchDrvrAttrMax", "pcchDrvrAttr"]),
        #
        'SQLColAttributeA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "iCol", "iField", "pCharAttr", "cbCharAttrMax", "pcbCharAttr", "pNumAttr"]),
        #
        'SQLColAttributesA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "fDescType", "rgbDesc", "cbDescMax", "pcbDesc", "pfDesc"]),
        #
        'SQLConnectA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szDSN", "cbDSN", "szUID", "cbUID", "szAuthStr", "cbAuthStr"]),
        #
        'SQLDescribeColA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "icol", "szColName", "cbColNameMax", "pcbColName", "pfSqlType", "pcbColDef", "pibScale", "pfNullable"]),
        #
        'SQLErrorA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["henv", "hdbc", "hstmt", "szSqlState", "pfNativeError", "szErrorMsg", "cbErrorMsgMax", "pcbErrorMsg"]),
        #
        'SQLExecDirectA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szSqlStr", "cbSqlStr"]),
        #
        'SQLGetConnectAttrA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fAttribute", "rgbValue", "cbValueMax", "pcbValue"]),
        #
        'SQLGetCursorNameA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCursor", "cbCursorMax", "pcbCursor"]),
        #
        'SQLGetDescFieldA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdesc", "iRecord", "iField", "rgbValue", "cbBufferLength", "StringLength"]),
        #
        'SQLGetDescRecA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdesc", "iRecord", "szName", "cbNameMax", "pcbName", "pfType", "pfSubType", "pLength", "pPrecision", "pScale", "pNullable"]),
        #
        'SQLGetDiagFieldA': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["fHandleType", "handle", "iRecord", "fDiagField", "rgbDiagInfo", "cbDiagInfoMax", "pcbDiagInfo"]),
        #
        'SQLGetDiagRecA': SimTypeFunction([SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["fHandleType", "handle", "iRecord", "szSqlState", "pfNativeError", "szErrorMsg", "cbErrorMsgMax", "pcbErrorMsg"]),
        #
        'SQLGetStmtAttrA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fAttribute", "rgbValue", "cbValueMax", "pcbValue"]),
        #
        'SQLGetTypeInfoA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["StatementHandle", "DataType"]),
        #
        'SQLPrepareA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szSqlStr", "cbSqlStr"]),
        #
        'SQLSetConnectAttrA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fAttribute", "rgbValue", "cbValue"]),
        #
        'SQLSetCursorNameA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCursor", "cbCursor"]),
        #
        'SQLColumnsA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szTableName", "cbTableName", "szColumnName", "cbColumnName"]),
        #
        'SQLGetConnectOptionA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fOption", "pvParam"]),
        #
        'SQLGetInfoA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fInfoType", "rgbInfoValue", "cbInfoValueMax", "pcbInfoValue"]),
        #
        'SQLSetConnectOptionA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "fOption", "vParam"]),
        #
        'SQLSpecialColumnsA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "fColType", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szTableName", "cbTableName", "fScope", "fNullable"]),
        #
        'SQLStatisticsA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szTableName", "cbTableName", "fUnique", "fAccuracy"]),
        #
        'SQLTablesA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szTableName", "cbTableName", "szTableType", "cbTableType"]),
        #
        'SQLDataSourcesA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["henv", "fDirection", "szDSN", "cbDSNMax", "pcbDSN", "szDescription", "cbDescriptionMax", "pcbDescription"]),
        #
        'SQLDriverConnectA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "hwnd", "szConnStrIn", "cbConnStrIn", "szConnStrOut", "cbConnStrOutMax", "pcbConnStrOut", "fDriverCompletion"]),
        #
        'SQLBrowseConnectA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szConnStrIn", "cbConnStrIn", "szConnStrOut", "cbConnStrOutMax", "pcbConnStrOut"]),
        #
        'SQLColumnPrivilegesA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szTableName", "cbTableName", "szColumnName", "cbColumnName"]),
        #
        'SQLForeignKeysA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szPkCatalogName", "cbPkCatalogName", "szPkSchemaName", "cbPkSchemaName", "szPkTableName", "cbPkTableName", "szFkCatalogName", "cbFkCatalogName", "szFkSchemaName", "cbFkSchemaName", "szFkTableName", "cbFkTableName"]),
        #
        'SQLNativeSqlA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["hdbc", "szSqlStrIn", "cbSqlStrIn", "szSqlStr", "cbSqlStrMax", "pcbSqlStr"]),
        #
        'SQLPrimaryKeysA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szTableName", "cbTableName"]),
        #
        'SQLProcedureColumnsA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szProcName", "cbProcName", "szColumnName", "cbColumnName"]),
        #
        'SQLProceduresA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szProcName", "cbProcName"]),
        #
        'SQLTablePrivilegesA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16")], SimTypeShort(signed=True, label="Int16"), arg_names=["hstmt", "szCatalogName", "cbCatalogName", "szSchemaName", "cbSchemaName", "szTableName", "cbTableName"]),
        #
        'SQLDriversA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeShort(signed=True, label="Int16"), SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)], SimTypeShort(signed=True, label="Int16"), arg_names=["henv", "fDirection", "szDriverDesc", "cbDriverDescMax", "pcbDriverDesc", "szDriverAttributes", "cbDrvrAttrMax", "pcbDrvrAttr"]),
    }

lib.set_prototypes(prototypes)
