"""member_mailinglist_relationship

Revision ID: d151c0b8d6f7
Revises: 58858f75303c
Create Date: 2019-12-24 17:57:40.178065

"""

import sqlalchemy as sa

from alembic import op
from mailman.database.helpers import exists_in_db, is_sqlite


# revision identifiers, used by Alembic.
revision = 'd151c0b8d6f7'
down_revision = '83339e4039da'


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    for table, col, col_type, nullable in (
            ('member', 'bounce_score', sa.Integer(), True),
            ('member', 'last_bounce_received', sa.DateTime(), True),
            ('member', 'last_warning_sent', sa.DateTime(), True),
            ('member', 'total_warnings_sent', sa.Integer(), True)):
        if not exists_in_db(op.get_bind(), table, col):
            op.add_column(table, sa.Column(col, col_type, nullable=nullable))  # pragma: nocover # noqa: E501
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if not is_sqlite(op.get_bind()):
        op.drop_column('member', 'total_warnings_sent')      # pragma: nocover
        op.drop_column('member', 'last_warning_sent')        # pragma: nocover
        op.drop_column('member', 'last_bounce_received')     # pragma: nocover
        op.drop_column('member', 'bounce_score')             # pragma: nocover
    # ### end Alembic commands ###
