require 'webunit/converter'

module WebUnit
  module UI
    module CUI
      class TestRunner

        def initialize(quiet_mode=true)
          case USING_FRAMEWORK
          when 'Test::Unit'
            require 'test/unit/ui/console/testrunner'
            @runner = Test::Unit::UI::Console::TestRunner
          when 'RubyUnit'
            require 'runit/cui/testrunner'
            @runner = RUNIT::CUI::TestRunner.new
          end
          quiet_mode(quiet_mode)
        end

        def quiet_mode(boolean)
          case USING_FRAMEWORK
          when 'RubyUnit'
            @runner.class.quiet_mode = boolean
          end
        end

        def all_suite
          case USING_FRAMEWORK
          when 'Test::Unit'
            suite_name = $0.sub(/\.rb$/, '')
            suite = TestSuite.new(suite_name)
            test_classes = []
            ObjectSpace.each_object(Class) do |klass|
              test_classes << klass if TestCase > klass
            end
            test_classes.each {|klass| suite << klass.suite}
            suite
          when 'RubyUnit'
            TestCase.all_suite
          end
        end

        def run(suite=all_suite)
          @runner.run(suite)
        end

      end
    end
  end
end
