/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;
import net.sourceforge.napkinlaf.NapkinKnownTheme;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import net.sourceforge.napkinlaf.NapkinThemeColor;
import net.sourceforge.napkinlaf.fonts.PatchedFontUIResource;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.sketchers.DraftSketcher;
import net.sourceforge.napkinlaf.sketch.sketchers.JotSketcher;
import net.sourceforge.napkinlaf.util.AlphaColorUIResource;
import net.sourceforge.napkinlaf.util.NapkinBackground;

public class NapkinTheme {
    private final String name;
    private final String description;
    private final Map<NapkinThemeColor, Color> colors = new EnumMap<NapkinThemeColor, Color>(NapkinThemeColor.class);
    private final Font textFont;
    private final Font boldTextFont;
    private final Font fixedFont;
    private final AbstractSketcher sketcher;
    private final NapkinBackground paper;
    private final NapkinBackground erasure;
    private Map<NapkinKnownTheme, NapkinTheme> variants = new EnumMap<NapkinKnownTheme, NapkinTheme>(NapkinKnownTheme.class);

    public NapkinTheme(String name, String description, Color penColor, Color checkColor, Color radioColor, Color highlightColor, Color rolloverColor, Color selectionColor, Font textFont, Font boldTextFont, Font fixedFont, AbstractSketcher sketcher, NapkinBackground paper, NapkinBackground erasure, NapkinBackground popupPaper, Color popupRolloverColor) {
        this(name, description, penColor, checkColor, radioColor, highlightColor, rolloverColor, selectionColor, textFont, boldTextFont, fixedFont, sketcher, paper, erasure, new NapkinTheme(name + "Popup", description + " (popup)", penColor, checkColor, radioColor, highlightColor, popupRolloverColor, selectionColor, textFont, boldTextFont, fixedFont, sketcher, popupPaper, erasure, null));
    }

    public NapkinTheme(String name, String description, Color penColor, Color checkColor, Color radioColor, Color highlightColor, Color rolloverColor, Color selectionColor, Font textFont, Font boldTextFont, Font fixedFont, AbstractSketcher sketcher, NapkinBackground paper, NapkinBackground erasure, NapkinTheme popupTheme) {
        this.name = name;
        this.description = description;
        this.colors.put(NapkinThemeColor.PEN_COLOR, NapkinTheme.toColorResource(penColor));
        this.colors.put(NapkinThemeColor.CHECK_COLOR, NapkinTheme.toColorResource(checkColor));
        this.colors.put(NapkinThemeColor.RADIO_COLOR, NapkinTheme.toColorResource(radioColor));
        this.colors.put(NapkinThemeColor.HIGHLIGHT_COLOR, NapkinTheme.toColorResource(highlightColor));
        this.colors.put(NapkinThemeColor.SELECTION_COLOR, NapkinTheme.toColorResource(selectionColor));
        this.colors.put(NapkinThemeColor.BACKGROUND_COLOR, NapkinTheme.toColorResource(paper.getMeanColor()));
        this.colors.put(NapkinThemeColor.ROLLOVER_COLOR, NapkinTheme.toColorResource(rolloverColor));
        this.textFont = NapkinTheme.toFontResource(textFont);
        this.boldTextFont = NapkinTheme.toFontResource(boldTextFont);
        this.fixedFont = NapkinTheme.toFontResource(fixedFont);
        this.sketcher = sketcher;
        this.paper = paper;
        this.erasure = erasure;
        this.variants.put(NapkinKnownTheme.BASIC_THEME, this);
        this.variants.put(NapkinKnownTheme.POPUP_THEME, popupTheme);
        if (popupTheme != null) {
            popupTheme.variants = this.variants;
        }
    }

    private static Color toColorResource(Color color) {
        return color instanceof UIResource ? color : new AlphaColorUIResource(color);
    }

    private static Font toFontResource(Font font) {
        return font instanceof UIResource ? font : PatchedFontUIResource.wrapIfPossible(font);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Color getPenColor() {
        return this.colors.get((Object)NapkinThemeColor.PEN_COLOR);
    }

    public Color getCheckColor() {
        return this.colors.get((Object)NapkinThemeColor.CHECK_COLOR);
    }

    public Color getRadioColor() {
        return this.colors.get((Object)NapkinThemeColor.RADIO_COLOR);
    }

    public Color getHighlightColor() {
        return this.colors.get((Object)NapkinThemeColor.HIGHLIGHT_COLOR);
    }

    public Color getRolloverColor() {
        return this.colors.get((Object)NapkinThemeColor.ROLLOVER_COLOR);
    }

    public Color getSelectionColor() {
        return this.colors.get((Object)NapkinThemeColor.SELECTION_COLOR);
    }

    public Color getBackgroundColor() {
        return this.colors.get((Object)NapkinThemeColor.BACKGROUND_COLOR);
    }

    public Color getColor(NapkinThemeColor which) {
        return this.colors.get((Object)which);
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public Font getBoldTextFont() {
        return this.boldTextFont;
    }

    public Font getFixedFont() {
        return this.fixedFont;
    }

    public AbstractSketcher getSketcher() {
        return this.sketcher;
    }

    public NapkinBackground getPaper() {
        return this.paper;
    }

    public NapkinBackground getErasureMask() {
        return this.erasure;
    }

    public NapkinTheme getPopupTheme() {
        return this.getTheme(NapkinKnownTheme.POPUP_THEME);
    }

    public NapkinTheme getBasicTheme() {
        return this.getTheme(NapkinKnownTheme.BASIC_THEME);
    }

    public NapkinTheme getTheme(NapkinKnownTheme which) {
        return this.variants.get((Object)which);
    }

    public String toString() {
        return this.name;
    }

    public Color colorFor(NapkinThemeColor color) {
        switch (color) {
            case BACKGROUND_COLOR: {
                return this.getBackgroundColor();
            }
            case CHECK_COLOR: {
                return this.getCheckColor();
            }
            case HIGHLIGHT_COLOR: {
                return this.getHighlightColor();
            }
            case PEN_COLOR: {
                return this.getPenColor();
            }
            case RADIO_COLOR: {
                return this.getRadioColor();
            }
            case ROLLOVER_COLOR: {
                return this.getRolloverColor();
            }
            case SELECTION_COLOR: {
                return this.getSelectionColor();
            }
        }
        throw new IllegalArgumentException((Object)((Object)color) + ": Unknown color type");
    }

    public static class Manager {
        private static final Map<String, NapkinTheme> themes = new HashMap<String, NapkinTheme>();
        private static NapkinTheme currentTheme;
        private static final String DEFAULT_THEME = "napkin";
        private static final String RESOURCE_PATH = "resources/";
        private static final Class<NapkinLookAndFeel> THIS_CLASS;
        private static final Logger LOG;
        private static final String DEBUG_THEME = "debug";
        private static final String BLUEPRINT_THEME = "blueprint";

        private static void setup() {
            String themeName;
            Color checkGreen = Color.GREEN.darker();
            Font scrawl = Manager.tryToLoadFont("FeltTipRoman.ttf");
            Font scrawlBold = Manager.tryToLoadFont("FeltTipRoman-Bold.ttf");
            Font fixed = Manager.tryToLoadFont("1942.ttf");
            Font augie = Manager.tryToLoadFont("augie.ttf");
            String image = "postit.jpg";
            int scrawlSize = 14;
            NapkinTheme def = new NapkinTheme(DEFAULT_THEME, "Default theme", Color.BLACK, checkGreen, new Color(0xF50000), new Color(0, 255, 255, 128), new Color(255, 255, 0, 128), checkGreen, scrawl.deriveFont(0, scrawlSize), scrawlBold.deriveFont(1, scrawlSize), fixed.deriveFont(0, scrawlSize), new JotSketcher(), Manager.background("napkin.jpg"), Manager.background("erasure.png"), Manager.background(image, 80, 80, 50, 40), new Color(255, 0, 255, 128));
            Manager.addTheme(def);
            Manager.addTheme(new NapkinTheme(DEBUG_THEME, "Debug theme", def.getPenColor(), def.getCheckColor(), def.getRadioColor(), def.getHighlightColor(), def.getSelectionColor(), def.getPopupTheme().getHighlightColor(), def.getTextFont(), def.getBoldTextFont(), def.getFixedFont(), new JotSketcher(), Manager.background("testPaper.jpg", 0, 0, 10, 10), def.getErasureMask(), Manager.background("testPostit.jpg", 0, 0, 10, 10), def.getRolloverColor()));
            Color blueprintInk = new Color(15199730);
            Color blueprintHighlight = new Color(9025005);
            Font blueFont = augie.deriveFont(0, 11.0f);
            Manager.addTheme(new NapkinTheme(BLUEPRINT_THEME, "Blueprint", Color.white, blueprintInk, blueprintInk, blueprintHighlight, blueprintHighlight, blueprintInk, blueFont, blueFont, def.getFixedFont(), new DraftSketcher(), Manager.background("blueprint-bg.jpg"), def.getErasureMask(), def.getPopupTheme()));
            try {
                themeName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("net.sourceforge.napkinlaf.theme", Manager.DEFAULT_THEME);
                    }
                });
            }
            catch (SecurityException e) {
                e.printStackTrace();
                themeName = null;
            }
            if (themeName == null) {
                themeName = DEFAULT_THEME;
            }
            if ((currentTheme = Manager.getTheme(themeName)) == null) {
                currentTheme = Manager.getTheme(DEFAULT_THEME);
            }
        }

        private static NapkinBackground background(String image, int top, int left, int bottom, int right) {
            ImageIcon icon = Manager.getBackgroundImage(RESOURCE_PATH + image);
            return new NapkinBackground(icon, top, left, bottom, right);
        }

        private static NapkinBackground background(String image) {
            ImageIcon icon = Manager.getBackgroundImage(RESOURCE_PATH + image);
            return new NapkinBackground(icon);
        }

        private static ImageIcon getBackgroundImage(String name) {
            URL resource = NapkinLookAndFeel.class.getResource(name);
            if (resource == null) {
                throw new NullPointerException("no resource found for: " + name);
            }
            Image image = Toolkit.getDefaultToolkit().getImage(resource);
            return new ImageIcon(image, name);
        }

        public static String[] themeNames() {
            return themes.keySet().toArray(new String[themes.size()]);
        }

        public static NapkinTheme getTheme(String name) {
            return themes.get(name);
        }

        public static NapkinTheme getDefaultTheme() {
            return Manager.getTheme(DEFAULT_THEME);
        }

        public static NapkinTheme getCurrentTheme() {
            return currentTheme;
        }

        public static void setCurrentTheme(NapkinTheme theme) {
            currentTheme = theme != null ? theme : Manager.getDefaultTheme();
        }

        public static void setCurrentTheme(String themeName) {
            NapkinTheme theme = Manager.getTheme(themeName);
            if (theme == null) {
                throw new IllegalArgumentException("unknown theme");
            }
            Manager.setCurrentTheme(theme);
        }

        public static void addTheme(NapkinTheme theme) {
            themes.put(theme.getName(), theme);
        }

        static Font tryToLoadFont(String fontName) {
            Font result = null;
            try {
                String fontRes = RESOURCE_PATH + fontName;
                InputStream fontDef = NapkinLookAndFeel.class.getResourceAsStream(fontRes);
                if (fontDef == null) {
                    String msg = "Could not find font resource \"" + fontName + "\"\n\t\tin \"" + fontRes + "\"\n\t\tfor \"" + NapkinLookAndFeel.class.getName() + "\"\n\t\ttry: " + NapkinLookAndFeel.class.getResource(fontRes);
                    System.err.println(msg);
                    throw new NullPointerException(msg);
                }
                result = Font.createFont(0, fontDef);
            }
            catch (FontFormatException e) {
                LOG.log(Level.WARNING, "getting font " + fontName, e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "getting font " + fontName, e);
            }
            return result;
        }

        static {
            THIS_CLASS = NapkinLookAndFeel.class;
            LOG = LogManager.getLogManager().getLogger(THIS_CLASS.getName());
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Manager.setup();
                    return null;
                }
            });
        }
    }
}

