/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.mainframe;

import java.awt.Image;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class AppleApplicationTools {
    private final ILogger log = LoggerController.createLogger(AppleApplicationTools.class);

    AppleApplicationTools() {
    }

    public boolean isAppleEnvironment() {
        try {
            Class.forName("com.apple.eawt.Application");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void setDockIconImage(Image image) {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Object application = applicationClass.getMethod("getApplication", new Class[0]).invoke(applicationClass, new Object[0]);
            applicationClass.getMethod("setDockIconImage", Image.class).invoke(application, image);
        }
        catch (Exception e) {
            this.log.debug("Skipping to set application dock icon for Mac OS X, because didn't found 'com.apple.eawt.Application' class.", e);
        }
    }
}

