/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class ObjectTreeTabbedPane {
    private static final ILogger log = LoggerController.createLogger(ObjectTreeTabbedPane.class);
    private final JTabbedPane _tabPnl = UIFactory.getInstance().createTabbedPane();
    private final IApplication _app;
    private final IIdentifier _sessionId;
    private List<IObjectTab> _tabs = new ArrayList<IObjectTab>();

    ObjectTreeTabbedPane(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._sessionId = session.getIdentifier();
        this._app = session.getApplication();
        this._tabPnl.putClientProperty(IClientPropertiesKeys.TABBED_PANE_OBJ, this);
    }

    JTabbedPane getTabbedPane() {
        return this._tabPnl;
    }

    IObjectTab getTabIfSelected(String title) {
        IObjectTab tab = this.getSelectedTab();
        if (tab != null && tab.getTitle().equals(title)) {
            return tab;
        }
        return null;
    }

    IObjectTab getSelectedTab() {
        IObjectTab tab = this._tabs.get(this._tabPnl.getSelectedIndex());
        return tab;
    }

    synchronized void addObjectPanelTab(IObjectTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IObjectTab passed");
        }
        if (this._tabs.size() == 1 && this._tabPnl.getTabCount() == 0) {
            log.debug("addObjectPanelTab: _tabs.size() == 1, but _tabPnl.getTabCount() == 0 - adding first tab component to the tabbed page");
            IObjectTab firstTab = this._tabs.get(0);
            this._tabPnl.addTab(firstTab.getTitle(), null, firstTab.getComponent(), firstTab.getHint());
        }
        tab.setSession(this._app.getSessionManager().getSession(this._sessionId));
        String title = tab.getTitle();
        this._tabPnl.addTab(title, null, tab.getComponent(), tab.getHint());
        this._tabs.add(tab);
    }

    void selectCurrentTab() {
        IObjectTab tab;
        int idx;
        if (this._tabPnl.getParent() != null && (idx = this._tabPnl.getSelectedIndex()) != -1 && idx < this._tabs.size() && (tab = this._tabs.get(idx)) != null) {
            tab.select();
        }
    }

    void setDatabaseObjectInfo(IDatabaseObjectInfo dboInfo) {
        for (IObjectTab tab : this._tabs) {
            tab.setDatabaseObjectInfo(dboInfo);
        }
    }

    synchronized void rebuild() {
        int curTabIdx = this._tabPnl.getSelectedIndex();
        ArrayList<IObjectTab> oldTabs = new ArrayList<IObjectTab>();
        oldTabs.addAll(this._tabs);
        this._tabPnl.removeAll();
        this._tabs.clear();
        for (IObjectTab tab : oldTabs) {
            tab.rebuild();
            this.addObjectPanelTab(tab);
        }
        if (curTabIdx >= 0 && curTabIdx < this._tabPnl.getTabCount()) {
            this._tabPnl.setSelectedIndex(curTabIdx);
        }
    }

    static interface IClientPropertiesKeys {
        public static final String TABBED_PANE_OBJ = ObjectTreeTabbedPane.class.getName() + "/TabPaneObj";
    }
}

