/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.io.Serializable;
import java.util.Comparator;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.Completion;

public abstract class SQLCompletion
implements Completion {
    public static final int NO_POSITION = -1;
    public static final int NO_LIMIT = 99999;
    public static final String[] EMPTY_RESULT = new String[0];
    protected int startPosition = -1;
    protected int endPosition = 99999;

    protected SQLCompletion(int startPosition) {
        this.startPosition = startPosition;
    }

    protected SQLCompletion() {
    }

    @Override
    public Completion getCompletion(int position) {
        return this.isEnclosed(position) ? this : null;
    }

    protected boolean isConcrete() {
        return true;
    }

    public void setEndPosition(int position) {
        this.endPosition = position;
    }

    @Override
    public String getText(int position) {
        throw new UnsupportedOperationException("completion not available");
    }

    @Override
    public String getText(int position, String options) {
        throw new UnsupportedOperationException("completion not available");
    }

    @Override
    public boolean hasTextPosition() {
        return this.startPosition != -1 && this.endPosition != -1;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public int getLength() {
        return this.endPosition - this.startPosition + 1;
    }

    @Override
    public int getStart() {
        return this.startPosition;
    }

    @Override
    public boolean mustReplace(int position) {
        return false;
    }

    protected boolean isEnclosed(int position) {
        return position >= this.startPosition && position <= this.endPosition;
    }

    public static class ChildComparator
    implements Comparator<SQLCompletion>,
    Serializable {
        private static final long serialVersionUID = -8912522485515591605L;

        @Override
        public int compare(SQLCompletion c1, SQLCompletion c2) {
            if (c1.isConcrete() == c2.isConcrete()) {
                return c2.startPosition - c1.startPosition;
            }
            return c1.isConcrete() ? -1 : 1;
        }
    }
}

